/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.util;

import java.util.Arrays;
import org.jetbrains.kotlin.js.util.TextOutput;

public class TextOutputImpl
implements TextOutput {
    private int identLevel = 0;
    private char[][] indents = new char[][]{new char[0]};
    private boolean justNewlined;
    private final StringBuilder out = new StringBuilder();
    private int position = 0;
    private int line = 0;
    private int column = 0;

    public String toString() {
        return this.out.toString();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void indentIn() {
        ++this.identLevel;
        if (this.identLevel >= this.indents.length) {
            char[] newIndentLevel = new char[this.identLevel * 2];
            Arrays.fill(newIndentLevel, ' ');
            char[][] newIndents = new char[this.indents.length + 1][];
            System.arraycopy(this.indents, 0, newIndents, 0, this.indents.length);
            newIndents[this.identLevel] = newIndentLevel;
            this.indents = newIndents;
        }
    }

    @Override
    public void indentOut() {
        --this.identLevel;
    }

    @Override
    public void newline() {
        this.out.append('\n');
        ++this.position;
        ++this.line;
        this.column = 0;
        this.justNewlined = true;
    }

    @Override
    public void print(double value2) {
        this.maybeIndent();
        int oldLength = this.out.length();
        this.out.append(value2);
        this.movePosition(this.out.length() - oldLength);
    }

    @Override
    public void print(int value2) {
        this.maybeIndent();
        int oldLength = this.out.length();
        this.out.append(value2);
        this.movePosition(this.out.length() - oldLength);
    }

    @Override
    public void print(char c2) {
        this.maybeIndent();
        this.out.append(c2);
        this.movePosition(1);
    }

    private void movePosition(int l2) {
        this.position += l2;
        this.column += l2;
    }

    @Override
    public void print(char[] s2) {
        this.maybeIndent();
        this.printAndCount(s2);
    }

    @Override
    public void print(CharSequence s2) {
        this.maybeIndent();
        this.printAndCount(s2);
    }

    @Override
    public void maybeIndent() {
        if (this.justNewlined) {
            this.printAndCount(this.indents[this.identLevel]);
            this.justNewlined = false;
        }
    }

    private void printAndCount(CharSequence charSequence) {
        this.position += charSequence.length();
        this.column += charSequence.length();
        this.out.append(charSequence);
    }

    private void printAndCount(char[] chars) {
        this.position += chars.length;
        this.column += chars.length;
        this.out.append(chars);
    }
}

