/*******************************************************************************
 * Copyright 2016 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#if !defined(__BASE_PROC__)
  #define __BASE_PROC__

  #include "base.h"
  #include "base_image.h"

class BaseParallelInterface;

enum ParallelInterface {
    PARALLEL_NONE = 0,
    PARALLEL_TBB,
    PARALLEL_OMP,
    PARALLEL_ANY
};

static const char *ParallelToString(ParallelInterface parallel)
{
    if (parallel == PARALLEL_NONE)
        return "no parallel interface is selected or available";
    else if (parallel == PARALLEL_TBB)
        return "Intel(R) Threading Building Blocks (Intel(R) TBB)";
    else if (parallel == PARALLEL_OMP)
        return "OpenMP";
    else
        return "undefined";
}

class BaseProc
{
public:
    BaseProc();
    virtual ~BaseProc();

    Status SetParallelInterface(ParallelInterface parallel);
    Status RemoveParallelInterface();

    virtual unsigned int ThreadsGetNum();
    virtual void ThreadsSetNum(unsigned int threads);

    virtual Status Run(Image &src, Image &dst, Rect tile) = 0;

    virtual Status Run(Image &src, Image &dst) { return Run(src, dst, Rect(dst.m_size.width, dst.m_size.height)); }

    virtual Status RunParallel(Image &src, Image &dst, Size tile);

    static ParallelInterface CheckParallelInterface(ParallelInterface parallel);

public:
    ParallelInterface m_parallelType;
    DString m_className;

private:
    BaseParallelInterface *m_pParallel;

    BaseProc(const BaseProc &);
    BaseProc &operator=(const BaseProc &);
};

#endif
