/*******************************************************************************
 * Copyright 2020 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *
 *******************************************************************************/

#ifndef PIFMEDIAN_T_H__
#define PIFMEDIAN_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_t.h"

#ifdef USE_OMP
  #include <omp.h>
#endif

#define ALIGNED_SIZE(p) IPP_ALIGNED_SIZE(p, 32)
#define ALIGNED_PTR(p)  IPP_ALIGNED_PTR(p, 32)

#define TYLE_S (maskSize.height + 1)

#define MASK_SIZE_P1 (maskSize.width * TYLE_S)

#define SMALL_MASK_SIZE_LIMIT 12
#define MED_MASK_SIZE_LIMIT   25
#define LARGE_MASK_SIZE_LIMIT 64

#define WIDTH_LIMIT_1 240
#define WIDTH_LIMIT_2 64
#define WIDTH_LIMIT_3 32
#define WIDTH_LIMIT_4 16

typedef struct _ippiFilterMedian_8u_C1R_T_Str {
    const Ipp8u *pSrc;
    int srcStep;
    Ipp8u *pDst;
    int dstStep;
    IppiSize maskSize;
    IppiBorderType borderType;
    Ipp8u borderValue;
    Ipp8u *pBuffer;
    IppiPoint splitImage;
    IppiSize sliceSize;
    IppiSize lastSliceSize;
    int sliceBufferSize;
} ippiFilterMedian_8u_C1R_T_Str;

typedef struct _ippiFilterMedian_8u_C3R_AC4R_T_Str {
    const Ipp8u *pSrc;
    int srcStep;
    Ipp8u *pDst;
    int dstStep;
    IppiSize maskSize;
    IppiBorderType borderType;
    Ipp8u borderValue[3];
    Ipp8u *pBuffer;
    IppiPoint splitImage;
    IppiSize sliceSize;
    IppiSize lastSliceSize;
    int sliceBufferSize;
} ippiFilterMedian_8u_C3R_AC4R_T_Str;

typedef struct _ippiFilterMedian_8u_C4R_T_Str {
    const Ipp8u *pSrc;
    int srcStep;
    Ipp8u *pDst;
    int dstStep;
    IppiSize maskSize;
    IppiBorderType borderType;
    Ipp8u borderValue[4];
    Ipp8u *pBuffer;
    IppiPoint splitImage;
    IppiSize sliceSize;
    IppiSize lastSliceSize;
    int sliceBufferSize;
} ippiFilterMedian_8u_C4R_T_Str;

static void filterMedianThreadingStructureEncode_8u_C1R(const Ipp8u *pSrc, int srcStep, Ipp8u *pDst, int dstStep, IppiSize maskSize,
                                                        IppiBorderType borderType, Ipp8u borderValue, Ipp8u *pBuffer, IppiPoint splitImage,
                                                        IppiSize sliceSize, IppiSize lastSliceSize, int sliceBufferSize,
                                                        ippiFilterMedian_8u_C1R_T_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->maskSize = maskSize;
    ts->borderType = borderType;
    ts->borderValue = borderValue;
    ts->pBuffer = pBuffer;
    ts->splitImage = splitImage;
    ts->sliceSize = sliceSize;
    ts->lastSliceSize = lastSliceSize;
    ts->sliceBufferSize = sliceBufferSize;
}

static void filterMedianThreadingStructureEncode_8u_C3R_AC4R(const Ipp8u *pSrc, int srcStep, Ipp8u *pDst, int dstStep, IppiSize maskSize,
                                                             IppiBorderType borderType, const Ipp8u borderValue[3], Ipp8u *pBuffer,
                                                             IppiPoint splitImage, IppiSize sliceSize, IppiSize lastSliceSize, int sliceBufferSize,
                                                             ippiFilterMedian_8u_C3R_AC4R_T_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->maskSize = maskSize;
    ts->borderType = borderType;
    ts->borderValue[0] = borderValue[0];
    ts->borderValue[1] = borderValue[1];
    ts->borderValue[2] = borderValue[2];
    ts->pBuffer = pBuffer;
    ts->splitImage = splitImage;
    ts->sliceSize = sliceSize;
    ts->lastSliceSize = lastSliceSize;
    ts->sliceBufferSize = sliceBufferSize;
}

static void filterMedianThreadingStructureEncode_8u_C4R(const Ipp8u *pSrc, int srcStep, Ipp8u *pDst, int dstStep, IppiSize maskSize,
                                                        IppiBorderType borderType, const Ipp8u borderValue[4], Ipp8u *pBuffer, IppiPoint splitImage,
                                                        IppiSize sliceSize, IppiSize lastSliceSize, int sliceBufferSize,
                                                        ippiFilterMedian_8u_C4R_T_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->maskSize = maskSize;
    ts->borderType = borderType;
    ts->borderValue[0] = borderValue[0];
    ts->borderValue[1] = borderValue[1];
    ts->borderValue[2] = borderValue[2];
    ts->borderValue[3] = borderValue[3];
    ts->pBuffer = pBuffer;
    ts->splitImage = splitImage;
    ts->sliceSize = sliceSize;
    ts->lastSliceSize = lastSliceSize;
    ts->sliceBufferSize = sliceBufferSize;
}

#endif // PIFMEDIAN_T_H__
