import datetime
class ETATracker:
 def __init__(self,start,stop,ratio_step,time_step,step_name):
  self.ratio_step=ratio_step
  self.time_step=time_step
  self.start_val=start
  self.final_val=stop
  self.len=stop-start
  self.step_name=step_name
  self.line_len=0
  self.ratio=None
  self.start_time=None
  self.prev_time=None
  self.eta=None
 def print_state(self,output,last=False):
  if last:
   print(f'{output:<{self.line_len}}')
  else:
   print(f'{output:<{self.line_len}}\r',end='')
  self.line_len=len(output)
 def update_ratio(self,val):
  ratio=(val-self.start_val)/self.len
  if self.start_time is None:
   self.start_time=self.prev_time=datetime.datetime.now()
   self.ratio=ratio
   if self.step_name:
    self.print_state(f'Started stage \'{self.step_name}\'')
  if abs(ratio-self.ratio)>self.ratio_step:
   time=datetime.datetime.now()
   if ratio and(time-self.prev_time).total_seconds()>self.time_step:
    elapsed=time-self.start_time
    self.eta=elapsed.total_seconds()/ratio*(1-ratio)
    self.ratio=ratio
    self.prev_time=time
    if self.step_name:
     if self.eta<120:
      eta_str='{:.0f} sec'.format(self.eta)
     elif self.eta<120*60:
      eta_str='{:.0f} min'.format(self.eta/60)
     else:
      eta_str='{:.0f} hours'.format(self.eta/3600)
     ratio=self.ratio*100
     elapsed=datetime.timedelta(seconds=int(elapsed.total_seconds()))
     self.print_state(f'Processed {ratio:5.1f}% of \'{self.step_name}\'. '+f'Elapsed: {elapsed} ETA: {eta_str}')
 def finalize(self):
  if self.step_name:
   time=datetime.datetime.now()
   if self.start_time:
    elapsed=datetime.timedelta(seconds=int((time-self.start_time).total_seconds()))
    self.print_state(f'Finished stage \'{self.step_name}\' in {elapsed}',last=True)
  self.ratio=None
  self.eta=None
  self.start_time=None
  self.prev_time=None
 def __del__(self):
  self.finalize()
