try:
 import advisor
except ImportError as msg:
 no_pythonapi_msg="""
    Python could not resolve path to Advisor\'s Python API directory. To fix, either manually add path
    to the Python API directory into PYTHONPATH environment variable, or use advixe-vars.* scripts to
    set up product environment variables automatically.
    """
 raise ImportError("\n    {}\n{}".format(msg,no_pythonapi_msg))
import os
import sys
import re
from debug import myprint
from collections import defaultdict
from.base_row import BaseRow
from.cpu_row import CpuRow,HotspotRow,create_joint_row_cls,get_splitted_loops as get_cpu_splitted_loops
from.import gpu_row
GpuRow=gpu_row.GpuRow
from.import cpurow_helpers as Row
from.collection import RegularCacheSimulator,get_cacheconfig_target
from apm_helpers.cmdline import is_loop_in_selection
from apm_helpers.decorator import cached_cls_row_prop,cached_cls_prop
from apm_helpers.messages import Messages as msg
NonOffloadReasons=msg.NonOffload.Reasons
maxsize=float('inf')
class OAVersionChecker:
 def __init__(self,build):
  self.build=build
  self.versions=advisor.get_versions()
 def has_versions(self):
  if 'product' in self.versions and 'build' in self.versions['product']:
   return True
  return False
 def check_advisor_version(self):
  if int(self.versions['product']['build'])>=self.build:
   return True
  return False
 def get_advisor_version(self):
  api=self.versions['product']
  return '.'.join([str(api[key])for key in['major','minor','revision','build']])
def get_joint_row_types(row):
 class MetadataTypes:
  pass
 res=MetadataTypes
 metadata_types=row.metadata_types
 res.is_loop=bool(metadata_types&advisor.RowType.LOOP)
 res.is_not_executed=bool(metadata_types&advisor.RowType.NOT_EXECUTED_LOOP)
 return res
class RowStorage:
 BaseRow=BaseRow
 CpuRow=CpuRow
 JointRow=create_joint_row_cls(get_joint_row_types)
 HotspotRow=HotspotRow
 GpuRow=GpuRow
 def __init__(self):
  self._cache={}
  self.rows_marked_with_programming_model=defaultdict(set)
 def add(self,row,RowCls):
  key=RowCls.get_key(row)
  if key in self._cache:
   return self._cache[key]
  added_rows=[]
  stack=[(row,None,[])]
  while stack:
   curr_row,parent,minor_loops=stack.pop()
   curr_key=RowCls.get_key(curr_row)
   if curr_key in self._cache:
    continue
   curr_res=self._cache[curr_key]=RowCls(curr_row,curr_key,minor_loops)
   added_rows.append(curr_res)
   for x in RowCls._get_extra_rows(row):
    key=RowCls.get_key(x)
    if key not in self._cache:
     self._cache[key]=RowCls(x,key,[])
   if not parent and row.parent:
    parent_key=RowCls.get_key(row.parent)
    if parent_key in self._cache:
     parent=self._cache[parent_key]
   if parent:
    curr_res._parent=parent
    parent._children.append(curr_res)
   curr_res._fill_call_stack_based_metrics(curr_row)
   if curr_res._data['programming_model']:
    self.rows_marked_with_programming_model[curr_res._data['programming_model']].add(curr_res)
   for x,y in RowCls.filter_children(curr_row):
    stack.append((x,curr_res,y))
  return added_rows
class OAWrapper:
 instruction_mix_getter={'ins':'executed_instruction_count','ops':'dynamic_instruction_count'}
 default_instruction_mix='ins'
 head_rows_getter={'topdown':lambda x:x.get_cpu_topdown(),'gpu':lambda x:x.get_gpu_rows(),'gpu_roofline':lambda x:x.get_gpu_rows_with_hierarchy(),'joint_topdown':lambda x:x.get_joint_topdown(),}
 default_head_rows='joint_topdown'
 DEFAULT_MODE='LOCK'
 try:
  open_modes={'LOCK':advisor.Project.LOCK,'NONLOCK':advisor.Project.NONLOCK}
 except AttributeError:
  open_modes={}
 DEVICE_TYPE=advisor.DeviceType
 check_bottom_up=True
 force_bottom_up=False
 force_ignore_assembly=False
 gpu_device_props={}
 ignored_module_types=[]
 def get_gpu_baseline_device_id(self):
  gpuPciDeviceId=''
  try:
   key='gpuPciDeviceId'
   deviceId=int(self.surv_cfg_info.get(key))
  except TypeError:
   myprint(msg.ERROR_NO_VALUE_IN_CONTEXT_VARIABLE.format(key),severity=4)
  gpuPciDeviceId='x{0:04X}'.format(deviceId)
  return gpuPciDeviceId
 def __init__(self,adv_project,platform,extra_args=None,relaxed=False):
  self.project=adv_project
  self.platform=platform
  self.host=platform.host
  Row.set_no_stacks_mode(OAWrapper.force_bottom_up)
  self._data=None
  self.cpu_frequency=None
  if not self.project.empty:
   try:
    self._data=self.project.load(advisor.ALL&~advisor.RECOMMENDATIONS)
    self.cpu_frequency=int(self.project.system_info.get('cpu_frequency','0'))
    self.surv_cfg_info=self._data.get_cfg_info(advisor.ResultType.Survey)
    self.trc_cfg_info=self._data.get_cfg_info(advisor.ResultType.TripCounts)
   except IOError as e:
    print('{}'.format(e))
    sys.exit(-1)
  self.small_node_filter=getattr(extra_args,"small_node_filter",None)
  self.select_loops=getattr(extra_args,"select_loops",None)
  self.markup=getattr(extra_args,"markup",None)
  self.markup_keys=getattr(extra_args,"markup_keys",None)
  self.arch=getattr(extra_args,"arch",None)
  self.enforce_offloads=getattr(extra_args,"enforce_offloads",None)
  self.extend_resource_constraint_by=getattr(extra_args,"extend_resource_constraint_by",None)
  self.include_noncompute=getattr(extra_args,"include_noncompute",None)
  self.unroll_functions=getattr(extra_args,"unroll_functions",None)
  self.loop_filter_threshold=getattr(extra_args,"loop_filter_threshold",None)
  self.args_to_parse=getattr(extra_args,"args_to_parse",None)
  self.filtered_options=getattr(extra_args,"filtered_options",None)
  self.model_children=getattr(extra_args,"model_children",None)
  self.check_profitability=getattr(extra_args,"check_profitability",None)
  self.data_reuse_analysis=getattr(extra_args,"data_reuse_analysis",None)
  Row.set_parallel=getattr(extra_args,'set_parallel',None)
  Row.set_dependency=getattr(extra_args,'set_dependency',None)
  Row.assume_parallel=getattr(extra_args,'assume_parallel',False)
  self.relaxed=relaxed
  self.baseline_gpu_type=int(self.survey.gpu_device_type if self.survey else advisor.DeviceType.UNDEFINED)
  RowStorage.CpuRow.ignored_module_types=OAWrapper.ignored_module_types
  RowStorage.CpuRow.force_ignore_assembly=OAWrapper.force_ignore_assembly
  RowStorage.HotspotRow.check_bottom_up=OAWrapper.check_bottom_up
  self._row_storage=RowStorage()
  BaseRow.has_reuse_data=False
  self._head_rows={}
  Row.loop_occurences=self.loop_occurences
  Row.splitted_loops=get_cpu_splitted_loops
  if self.select_loops:
   self.select_loops=prune_select_loops(self.select_loops,self.head_rows)
  self.loopnests=self.construct_loop_nests(platform.accelerators[0])
  if self.survey:
   Row.programming_model_parallel=self.get_regions('regions',recursive=False)
  self.override_dependency_metrics()
  if not self.project.empty:
   self._branded_dev_name={'Host':self.project.system_info['cpu_brand_name']}
   try:
    self._branded_dev_name['GPU']='Intel (R) '+self.surv_cfg_info['gpuAdapterName']
   except KeyError:
    pass
   myprint(msg.INFO_BASELINE.format(', '.join(x+': '+y for x,y in self._branded_dev_name.items())),severity=2)
   self._main_module_name=self.find_main_module_name()
   if self._main_module_name:
    myprint(msg.INFO_BINARY_NAME.format('\''+self._main_module_name+'\''),severity=2)
   else:
    myprint(msg.INFO_BINARY_NAME.format('Unknown'),severity=2)
 @property
 def survey(self):
  return self._data
 def find_main_module_name(self):
  stack=list(self._data.topdown)
  while stack:
   x=stack.pop()
   if x['function_call_sites_and_loops']=='main':
    return x['module']
   stack+=x.children
  return None
 def get_cpu_topdown(self):
  added_rows=[]
  heads=[]
  for x in self._data.topdown:
   x_added_rows=self._row_storage.add(x,RowStorage.HotspotRow)
   added_rows+=x_added_rows
   top_row=x_added_rows[0]
   heads+=top_row.children
  cache_sizes=RegularCacheSimulator.get_simulated_cache_sizes(self._data)
  if cache_sizes:
   for row in added_rows:
    row._cacheconfig_target=get_cacheconfig_target(self._data)
    row.set_base_memory_config(cache_sizes)
  for row in added_rows:
   row._data['baseline_device']=int(advisor.DeviceType.CPU)
  return heads
 def get_joint_topdown(self):
  added_rows=[]
  heads=[]
  for x in self._data.perf_projection:
   x_added_rows=self._row_storage.add(x,RowStorage.JointRow)
   added_rows+=x_added_rows
   top_row=x_added_rows[0]
   heads+=top_row.children
  cache_sizes=RegularCacheSimulator.get_simulated_cache_sizes(self)
  if cache_sizes:
   for row in added_rows:
    row._cacheconfig_target=get_cacheconfig_target(self._data)
    row.set_base_memory_config(cache_sizes)
  for row in added_rows:
   row._data['baseline_device']=int(advisor.DeviceType.CPU)
  return heads
 def get_gpu_rows(self):
  rows_iter=self._data.gpu
  ins_mix_iter=self._data.get_gpu_rows(advisor.GpuDataType.INSTRUCTION_MIX)
  return self.get_gpu_rows_impl(rows_iter,ins_mix_iter)
 def get_gpu_rows_with_hierarchy(self):
  rows_iter=self._data.get_gpu_rows(advisor.GpuDataType.ROOFLINE)
  ins_mix_iter=self._data.get_gpu_rows(advisor.GpuDataType.ROOFLINE_INSTRUCTION_MIX)
  heads=self.get_gpu_rows_impl(rows_iter,ins_mix_iter)
  compute_tasks=[]
  for row in heads:
   if len(row.children):
    row.set_aggregated_subitems(row.children)
    compute_tasks+=row.children
  for curr_row,w in gpu_row.get_compute_task_weight(compute_tasks,'total_time').items():
   curr_row._callchain_weight=w
  return heads
 def get_gpu_rows_impl(self,rows_iterator,ins_mix_iterator):
  added_rows=[]
  heads=[]
  for c in rows_iterator:
   if c['computing_task_purpose']=='Compute':
    c_added_rows=self._row_storage.add(c,RowStorage.GpuRow)
    added_rows+=c_added_rows
    heads.append(c_added_rows[0])
  instruction_mix=defaultdict(list)
  stack=[(x,None)for x in ins_mix_iterator]
  while stack:
   curr_row,parent_key=stack.pop()
   key=RowStorage.GpuRow.get_key(curr_row)
   if key:
    stack+=[(x,key)for x in curr_row.get_children()]
   if 'instruction_class' not in curr_row:
    myprint(msg.WARNING_GPU_NO_INSTRUCTION_COUNTERS,severity=3)
    myprint(msg.DEBUG_GPU_ROW_NO_INSTRUCTION_MIX.format(curr_row))
    continue
   instruction_mix[parent_key].append(curr_row)
  cache_sizes=gpu_row.get_baseline_cache_sizes(self.surv_cfg_info,OAWrapper.gpu_device_props)
  for row in added_rows:
   row._data['baseline_device']=self.baseline_gpu_type
   curr_row=row
   while curr_row:
    curr_row.apply_instruction_mix(instruction_mix.get(row['key_column'],{}))
    curr_row=curr_row.parent
   try:
    row.select_instruction_mix(OAWrapper.instruction_mix_getter[OAWrapper.default_instruction_mix])
   except KeyError:
    myprint(msg.ERROR_NO_SOURCE_IN_INSTRUCTION_MIX.format(OAWrapper.default_instruction_mix),severity=4)
   if cache_sizes:
    row.set_base_memory_config(cache_sizes)
  try:
   gpu_sampling_interval=float(self.surv_cfg_info['gpuSamplingInterval'])*1e-3
  except(TypeError,KeyError,ValueError):
   gpu_sampling_interval=None
  if gpu_sampling_interval:
   gpu_row.check_rows_time(added_rows,self.surv_cfg_info,self.loop_filter_threshold,gpu_sampling_interval)
  return heads
 @property
 def head_rows(self):
  if OAWrapper.default_head_rows not in self._head_rows:
   if not self._data or OAWrapper.default_head_rows not in self.head_rows_getter:
    if self.relaxed:
     return[]
    myprint(msg.ERROR_NO_DATA_IN_OPEN_PROJECT,severity=4)
   self._head_rows[OAWrapper.default_head_rows]=self.head_rows_getter[OAWrapper.default_head_rows](self)
  return self._head_rows[OAWrapper.default_head_rows]
 @property
 @cached_cls_prop
 def elapsed_time(self):
  if not self.head_rows:
   myprint(msg.ERROR_NO_DATA_IN_SURVEY,severity=4)
  return sum(self.host.estimate(x)['total_elapsed_time']for x in self.head_rows)
 @property
 @cached_cls_prop
 def total_time(self):
  if not self.head_rows:
   myprint(msg.ERROR_NO_DATA_IN_SURVEY,severity=4)
  return sum(self.host.estimate(x)['total_time']for x in self.head_rows)
 @property
 @cached_cls_prop
 def measured_elapsed_time(self):
  if not self.head_rows:
   myprint(msg.ERROR_NO_DATA_IN_SURVEY,severity=4)
  return sum(float(x['total_elapsed_time'])for x in self.head_rows)
 @property
 @cached_cls_prop
 def measured_total_time(self):
  if not self.head_rows:
   myprint(msg.ERROR_NO_DATA_IN_SURVEY,severity=4)
  return sum(float(x['total_time'])for x in self.head_rows)
 @property
 def loop_occurences(self):
  if not self.head_rows:
   return{}
  res=defaultdict(lambda:0)
  for row in self.head_rows:
   rows=[row]
   while rows:
    curr=rows.pop()
    if not row.is_executed:
     continue
    key=curr['key_column']
    res[key]+=1
    rows+=curr.children
  return res
 def get_loop_nests(self):
  return self.loopnests_wo_types
 @cached_cls_row_prop
 def get_region_type(self,row):
  while row:
   for reg,reg_type in self.loopnests:
    if row['key_column']==reg['key_column']:
     return reg_type
   row=row.parent
  return None
 def get_regions(self,markup_type,recursive=True,nests=None):
  ROW_INDEX_COLUMN='unique_index'
  region_descriptions=RowStorage.JointRow.SUPPORTED_REGION_DESC if OAWrapper.default_head_rows=='joint_topdown' else RowStorage.JointRow.SUPPORTED_REGION_DESC
  if self.head_rows:
   if markup_type=='regions':
    markup={}
    for region_type in region_descriptions:
     markup.update(self.get_regions(region_type,recursive))
    return markup
   else:
    if markup_type in region_descriptions:
     markup=get_head_indices(self._row_storage.rows_marked_with_programming_model[markup_type],recursive,ROW_INDEX_COLUMN,region_descriptions[markup_type]['find_loops'],)
    elif markup_type=='generic':
     if nests is None:
      nests=self.loopnests_wo_types
     markup=get_head_indices(nests,recursive,ROW_INDEX_COLUMN,lambda x,*args:[x])
    return{x:markup_type for x in markup}
  return{}
 def get_baseline_device_info(self):
  gpu_device_types={int(advisor.DeviceType.GPU):'integrated',int(advisor.DeviceType.D_GPU):'discrete',}
  return[{'id':'baseline_cpu','type':'host','shown_name':'Baseline CPU','description':self._branded_dev_name['Host'],'is_projection':0,'type_id':int(advisor.DeviceType.CPU)},{'id':'baseline_gpu','type':gpu_device_types.get(self.baseline_gpu_type,'unknown'),'shown_name':'Baseline GPU','description':self._branded_dev_name.get('GPU','Unknown GPU'),'is_projection':0,'type_id':self.baseline_gpu_type},]
 def override_dependency_metrics(self):
  if not self.head_rows:
   return[]
  for row in self.head_rows:
   rows=[]
   rows.append(row)
   while rows:
    curr=rows.pop()
    if curr and curr.is_loop:
     lp_idx=curr['unique_index']
     lp_name=curr['source_location']
     if Row.is_loop_in_array(Row.set_dependency,lp_idx,lp_name):
      Row.fill_dependency_metrics(curr._overriden_metrics,'Dependency: User',1,'dependency_user','user')
     elif Row.is_loop_in_array(Row.set_parallel,lp_idx,lp_name):
      Row.fill_dependency_metrics(curr._overriden_metrics,'Parallel: User',maxsize,'parallel_user','user')
     elif not curr['dependency_type']or curr['dependency_type']=='Parallel: Assumed' or curr['dependency_type']=='Dependency: Assumed':
      if Row.assume_parallel or Row.is_math_module_assumed_parallel(curr):
       Row.fill_dependency_metrics(curr._overriden_metrics,'Parallel: Assumed',maxsize,'parallel_assumed','assumed')
      else:
       Row.fill_dependency_metrics(curr._overriden_metrics,'Dependency: Assumed',1,'dependency_assumed','assumed')
    rows+=curr.children
 def construct_loop_nests(self,accelerator):
  self.loopnests=[]
  self.loopnests_wo_types=[]
  if not self.head_rows:
   return[]
  loopnests=[]
  for row in self.head_rows:
   if self.markup_keys is None:
    rows=[(row,True)]
   else:
    rows=[(row,is_loop_in_selection(row,self.markup_keys))]
   while rows:
    curr,in_marked_region=rows.pop()
    if not curr.is_executed:
     continue
    do_analyze=True
    inspect_children=True
    is_marked_up=False
    if self.select_loops:
     if is_loop_in_selection(curr,self.select_loops):
      curr._is_selected=True
      curr._selected_by='user'
     else:
      do_analyze=False
    elif not self.markup and self.markup_keys:
     if is_loop_in_selection(curr,self.markup_keys):
      curr._is_selected=True
      curr._selected_by='generic'
      is_marked_up=True
     elif not in_marked_region:
      do_analyze=False
    if do_analyze:
     row_fits=accelerator.does_this_fit(curr,self.enforce_offloads,self.relaxed)
     myprint(msg.DEBUG_CONSTRUCT_LOOP_NESTS.format(curr['function_call_sites_and_loops'],curr['key_column'],row_fits,))
     if self.select_loops or row_fits:
      if not curr.is_selected:
       curr._selected_by='generic'
      loopnests.append((curr,curr.selected_by))
      if not self.select_loops:
       inspect_children=False
    if inspect_children:
     for child in curr.children:
      rows.append((child,in_marked_region or is_marked_up))
  self.loopnests=accelerator.update_loop_nests(self,loopnests)
  self.loopnests_wo_types=[x[0]for x in self.loopnests]
  if self.markup_keys is None:
   markup_rows=list((row,True)for row in self.head_rows)
  else:
   markup_rows=list((row,is_loop_in_selection(row,self.markup_keys))for row in self.head_rows)
  while markup_rows:
   curr,in_marked_region=markup_rows.pop()
   if in_marked_region:
    curr._is_marked_up=True
   for child in curr.children:
    markup_rows.append((child,in_marked_region or child['unique_index']in self.markup_keys))
  self.loopnests=accelerator.update_loop_nests(self,loopnests)
  self.loopnests_wo_types=[x[0]for x in self.loopnests]
  propagate_memory_objects_from_childs_to_root_regions(self.head_rows)
  return self.loopnests
def propagate_memory_objects_from_childs_to_root_regions(head_rows):
 for row in head_rows:
  tree=[row,]
  idx=0
  row._nesting_level=0
  while idx<len(tree):
   curr_row=tree[idx]
   if curr_row.parent:
    curr_row._nesting_level=curr_row.parent.nesting_level+1
   tree+=[x for x in curr_row.children]
   idx+=1
  parent_objects=defaultdict(set)
  for curr_row in reversed(tree):
   parent_row=curr_row.parent
   if curr_row.parent:
    if parent_row not in parent_objects:
     parent_objects[curr_row.parent]={x['allocation_id']:x for x in parent_row.memory_objects}
    for obj in curr_row.memory_objects:
     allocation_id=obj['allocation_id']
     if allocation_id not in parent_objects[parent_row]:
      parent_row.memory_objects.append(obj.copy())
      parent_row.memory_objects[-1]['object_access_type']='inherited'
      parent_row.memory_objects[-1]['loaded_by_children']|=obj['loaded_by_children']or obj['object_loads']>0
      parent_row.memory_objects[-1]['stored_by_children']|=obj['stored_by_children']or obj['object_stores']>0
      parent_row.memory_objects[-1]['object_loads']=0
      parent_row.memory_objects[-1]['object_stores']=0
      parent_row.memory_objects[-1]['transfer_direction']='private'
      parent_objects[parent_row][allocation_id]=parent_row.memory_objects[-1]
     else:
      parent_objects[parent_row][allocation_id]['loaded_by_children']|=obj['loaded_by_children']or obj['object_loads']>0
      parent_objects[parent_row][allocation_id]['stored_by_children']|=obj['stored_by_children']or obj['object_stores']>0
      if parent_objects[parent_row][allocation_id]['object_access_type']=='inherited':
       for key,op in[('min_access_counter',min),('max_access_counter',max),('min_modification_counter',min),('max_modification_counter',max),]:
        parent_objects[parent_row][allocation_id][key]=op(parent_objects[parent_row][allocation_id][key],obj[key])
def prune_select_loops(select_loops,head_rows):
 if not select_loops:
  return None
 selected_loops=[]
 user_select_loops=select_loops[:]
 rows_to_prune=[]
 for row in head_rows:
  rows_to_prune.append((row,False))
 while rows_to_prune:
  curr,inside_selected=rows_to_prune.pop()
  is_selected=is_loop_in_selection(curr,user_select_loops)
  if is_selected:
   if inside_selected:
    myprint(msg.WARNING_SELECTING_LOOP_INSIDE_SELECTED_REGION.format(curr['function_call_sites_and_loops'],curr['unique_index']),severity=3)
   else:
    if curr['unique_index']:
     selected_loops.append(curr['unique_index'])
  for child in curr.children:
   rows_to_prune.append((child,is_selected or inside_selected))
 if user_select_loops and not selected_loops:
  myprint(msg.WARNING_NO_USER_SELECTION_FOUND,severity=3)
 return selected_loops
def open_advisor_project(proj_dir,mpi_rank=-1,open_project_mode=OAWrapper.DEFAULT_MODE):
 project=None
 is_empty_project=True
 try:
  if not os.path.exists(proj_dir):
   project=advisor.create_project(proj_dir)
  elif os.path.isdir(proj_dir)and not os.listdir(proj_dir):
   os.rmdir(proj_dir)
   project=advisor.create_project(proj_dir)
  else:
   is_empty_project=False
   try:
    open_mode=OAWrapper.open_modes[open_project_mode]
    if mpi_rank<0:
     project=advisor.open_project(proj_dir,open_mode)
    else:
     project=advisor.open_project(proj_dir,mpi_rank,open_mode)
   except KeyError:
    if mpi_rank<0:
     project=advisor.open_project(proj_dir)
    else:
     project=advisor.open_project(proj_dir,mpi_rank)
 except IOError as e:
  print('{}'.format(e))
  sys.exit(-1)
 project.empty=is_empty_project
 return project
def get_experiment_dir(adv_project,adv_project_dir):
 try:
  exp_dir=adv_project.get_experiment_dir()
 except AttributeError:
  if adv_project.is_snapshot:
   exp_dir=adv_project_dir
  else:
   mpi_rank=adv_project.system_info['mpi_rank']
   if mpi_rank is None:
    exp_re=re.compile('^e[0-9]{3,}$')
    if exp_re.match(os.path.basename(adv_project_dir)):
     exp_dir=adv_project_dir
    else:
     exp_num=max([int(exp[1:])for exp in os.listdir(adv_project_dir)if exp_re.match(exp)])
     exp_dir=os.path.join(adv_project_dir,'e{:03d}'.format(exp_num))
   else:
    rank_dir_name='rank.{:d}'.format(mpi_rank)
    if rank_dir_name==os.path.basename(adv_project_dir):
     exp_dir=adv_project_dir
    else:
     exp_dir=os.path.join(adv_project_dir,'rank.{:d}'.format(mpi_rank))
 return exp_dir
def get_reports_dir(adv_project,adv_project_dir):
 try:
  report_dir=adv_project.get_reports_dir()
 except AttributeError:
  report_dir=get_experiment_dir(adv_project,adv_project_dir)
 return report_dir
def get_head_indices(kernels,recursive,column_name,find_loops):
 top_rows=set(kernels.copy())
 for x in kernels:
  curr_row=x.parent
  while curr_row:
   if curr_row in top_rows:
    top_rows.remove(x)
    break
   curr_row=curr_row.parent
 loops=set(x for k in top_rows for x in find_loops(k,column_name))
 indices=set(l[column_name]for l in loops)
 if recursive:
  indices.update(get_indices_of_deps(loops,column_name))
 return list(indices)
def get_indices_of_deps(top_rows,column_name):
 indices=set()
 loops=list(top_rows.copy())
 excluded_modules=['MPI','SYS','MKL','SVML']
 while loops:
  row=loops.pop()
  loops+=row.children
  if row[column_name]and row.is_loop and not row.is_vector_loop and not row.module_type in excluded_modules:
   indices.add(row[column_name])
 return set(indices)
SUPPORTED_REGION_TYPES=list(RowStorage.JointRow.SUPPORTED_REGION_DESC.keys())
