/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SpinWait;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u000b\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/util/threading/SequentialScheduler;", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "realScheduler", "(Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "getExecutionOrder", "()Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "isActive", "", "()Z", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Function0;", "", "state", "Lcom/jetbrains/rd/util/threading/SequentialScheduler$ActionKind;", "thread", "Ljava/lang/Thread;", "delegateAsIs", "flush", "action", "repost", "ActionKind", "rd-core"})
@SourceDebugExtension(value={"SMAP\nSchedulerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulerUtil.kt\ncom/jetbrains/rd/util/threading/SequentialScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PlatformDependent.kt\ncom/jetbrains/rd/util/PlatformDependentKt\n+ 4 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n*L\n1#1,181:1\n1#2:182\n84#3:183\n14#4,7:184\n*S KotlinDebug\n*F\n+ 1 SchedulerUtil.kt\ncom/jetbrains/rd/util/threading/SequentialScheduler\n*L\n172#1:183\n172#1:184,7\n*E\n"})
final class SequentialScheduler
implements IScheduler {
    @NotNull
    private final IScheduler realScheduler;
    @NotNull
    private final ConcurrentLinkedQueue<Function0<Unit>> queue;
    @Nullable
    private Thread thread;
    @NotNull
    private ActionKind state;

    public SequentialScheduler(@NotNull IScheduler realScheduler) {
        Intrinsics.checkNotNullParameter((Object)realScheduler, (String)"realScheduler");
        this.realScheduler = realScheduler;
        this.queue = new ConcurrentLinkedQueue();
        this.state = switch (WhenMappings.$EnumSwitchMapping$0[this.realScheduler.getExecutionOrder().ordinal()]) {
            case 1, 2 -> ActionKind.DelegateAsIs;
            case 3 -> ActionKind.Repost;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public ExecutionOrder getExecutionOrder() {
        return ExecutionOrder.Sequential;
    }

    @Override
    public boolean isActive() {
        return Intrinsics.areEqual((Object)this.thread, (Object)Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(@NotNull Function0<Unit> action) {
        boolean bl;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.queue.add(action);
        ConcurrentLinkedQueue<Function0<Unit>> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            boolean bl2;
            boolean bl3 = false;
            switch (WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    this.state = ActionKind.Nothing;
                    bl2 = false;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            bl = bl2;
        }
        boolean delegateAsIs2 = bl;
        if (delegateAsIs2) {
            this.delegateAsIs();
        } else {
            this.repost();
        }
    }

    private final void delegateAsIs() {
        this.realScheduler.queue((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SequentialScheduler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$catch$iv;
                ConcurrentLinkedQueue concurrentLinkedQueue = SequentialScheduler.access$getQueue$p(this.this$0);
                Object object = this.this$0;
                Object object2 = concurrentLinkedQueue;
                synchronized (object2) {
                    boolean bl = false;
                    if (SequentialScheduler.access$getState$p((SequentialScheduler)object) != ActionKind.DelegateAsIs) {
                        return;
                    }
                    if (SequentialScheduler.access$getThread$p((SequentialScheduler)object) != null) {
                        SequentialScheduler.access$setState$p((SequentialScheduler)object, ActionKind.Nothing);
                        return;
                    }
                    SequentialScheduler.access$setThread$p((SequentialScheduler)object, Thread.currentThread());
                    Unit $i$a$-synchronized-SequentialScheduler$delegateAsIs$1$3 = Unit.INSTANCE;
                }
                Function0 action = (Function0)SequentialScheduler.access$getQueue$p(this.this$0).poll();
                object = Logger.Companion.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)action, (String)"action");
                Function0 action$iv = action;
                boolean $i$f$catch = false;
                void var5_9 = $this$catch$iv;
                Object comment$iv$iv = null;
                boolean $i$f$catch2 = false;
                try {
                    action$iv.invoke();
                }
                catch (Throwable e$iv$iv) {
                    void $this$catch$iv$iv;
                    CharSequence cfr_ignored_0 = (CharSequence)comment$iv$iv;
                    String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + "";
                    LoggerKt.error((Logger)$this$catch$iv$iv, "Catch " + sfx$iv$iv, e$iv$iv);
                }
                object = SequentialScheduler.access$getQueue$p(this.this$0);
                object2 = this.this$0;
                Object object3 = object;
                synchronized (object3) {
                    boolean bl = false;
                    SequentialScheduler.access$setThread$p((SequentialScheduler)object2, null);
                    if (SequentialScheduler.access$getState$p((SequentialScheduler)object2) == ActionKind.DelegateAsIs) {
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                SequentialScheduler.access$repost(this.this$0);
            }
        }));
    }

    private final void repost() {
        boolean bl;
        boolean bl2 = bl = this.state == ActionKind.Nothing;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.realScheduler.queue((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SequentialScheduler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                SequentialScheduler.access$setThread$p(this.this$0, Thread.currentThread());
                for (int i = 0; i < 16 && (Function0)SequentialScheduler.access$getQueue$p(this.this$0).poll() != null; ++i) {
                    Logger $this$catch$iv = Logger.Companion.getRoot();
                    boolean $i$f$catch = false;
                    Logger logger = $this$catch$iv;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    try {
                        Function0 action;
                        action.invoke();
                        continue;
                    }
                    catch (Throwable e$iv$iv) {
                        void $this$catch$iv$iv;
                        CharSequence cfr_ignored_0 = (CharSequence)comment$iv$iv;
                        String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv, "Catch " + sfx$iv$iv, e$iv$iv);
                    }
                }
                SequentialScheduler.access$setThread$p(this.this$0, null);
                ConcurrentLinkedQueue concurrentLinkedQueue = SequentialScheduler.access$getQueue$p(this.this$0);
                SequentialScheduler sequentialScheduler = this.this$0;
                ConcurrentLinkedQueue concurrentLinkedQueue2 = concurrentLinkedQueue;
                synchronized (concurrentLinkedQueue2) {
                    boolean bl = false;
                    if (SequentialScheduler.access$getQueue$p(sequentialScheduler).peek() == null) {
                        SequentialScheduler.access$setState$p(sequentialScheduler, ActionKind.Repost);
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                SequentialScheduler.access$repost(this.this$0);
            }
        }));
    }

    @Override
    public void flush() {
        if (!(!this.isActive())) {
            boolean $i$a$-require-SequentialScheduler$flush$22 = false;
            String $i$a$-require-SequentialScheduler$flush$22 = "Can't flush this scheduler in a reentrant way: we are inside queued item's execution";
            throw new IllegalArgumentException($i$a$-require-SequentialScheduler$flush$22.toString());
        }
        boolean $i$f$spinUntil = false;
        SpinWait.Companion this_$iv$iv = SpinWait.Companion;
        boolean $i$f$spinUntil2 = false;
        long spins$iv$iv = 0L;
        while (true) {
            boolean bl = false;
            if (this.queue.isEmpty()) break;
            long l = spins$iv$iv;
            spins$iv$iv = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv / (long)100);
        }
    }

    @Override
    public void assertThread(@Nullable Object debugInfo) {
        IScheduler.DefaultImpls.assertThread(this, debugInfo);
    }

    @Override
    public void invokeOrQueue(@NotNull Function0<Unit> action) {
        IScheduler.DefaultImpls.invokeOrQueue(this, action);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getQueue$p(SequentialScheduler $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$repost(SequentialScheduler $this) {
        $this.repost();
    }

    public static final /* synthetic */ ActionKind access$getState$p(SequentialScheduler $this) {
        return $this.state;
    }

    public static final /* synthetic */ Thread access$getThread$p(SequentialScheduler $this) {
        return $this.thread;
    }

    public static final /* synthetic */ void access$setThread$p(SequentialScheduler $this, Thread thread2) {
        $this.thread = thread2;
    }

    public static final /* synthetic */ void access$setState$p(SequentialScheduler $this, ActionKind actionKind) {
        $this.state = actionKind;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/util/threading/SequentialScheduler$ActionKind;", "", "(Ljava/lang/String;I)V", "Nothing", "Repost", "DelegateAsIs", "rd-core"})
    private static final class ActionKind
    extends Enum<ActionKind> {
        public static final /* enum */ ActionKind Nothing = new ActionKind();
        public static final /* enum */ ActionKind Repost = new ActionKind();
        public static final /* enum */ ActionKind DelegateAsIs = new ActionKind();
        private static final /* synthetic */ ActionKind[] $VALUES;

        public static ActionKind[] values() {
            return (ActionKind[])$VALUES.clone();
        }

        public static ActionKind valueOf(String value2) {
            return Enum.valueOf(ActionKind.class, value2);
        }

        static {
            $VALUES = actionKindArray = new ActionKind[]{ActionKind.Nothing, ActionKind.Repost, ActionKind.DelegateAsIs};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExecutionOrder.values().length];
            try {
                nArray[ExecutionOrder.Sequential.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionOrder.Unknown.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionOrder.OutOfOrder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ActionKind.values().length];
            try {
                nArray[ActionKind.Nothing.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionKind.Repost.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionKind.DelegateAsIs.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

