/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGridSortingModel<Row, Column>
implements GridSortingModel<Row, Column> {
    private final List<String> myHistory;
    private final Supplier<DataGridSettings> mySettingsSupplier;
    private boolean mySortingEnabled;
    private List<RowSortOrder<ModelIndex<Column>>> myAppliedOrdering;
    protected List<RowSortOrder<ModelIndex<Column>>> myOrdering;
    private final EventDispatcher<GridSortingModel.Listener> myEventDispatcher;

    public AbstractGridSortingModel(@NotNull Supplier<DataGridSettings> settingsSupplier) {
        if (settingsSupplier == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(0);
        }
        this.myAppliedOrdering = ContainerUtil.emptyList();
        this.myOrdering = ContainerUtil.emptyList();
        this.myEventDispatcher = EventDispatcher.create(GridSortingModel.Listener.class);
        this.mySettingsSupplier = settingsSupplier;
        this.myHistory = new ArrayList<String>();
    }

    public void setAppliedOrdering(@NotNull List<RowSortOrder<ModelIndex<Column>>> appliedOrdering) {
        if (appliedOrdering == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(1);
        }
        this.myAppliedOrdering = appliedOrdering;
    }

    @NotNull
    public EventDispatcher<GridSortingModel.Listener> getEventDispatcher() {
        EventDispatcher<GridSortingModel.Listener> eventDispatcher = this.myEventDispatcher;
        if (eventDispatcher == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(2);
        }
        return eventDispatcher;
    }

    public boolean isSortingEnabled() {
        return this.mySortingEnabled;
    }

    public void setSortingEnabled(boolean enabled) {
        this.mySortingEnabled = enabled;
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    public List<RowSortOrder<ModelIndex<Column>>> getOrdering() {
        return this.myOrdering;
    }

    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<Column>>> ordering) {
        if (ordering == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(3);
        }
        this.myOrdering = new ArrayList<RowSortOrder<ModelIndex<Column>>>(ordering);
    }

    @NotNull
    public List<RowSortOrder<ModelIndex<Column>>> getAppliedOrdering() {
        return this.isSortingEnabled() ? new ArrayList<RowSortOrder<ModelIndex<Column>>>(this.myAppliedOrdering) : new SmartList();
    }

    public void apply() {
        this.myAppliedOrdering = new ArrayList<RowSortOrder<ModelIndex<Column>>>(this.myOrdering);
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    protected void addToHistory(@NotNull String text) {
        if (text == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(4);
        }
        this.myHistory.remove(text);
        this.myHistory.add(0, text);
        this.trimHistory();
    }

    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(5);
        }
        this.myHistory.clear();
        this.myHistory.addAll(history);
    }

    private void trimHistory() {
        DataGridSettings settings = this.mySettingsSupplier.get();
        int historySize = Math.max(0, settings == null ? 10 : settings.getFiltersHistorySize());
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    @Nullable
    public Document getDocument() {
        return null;
    }

    @NotNull
    public List<String> getHistory() {
        List<String> list = this.myHistory;
        if (list == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void addListener(@NotNull GridSortingModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(8);
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    public void firePrefixUpdated() {
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).onPrefixUpdated();
    }

    public void firePSIUpdated() {
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).onPsiUpdated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedOrdering";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/AbstractGridSortingModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/AbstractGridSortingModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDispatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAppliedOrdering";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOrdering";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHistory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

