/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ImmutableDataHookUp;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public abstract class PageAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PageAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected abstract boolean isEnabled(GridPagingModel<GridRow, GridColumn> var1);

    protected abstract void actionPerformed(GridRequestSource var1, GridLoader var2);

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            PageAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null || dataGrid.getDataHookup() instanceof DocumentDataHookUp) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = dataGrid.isReady() && this.isEnabled((GridPagingModel<GridRow, GridColumn>)dataGrid.getDataHookup().getPageModel());
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(this.isVisible(e, dataGrid) && (enabled || !"EditorPopup".equals(e.getPlace())));
    }

    protected boolean isVisible(@NotNull AnActionEvent e, DataGrid dataGrid) {
        if (e == null) {
            PageAction.$$$reportNull$$$0(2);
        }
        return !GridUtil.hidePageActions(dataGrid, e.getPlace());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GridMutator mutator;
        DataGrid dataGrid;
        if (e == null) {
            PageAction.$$$reportNull$$$0(3);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        if (!dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
        if ((mutator = dataGrid.getDataHookup().getMutator()) == null || !mutator.hasPendingChanges() || GridUtil.showIgnoreUnsubmittedChangesYesNoDialog(dataGrid)) {
            this.actionPerformed(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)dataGrid)), dataGrid.getDataHookup().getLoader());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/PageAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/PageAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public static class Previous
    extends NavigationAction {
        @Override
        protected boolean isEnabled(GridPagingModel<GridRow, GridColumn> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader loader) {
            loader.loadPreviousPage(source);
        }
    }

    public static class Next
    extends NavigationAction {
        @Override
        protected boolean isEnabled(GridPagingModel<GridRow, GridColumn> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader loader) {
            loader.loadNextPage(source);
        }
    }

    public static class Last
    extends NavigationAction {
        @Override
        protected boolean isEnabled(GridPagingModel<GridRow, GridColumn> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader loader) {
            loader.loadLastPage(source);
        }
    }

    public static class First
    extends NavigationAction {
        @Override
        protected boolean isEnabled(GridPagingModel<GridRow, GridColumn> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader loader) {
            loader.loadFirstPage(source);
        }
    }

    public static abstract class NavigationAction
    extends PageAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NavigationAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            NavigationAction.additionalUpdateVisibilityCheck(e);
            FloatingPagingManager.adjustAction(e);
        }

        private static void additionalUpdateVisibilityCheck(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                NavigationAction.$$$reportNull$$$0(1);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
            int pageSize = pageModel.getPageSize();
            if (pageSize == -1) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            long totalRowCount = pageModel.getTotalRowCount();
            if ((long)pageSize >= totalRowCount) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/run/actions/PageAction$NavigationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "additionalUpdateVisibilityCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Reload
    extends PageAction {
        @Override
        protected boolean isEnabled(GridPagingModel<GridRow, GridColumn> pageModel) {
            return true;
        }

        @Override
        protected boolean isVisible(@NotNull AnActionEvent e, DataGrid dataGrid) {
            if (e == null) {
                Reload.$$$reportNull$$$0(0);
            }
            return super.isVisible(e, dataGrid) && !(dataGrid.getDataHookup() instanceof ImmutableDataHookUp);
        }

        @Override
        protected void actionPerformed(GridRequestSource source, GridLoader loader) {
            loader.reloadCurrentPage(source);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/PageAction$Reload", "isVisible"));
        }
    }
}

