/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.compression;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorProvider;
import io.opentelemetry.exporter.internal.compression.GzipCompressor;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class CompressorUtil {
    private static final Map<String, Compressor> compressorRegistry = CompressorUtil.buildCompressorRegistry();

    private CompressorUtil() {
    }

    @Nullable
    public static Compressor validateAndResolveCompressor(String compressionMethod) {
        Set<String> supportedEncodings = compressorRegistry.keySet();
        Compressor compressor = compressorRegistry.get(compressionMethod);
        Utils.checkArgument("none".equals(compressionMethod) || compressor != null, "Unsupported compressionMethod. Compression method must be \"none\" or one of: " + supportedEncodings.stream().collect(Collectors.joining(",", "[", "]")));
        return compressor;
    }

    private static Map<String, Compressor> buildCompressorRegistry() {
        HashMap<String, Compressor> compressors = new HashMap<String, Compressor>();
        for (CompressorProvider spi : ServiceLoader.load(CompressorProvider.class, CompressorUtil.class.getClassLoader())) {
            Compressor compressor = spi.getInstance();
            compressors.put(compressor.getEncoding(), compressor);
        }
        compressors.put(GzipCompressor.getInstance().getEncoding(), GzipCompressor.getInstance());
        return compressors;
    }
}

