// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Converts an ArrayBufferView to an ArrayBuffer.
 * @param source - The source ArrayBufferView.
 * @returns The resulting ArrayBuffer.
 */
export function arrayBufferViewToArrayBuffer(source) {
    if (source.buffer instanceof ArrayBuffer &&
        source.byteOffset === 0 &&
        source.byteLength === source.buffer.byteLength) {
        return source.buffer;
    }
    const arrayBuffer = new ArrayBuffer(source.byteLength);
    const view = new Uint8Array(arrayBuffer);
    const sourceView = new Uint8Array(source.buffer, source.byteOffset, source.byteLength);
    view.set(sourceView);
    return view.buffer;
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/@typespec/ts-http-runtime/dist/esm/util/arrayBuffer.js.map