/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOContainer;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOListener;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOMonitor;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.utils.GeneralUtils;

public final class EFSNIOFolder
extends EFSNIOContainer
implements IFolder {
    private final String FOLDER_EMULATION_FILE_NAME = ".dbeaver-placeholder";
    private final byte[] FOLDER_EMULATION_FILE_CONTENT = "This file is created by DBeaver to guarantee support of folders instantiation and deletion.".getBytes(StandardCharsets.UTF_8);

    public EFSNIOFolder(EFSNIOFileSystemRoot root, java.nio.file.Path backendFolder) {
        super(root, backendFolder);
    }

    @Override
    public int getType() {
        return 2;
    }

    public void create(boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        this.create(force ? 1 : 0, local, monitor);
    }

    public void create(int updateFlags, boolean local, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.getRoot().getRoot().getFileSystem().supportsEmptyFolders()) {
                Files.createDirectory(this.getNioPath(), new FileAttribute[0]);
            } else {
                java.nio.file.Path fileForEmulation = Files.createFile(this.getNioPath().resolve(".dbeaver-placeholder"), new FileAttribute[0]);
                Files.write(fileForEmulation, this.FOLDER_EMULATION_FILE_CONTENT, new OpenOption[0]);
            }
            EFSNIOMonitor.notifyResourceChange(this, EFSNIOListener.Action.CREATE);
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.getRoot().getRoot().getFileSystem().supportsEmptyFolders()) {
                Files.delete(this.getNioPath());
            } else {
                for (IResource resource : this.members()) {
                    resource.delete(force, monitor);
                }
            }
            EFSNIOMonitor.notifyResourceChange(this, EFSNIOListener.Action.DELETE);
        }
        catch (IOException e) {
            if (e instanceof DirectoryNotEmptyException) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((String)("Cannot delete directory '" + String.valueOf(this.getNioPath()) + "': it is not empty"), (Throwable)e));
            }
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    public IFile getFile(String name) {
        return this.getFile((IPath)new Path(name));
    }

    public IFolder getFolder(String name) {
        return this.getFolder((IPath)new Path(name));
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }
}

