/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.notation.crowsfoot;

import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDObject;
import org.jkiss.dbeaver.model.erd.ERDUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.editors.erd.notation.crowsfoot.CrowsFootPolylineDecoration;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDAssociationType;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotation;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotationBase;
import org.jkiss.utils.CommonUtils;

public class CrowsFootDiagramNotation
extends ERDNotationBase
implements ERDNotation {
    private static final Log log = Log.getLog(CrowsFootDiagramNotation.class);

    @Override
    public void applyNotationForArrows(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
        ERDElement eRDElement;
        DBSEntityConstraintType constraintType = ((DBSEntityAssociation)association.getObject()).getConstraintType();
        if (constraintType == DBSEntityConstraintType.PRIMARY_KEY) {
            this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ZERO_OR_ONE, "0..1");
        } else if (constraintType.isAssociation() && (eRDElement = association.getSourceEntity()) instanceof ERDEntity) {
            ERDEntity src = (ERDEntity)eRDElement;
            eRDElement = association.getTargetEntity();
            if (eRDElement instanceof ERDEntity) {
                ERDEntity trg = (ERDEntity)eRDElement;
                try {
                    DBSEntity entity = (DBSEntity)src.getObject();
                    Collection indexes = ((DBSTable)entity).getIndexes(monitor);
                    if (!CommonUtils.isEmpty((Collection)indexes)) {
                        List erdSourceAttributes = association.getSourceAttributes();
                        List<DBSEntityAttribute> attributes = erdSourceAttributes.stream().map(ERDObject::getObject).toList();
                        if (DBUtils.isUniqueIndexForAttributes((DBRProgressMonitor)monitor, attributes, (DBSEntity)entity)) {
                            this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_ONLY, "1");
                        } else {
                            this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_OR_MANY, "1..n");
                        }
                    } else {
                        this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_OR_MANY, "1..n");
                    }
                    if (ERDUtils.isOptionalAssociation((ERDAssociation)association)) {
                        this.createTargetDecorator(conn, bckColor, frgColor, ERDAssociationType.ZERO_OR_ONE, "0..1");
                    } else {
                        this.createTargetDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_ONLY, "1");
                    }
                }
                catch (DBException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        conn.setLineWidth(1);
        conn.setLineStyle(6);
    }

    private void createSourceDecorator(PolylineConnection conn, Color bckColor, Color frgColor, ERDAssociationType type, String label) {
        CrowsFootPolylineDecoration sourceDecor = new CrowsFootPolylineDecoration(type);
        sourceDecor.setFill(true);
        sourceDecor.setBackgroundColor(bckColor);
        conn.setSourceDecoration((RotatableDecoration)sourceDecor);
        ConnectionEndpointLocator srcEndpointLocator = new ConnectionEndpointLocator((Connection)conn, false);
        srcEndpointLocator.setVDistance(-4);
        srcEndpointLocator.setUDistance(3);
        conn.add((IFigure)this.getLabel(label, frgColor), (Object)srcEndpointLocator);
    }

    private void createTargetDecorator(PolylineConnection conn, Color bckColor, Color frgColor, ERDAssociationType type, String label) {
        CrowsFootPolylineDecoration targetDecor = new CrowsFootPolylineDecoration(type);
        targetDecor.setFill(true);
        targetDecor.setBackgroundColor(bckColor);
        ConnectionEndpointLocator trgEndpointLocator = new ConnectionEndpointLocator((Connection)conn, true);
        trgEndpointLocator.setVDistance(-4);
        trgEndpointLocator.setUDistance(3);
        conn.add((IFigure)this.getLabel(label, frgColor), (Object)trgEndpointLocator);
        conn.setTargetDecoration((RotatableDecoration)targetDecor);
    }

    @Override
    public void applyNotationForEntities(@NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
    }

    @Override
    public double getIndentation() {
        return 30.0;
    }
}

