/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDbLink;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDirectory;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseLibrary;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMaterializedView;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseQueue;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTable;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTypeset;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseView;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseSchema
extends GenericSchema
implements DBPObjectStatisticsCollector {
    private volatile boolean hasStatistics;
    private final DbLinkCache dbLinkCache = new DbLinkCache();
    private final LibraryCache libraryCache = new LibraryCache();
    private final DirectoryCache directoryCache = new DirectoryCache();

    public AltibaseSchema(GenericDataSource dataSource, GenericCatalog catalog, String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.dbLinkCache.clearCache();
        this.libraryCache.clearCache();
        this.directoryCache.clearCache();
        this.hasStatistics = false;
        return this;
    }

    public List<AltibaseDbLink> getDbLinks(DBRProgressMonitor monitor) throws DBException {
        return this.dbLinkCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DbLinkCache getDbLinkCache() {
        return this.dbLinkCache;
    }

    public List<AltibaseLibrary> getLibraries(DBRProgressMonitor monitor) throws DBException {
        return this.libraryCache.getAllObjects(monitor, (DBSObject)this);
    }

    public LibraryCache getLibraryCache() {
        return this.libraryCache;
    }

    public List<AltibaseDirectory> getDirectories(DBRProgressMonitor monitor) throws DBException {
        return this.directoryCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DirectoryCache getDirectoryCache() {
        return this.directoryCache;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        GenericTableBase object = null;
        object = this.getTable(monitor, childName);
        if (object != null) {
            return object;
        }
        object = this.getProcedure(monitor, childName);
        if (object != null) {
            return object;
        }
        object = this.getPackage(monitor, childName);
        if (object != null) {
            return object;
        }
        object = this.getSynonym(monitor, childName);
        return object;
    }

    public List<AltibaseTable> getPhysicalTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseTable> filtered = new ArrayList<AltibaseTable>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseTable)) continue;
                filtered.add((AltibaseTable)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseQueue> getQueueTables(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseQueue> filtered = new ArrayList<AltibaseQueue>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseQueue)) continue;
                filtered.add((AltibaseQueue)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseView> getViews(@NotNull DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseView> filtered = new ArrayList<AltibaseView>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseView)) continue;
                filtered.add((AltibaseView)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseMaterializedView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseMaterializedView> filtered = new ArrayList<AltibaseMaterializedView>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseMaterializedView)) continue;
                filtered.add((AltibaseMaterializedView)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseTypeset> getTypesetsOnly(DBRProgressMonitor monitor) throws DBException {
        ArrayList<AltibaseTypeset> filteredProcedures = new ArrayList<AltibaseTypeset>();
        for (GenericProcedure proc : CommonUtils.safeList((List)this.getProcedures(monitor))) {
            if (!(proc instanceof AltibaseTypeset)) continue;
            filteredProcedures.add((AltibaseTypeset)proc);
        }
        return filteredProcedures;
    }

    public GenericTableIndex getIndex(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        for (GenericTableIndex index : CommonUtils.safeCollection((Collection)this.getIndexes(monitor))) {
            if (!uniqueName.equals(index.getName())) continue;
            return index;
        }
        return null;
    }

    public GenericTrigger getTableTrigger(@NotNull DBRProgressMonitor monitor, String uniqueName) throws DBException {
        for (GenericTrigger tableTrigger : CommonUtils.safeCollection((Collection)this.getTableTriggers(monitor))) {
            if (!uniqueName.equals(tableTrigger.getName())) continue;
            return tableTrigger;
        }
        return null;
    }

    public GenericProcedure getProcedureByName(DBRProgressMonitor monitor, String name) throws DBException {
        for (GenericProcedure procedure : CommonUtils.safeCollection((Collection)this.getProcedures(monitor))) {
            if (!name.equals(procedure.getName())) continue;
            return procedure;
        }
        return null;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");
             JDBCPreparedStatement dbStat = session.prepareStatement("SELECT table_name, memory_size, disk_size FROM system_.sys_table_size_ WHERE USER_NAME = ?");){
            dbStat.setString(1, this.getName());
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    String tableName = dbResult.getString(1);
                    AltibaseTable table = (AltibaseTable)this.getTable(monitor, tableName);
                    if (table == null) continue;
                    table.fetchTableSize(dbResult);
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading table statistics", (Throwable)e);
        }
        finally {
            for (GenericTableBase table : this.getTableCache().getCachedObjects()) {
                if (!(table instanceof AltibaseTable) || ((AltibaseTable)table).hasStatistics()) continue;
                ((AltibaseTable)table).resetSize();
            }
            this.hasStatistics = true;
        }
    }

    static class DbLinkCache
    extends JDBCObjectLookupCache<GenericObjectContainer, AltibaseDbLink> {
        DbLinkCache() {
        }

        @Nullable
        protected AltibaseDbLink fetchObject(@NotNull JDBCSession session, @NotNull GenericObjectContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return ((AltibaseMetaModel)container.getDataSource().getMetaModel()).createDbLinkImpl((GenericStructContainer)container, resultSet);
        }

        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericObjectContainer owner, @Nullable AltibaseDbLink object, @Nullable String objectName) throws SQLException {
            return ((AltibaseMetaModel)owner.getDataSource().getMetaModel()).prepareDbLinkLoadStatement(session, (GenericStructContainer)owner, object, objectName);
        }
    }

    static class LibraryCache
    extends JDBCObjectLookupCache<GenericObjectContainer, AltibaseLibrary> {
        LibraryCache() {
        }

        @Nullable
        protected AltibaseLibrary fetchObject(@NotNull JDBCSession session, @NotNull GenericObjectContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return ((AltibaseMetaModel)container.getDataSource().getMetaModel()).createLibraryImpl((GenericStructContainer)container, resultSet);
        }

        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericObjectContainer owner, @Nullable AltibaseLibrary object, @Nullable String objectName) throws SQLException {
            return ((AltibaseMetaModel)owner.getDataSource().getMetaModel()).prepareLibraryLoadStatement(session, (GenericStructContainer)owner, object, objectName);
        }
    }

    static class DirectoryCache
    extends JDBCObjectLookupCache<GenericObjectContainer, AltibaseDirectory> {
        DirectoryCache() {
        }

        @Nullable
        protected AltibaseDirectory fetchObject(@NotNull JDBCSession session, @NotNull GenericObjectContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return ((AltibaseMetaModel)container.getDataSource().getMetaModel()).createDirectoryImpl((GenericStructContainer)container, resultSet);
        }

        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericObjectContainer owner, @Nullable AltibaseDirectory object, @Nullable String objectName) throws SQLException {
            return ((AltibaseMetaModel)owner.getDataSource().getMetaModel()).prepareDirectoryLoadStatement(session, (GenericStructContainer)owner, object, objectName);
        }
    }
}

