/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Margin;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import java.util.List;

public class BoxLayout
implements Group.Layout {
    private final Vec2f cellSize;
    private final Alignment alignment;
    private final Margin margin;
    private final Padding padding;
    private static final boolean TRACE_LAYOUT = false;

    public BoxLayout() {
        this(0.0f, 0.0f, Alignment.None, Margin.None, null);
    }

    public BoxLayout(Padding padding) {
        this(0.0f, 0.0f, Alignment.None, Margin.None, padding);
    }

    public BoxLayout(float f, float f2, Alignment alignment) {
        this(f, f2, alignment, Margin.None, null);
    }

    public BoxLayout(float f, float f2, Margin margin) {
        this(f, f2, Alignment.None, margin, null);
    }

    public BoxLayout(float f, float f2, Padding padding) {
        this(f, f2, Alignment.None, Margin.None, padding);
    }

    public BoxLayout(float f, float f2, Margin margin, Padding padding) {
        this(f, f2, Alignment.None, margin, padding);
    }

    public BoxLayout(float f, float f2, Alignment alignment, Margin margin) {
        this(f, f2, alignment, margin, null);
    }

    public BoxLayout(float f, float f2, Alignment alignment, Padding padding) {
        this(f, f2, alignment, Margin.None, padding);
    }

    public BoxLayout(float f, float f2, Alignment alignment, Margin margin, Padding padding) {
        this.cellSize = new Vec2f(Math.max(0.0f, f), Math.max(0.0f, f2));
        this.alignment = alignment;
        this.margin = margin;
        this.padding = padding;
    }

    public Vec2f getCellSize() {
        return this.cellSize;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Margin getMargin() {
        return this.margin;
    }

    public Padding getPadding() {
        return this.padding;
    }

    @Override
    public void preValidate(Shape shape) {
        if (null != this.padding && !this.padding.zeroSize()) {
            shape.setPaddding(this.padding);
        }
    }

    @Override
    public void layout(Group group, AABBox aABBox, PMVMatrix4f pMVMatrix4f) {
        boolean bl = !FloatUtil.isZero(this.cellSize.x());
        boolean bl2 = !FloatUtil.isZero(this.cellSize.y());
        boolean bl3 = bl && this.alignment.isSet(Alignment.Bit.CenterHoriz);
        boolean bl4 = bl2 && this.alignment.isSet(Alignment.Bit.CenterVert);
        boolean bl5 = this.alignment.isSet(Alignment.Bit.Fill) && (bl || bl2);
        List<Shape> list = group.getShapes();
        AABBox aABBox2 = new AABBox();
        for (int i = 0; i < list.size(); ++i) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            Shape shape = list.get(i);
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            shape.getBounds().transform(pMVMatrix4f.getMv(), aABBox2);
            pMVMatrix4f.popMv();
            float f6 = aABBox2.getWidth();
            float f7 = aABBox2.getHeight();
            if (FloatUtil.isZero(f7) || FloatUtil.isZero(f7)) continue;
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (bl5) {
                f5 = bl ? this.cellSize.x() - this.margin.width() : f6;
                f4 = bl2 ? this.cellSize.y() - this.margin.height() : f7;
                f3 = f5 / f6;
                f2 = f4 / f7;
                float f10 = f = f3 < f2 ? f3 : f2;
                if (bl3) {
                    f8 += f6 * (f3 - f) * 0.5f;
                }
                if (bl4) {
                    f9 += f7 * (f2 - f) * 0.5f;
                }
                f9 += this.margin.bottom;
                f8 += this.margin.left;
            } else {
                f = 1.0f;
            }
            f5 = f * f6;
            f4 = f * f7;
            f3 = bl ? this.cellSize.x() : f5;
            float f11 = f2 = bl2 ? this.cellSize.y() : f4;
            if (!bl5) {
                f8 = bl3 ? (f8 += 0.5f * (f3 - f5)) : (f8 += this.margin.left);
                f9 = bl4 ? (f9 += 0.5f * (f2 - f4)) : (f9 += this.margin.bottom);
            }
            shape.moveTo(0.0f + f8, 0.0f + f9, shape.getPosition().z());
            Vec3f vec3f = new Vec3f(shape.getBounds().getLow());
            vec3f.setZ(0.0f);
            if (bl3 || bl4) {
                if (!bl4 && vec3f.y() > 0.0f) {
                    vec3f.setY(0.0f);
                } else if (!bl3 && vec3f.x() > 0.0f) {
                    vec3f.setX(0.0f);
                }
                vec3f.mul(shape.getScale()).scale(-1.0f);
            } else {
                vec3f.min(new Vec3f()).mul(shape.getScale()).scale(-1.0f);
            }
            shape.move(vec3f.scale(f));
            aABBox.resize(0.0f, 0.0f, aABBox2.getMinZ());
            aABBox.resize(0.0f + f3, 0.0f + f2, aABBox2.getMaxZ());
            shape.scale(f, f, 1.0f);
        }
        if (Float.isInfinite(aABBox.getWidth()) || Float.isInfinite(aABBox.getHeight())) {
            aABBox.resize(0.0f, 0.0f, 0.0f);
        }
    }

    public String toString() {
        String string = null == this.padding || this.padding.zeroSize() ? "" : ", " + this.padding.toString();
        String string2 = this.margin.zeroSize() ? "" : ", " + this.margin.toString();
        return "Box[cell " + this.cellSize + ", a " + this.alignment + string2 + string + "]";
    }
}

