/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

class RangeRecord {
    private final int _start;
    private final int _end;
    private final int _startCoverageIndex;

    public RangeRecord(DataInput dataInput) throws IOException {
        this._start = dataInput.readUnsignedShort();
        this._end = dataInput.readUnsignedShort();
        this._startCoverageIndex = dataInput.readUnsignedShort();
    }

    public int getStart() {
        return this._start;
    }

    public int getEnd() {
        return this._end;
    }

    public int getStartCoverageIndex() {
        return this._startCoverageIndex;
    }

    private boolean isInRange(int n) {
        return this._start <= n && n <= this._end;
    }

    public int getCoverageIndex(int n) {
        if (this.isInRange(n)) {
            return this._startCoverageIndex + n - this._start;
        }
        return -1;
    }
}

