import { jsx, jsxs } from 'react/jsx-runtime';
import { PureComponent } from 'react';
import { Select, HorizontalGroup } from '@grafana/ui';
import '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { isUnsignedPluginSignature, PluginSignatureBadge } from '../Plugins/PluginSignatureBadge.js';
import { getDataSourceSrv } from '@grafana/runtime';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class DataSourcePicker extends PureComponent {
  constructor(props) {
    super(props);
    __publicField(this, "dataSourceSrv", getDataSourceSrv());
    __publicField(this, "state", {});
    __publicField(this, "onChange", (item) => {
      const dsSettings = this.dataSourceSrv.getInstanceSettings(item.value);
      if (dsSettings) {
        this.props.onChange(dsSettings);
        this.setState({ error: undefined });
      }
    });
  }
  componentDidMount() {
    const { current } = this.props;
    const dsSettings = this.dataSourceSrv.getInstanceSettings(current);
    if (!dsSettings) {
      this.setState({ error: "Could not find data source " + current });
    }
  }
  getCurrentValue() {
    const { current, hideTextValue, noDefault } = this.props;
    if (!current && noDefault) {
      return {
        label: "No datasources found"
      };
    }
    const ds = this.dataSourceSrv.getInstanceSettings(current);
    if (ds) {
      return {
        label: ds.name.substr(0, 37),
        value: ds.name,
        imgUrl: ds.meta.info.logos.small,
        hideText: hideTextValue,
        meta: ds.meta
      };
    }
    return {
      label: (current != null ? current : "no name") + " - not found",
      value: (current != null ? current : "no name") + " - not found",
      imgUrl: "",
      hideText: hideTextValue
    };
  }
  getDataSourceOptions() {
    const options = this.dataSourceSrv.getList().map((ds) => ({
      value: ds.uid,
      label: ds.name,
      imgUrl: ds.meta.info.logos.small,
      meta: ds.meta
    }));
    return options;
  }
  render() {
    const { autoFocus, onBlur, openMenuOnFocus, placeholder } = this.props;
    const { error } = this.state;
    const options = this.getDataSourceOptions();
    const value = this.getCurrentValue();
    return /* @__PURE__ */ jsx("div", { "aria-label": selectors.components.DataSourcePicker.container, children: /* @__PURE__ */ jsx(
      Select,
      {
        className: "ds-picker select-container",
        isMulti: false,
        isClearable: false,
        backspaceRemovesValue: false,
        onChange: this.onChange,
        options,
        autoFocus,
        onBlur,
        openMenuOnFocus,
        maxMenuHeight: 500,
        placeholder,
        noOptionsMessage: "No datasources found",
        value,
        invalid: !!error,
        getOptionLabel: (o) => {
          if (o.meta && isUnsignedPluginSignature(o.meta.signature) && o !== value) {
            return /* @__PURE__ */ jsxs(HorizontalGroup, { align: "center", justify: "space-between", children: [
              /* @__PURE__ */ jsx("span", { children: o.label }),
              " ",
              /* @__PURE__ */ jsx(PluginSignatureBadge, { status: o.meta.signature })
            ] });
          }
          return o.label || "";
        }
      }
    ) });
  }
}
__publicField(DataSourcePicker, "defaultProps", {
  autoFocus: false,
  openMenuOnFocus: false,
  placeholder: "Select datasource"
});

export { DataSourcePicker };
//# sourceMappingURL=DataSourcePicker.js.map
