import { jsx } from 'react/jsx-runtime';
import 'react';
import { Badge } from '@grafana/ui';
import { PluginSignatureStatus } from '@grafana/data';

const PluginSignatureBadge = ({ status, ...otherProps }) => {
  const display = getSignatureDisplayModel(status);
  return /* @__PURE__ */ jsx(
    Badge,
    {
      text: display.text,
      color: display.color,
      icon: display.icon,
      tooltip: display.tooltip,
      ...otherProps
    }
  );
};
function isUnsignedPluginSignature(signature) {
  return signature && signature !== PluginSignatureStatus.valid && signature !== PluginSignatureStatus.internal;
}
function getSignatureDisplayModel(signature) {
  if (!signature) {
    signature = PluginSignatureStatus.invalid;
  }
  switch (signature) {
    case PluginSignatureStatus.internal:
      return { text: "Core", icon: "cube", color: "blue", tooltip: "Core plugin that is bundled with Grafana" };
    case PluginSignatureStatus.valid:
      return { text: "Signed", icon: "lock", color: "green", tooltip: "Signed and verified plugin" };
    case PluginSignatureStatus.invalid:
      return {
        text: "Invalid signature",
        icon: "exclamation-triangle",
        color: "red",
        tooltip: "Invalid plugin signature"
      };
    case PluginSignatureStatus.modified:
      return {
        text: "Modified signature",
        icon: "exclamation-triangle",
        color: "red",
        tooltip: "Valid signature but content has been modified"
      };
    case PluginSignatureStatus.missing:
      return {
        text: "Missing signature",
        icon: "exclamation-triangle",
        color: "red",
        tooltip: "Missing plugin signature"
      };
  }
  return { text: "Unsigned", icon: "exclamation-triangle", color: "red", tooltip: "Unsigned external plugin" };
}
PluginSignatureBadge.displayName = "PluginSignatureBadge";

export { PluginSignatureBadge, isUnsignedPluginSignature };
//# sourceMappingURL=PluginSignatureBadge.js.map
