import { Registry } from '@grafana/data';
import { BINARY_OPERATIONS_KEY } from './types.js';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class QueryModellerBase {
  constructor(operationDefinitions, innerQueryPlaceholder) {
    __publicField(this, "operationsRegistry");
    __publicField(this, "categories", []);
    __publicField(this, "innerQueryPlaceholder");
    this.operationsRegistry = new Registry(() => operationDefinitions);
    this.innerQueryPlaceholder = innerQueryPlaceholder || "<query>";
  }
  setOperationCategories(categories) {
    this.categories = categories;
  }
  getOperationsForCategory(category) {
    return this.operationsRegistry.list().filter((op) => op.category === category && !op.hideFromList);
  }
  getAlternativeOperations(key) {
    return this.operationsRegistry.list().filter((op) => op.alternativesKey && op.alternativesKey === key);
  }
  getCategories() {
    return this.categories;
  }
  getOperationDefinition(id) {
    return this.operationsRegistry.getIfExists(id);
  }
  hasBinaryOp(query) {
    return query.operations.find((op) => {
      const def = this.getOperationDefinition(op.id);
      return (def == null ? undefined : def.category) === BINARY_OPERATIONS_KEY;
    }) !== undefined;
  }
}

export { QueryModellerBase };
//# sourceMappingURL=QueryModellerBase.js.map
