/*******************************************************************************
 *
 * MIT License
 *
 * Copyright 2024-2025 AMD ROCm(TM) Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/

#pragma once

#include <rocRoller/Operations/OperationTag.hpp>

namespace rocRoller
{
    namespace Operations
    {
        /**
         * @brief Prefix increment operator
         */
        inline OperationTag& OperationTag::operator++()
        {
            value++;
            return *this;
        }

        /**
         * @brief Postfix increment operator
         */
        inline OperationTag OperationTag::operator++(int)
        {
            auto rv = *this;
            ++(*this);
            return rv;
        }

        inline OperationTag operator+(OperationTag const& tag, int val)
        {
            rocRoller::Operations::OperationTag rv(static_cast<int32_t>(tag) + val);
            return rv;
        }

        inline bool OperationTag::uninitialized() const
        {
            return value == -1;
        }
    }
}

namespace std
{
    inline ostream& operator<<(ostream& stream, rocRoller::Operations::OperationTag const tag)
    {
        return stream << static_cast<int32_t>(tag);
    }

    template <>
    struct hash<rocRoller::Operations::OperationTag>
    {
        inline size_t operator()(rocRoller::Operations::OperationTag const& t) const noexcept
        {
            hash<int32_t> int_hash;
            return int_hash(static_cast<int32_t>(t));
        }
    };
}
