        #include <cmrc/cmrc.hpp>
#include <map>
#include <utility>

namespace cmrc {
namespace rocRoller {

namespace res_chars {
// These are the files which are available in this resource library
// Pointers to /build/hipblaslt/src/build/rocroller/GPUArchitectureGenerator/GPUArchitecture_def.msgpack
extern const char* const f_a7e3_GPUArchitecture_def_msgpack_begin;
extern const char* const f_a7e3_GPUArchitecture_def_msgpack_end;
}

namespace {

const cmrc::detail::index_type&
get_root_index() {
    static cmrc::detail::directory root_directory_;
    static cmrc::detail::file_or_directory root_directory_fod{root_directory_};
    static cmrc::detail::index_type root_index;
    root_index.emplace("", &root_directory_fod);
    struct dir_inl {
        class cmrc::detail::directory& directory;
    };
    dir_inl root_directory_dir{root_directory_};
    (void)root_directory_dir;
    static auto f_55b5_resources_dir = root_directory_dir.directory.add_subdir("resources");
    root_index.emplace("resources", &f_55b5_resources_dir.index_entry);
    root_index.emplace(
        "resources/GPUArchitecture_def.msgpack",
        f_55b5_resources_dir.directory.add_file(
            "GPUArchitecture_def.msgpack",
            res_chars::f_a7e3_GPUArchitecture_def_msgpack_begin,
            res_chars::f_a7e3_GPUArchitecture_def_msgpack_end
        )
    );
    return root_index;
}

}

cmrc::embedded_filesystem get_filesystem() {
    static auto& index = get_root_index();
    return cmrc::embedded_filesystem{index};
}

} // rocRoller
} // cmrc
    