/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private TabStop[] tabs;
    private int hashCode = Integer.MAX_VALUE;

    public TabSet(TabStop[] tabStopArray) {
        if (tabStopArray != null) {
            int n = tabStopArray.length;
            this.tabs = new TabStop[n];
            System.arraycopy(tabStopArray, 0, this.tabs, 0, n);
        } else {
            this.tabs = null;
        }
    }

    public int getTabCount() {
        return this.tabs == null ? 0 : this.tabs.length;
    }

    public TabStop getTab(int n) {
        int n2 = this.getTabCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException(n + " is outside the range of tabs");
        }
        return this.tabs[n];
    }

    public TabStop getTabAfter(float f) {
        int n = this.getTabIndexAfter(f);
        return n == -1 ? null : this.tabs[n];
    }

    public int getTabIndex(TabStop tabStop) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (this.getTab(i) != tabStop) continue;
            return i;
        }
        return -1;
    }

    public int getTabIndexAfter(float f) {
        int n = 0;
        int n2 = this.getTabCount();
        while (n != n2) {
            int n3 = (n2 - n) / 2 + n;
            if (f > this.tabs[n3].getPosition()) {
                if (n == n3) {
                    n = n2;
                    continue;
                }
                n = n3;
                continue;
            }
            if (n3 == 0 || f > this.tabs[n3 - 1].getPosition()) {
                return n3;
            }
            n2 = n3;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TabSet) {
            TabSet tabSet = (TabSet)object;
            int n = this.getTabCount();
            if (tabSet.getTabCount() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                TabStop tabStop = this.getTab(i);
                TabStop tabStop2 = tabSet.getTab(i);
                if ((tabStop != null || tabStop2 == null) && (tabStop == null || this.getTab(i).equals(tabSet.getTab(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MAX_VALUE) {
            this.hashCode = 0;
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                TabStop tabStop = this.getTab(i);
                this.hashCode ^= tabStop != null ? this.getTab(i).hashCode() : 0;
            }
            if (this.hashCode == Integer.MAX_VALUE) {
                --this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        int n = this.getTabCount();
        StringBuilder stringBuilder = new StringBuilder("[ ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(" - ");
            }
            stringBuilder.append(this.getTab(i).toString());
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

