/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.event.SamplerAdapter;
import org.jsampler.event.SamplerEvent;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaFaderUI;
import org.jsampler.view.fantasia.basic.FantasiaToggleButtonsPanel;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jsampler.view.std.JSVolumeEditorPopup;

public class ChannelsBar
extends PixmapPane {
    private final JSlider slVolume = new JSlider();
    JButton btnVolume = FantasiaUtils.createScreenButton("3 dB");
    private final JLabel lStreams = FantasiaUtils.createScreenLabel(" --");
    private final JLabel lVoices = FantasiaUtils.createScreenLabel("-- ");
    private JSVolumeEditorPopup popupVolume;
    private final FantasiaToggleButtonsPanel buttonsPanel;
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public ChannelsBar(FantasiaToggleButtonsPanel fantasiaToggleButtonsPanel) {
        super(Res.gfxCreateChannel);
        this.buttonsPanel = fantasiaToggleButtonsPanel;
        numberFormat.setMaximumFractionDigits(1);
        this.popupVolume = new JSVolumeEditorPopup(this.btnVolume, JSVolumeEditorPopup.VolumeType.MASTER);
        this.setPixmapInsets(new Insets(1, 1, 1, 1));
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel jLabel = new JLabel(Res.iconVolume22);
        this.add(jLabel);
        this.slVolume.setUI(new FantasiaFaderUI(this.slVolume));
        this.slVolume.putClientProperty("Fader.knobSize", new Dimension(15, 22));
        this.slVolume.setOpaque(false);
        this.slVolume.setFocusable(false);
        Dimension dimension = new Dimension(150, 22);
        this.slVolume.setPreferredSize(dimension);
        this.slVolume.setMaximumSize(dimension);
        this.slVolume.setAlignmentY(0.5f);
        this.add(this.slVolume);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        PixmapPane pixmapPane = new PixmapPane(Res.gfxTextField);
        pixmapPane.setLayout(new BoxLayout(pixmapPane, 0));
        pixmapPane.setPixmapInsets(new Insets(5, 5, 4, 5));
        pixmapPane.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 5));
        this.lStreams.setFont(Res.fontScreenMono);
        this.lStreams.setHorizontalAlignment(4);
        this.lStreams.setPreferredSize(this.lStreams.getPreferredSize());
        this.lStreams.setMaximumSize(this.lStreams.getPreferredSize());
        this.lStreams.setToolTipText(FantasiaI18n.i18n.getLabel("ChannelsBar.streamVoiceCount"));
        pixmapPane.add(this.lStreams);
        jLabel = FantasiaUtils.createScreenLabel("/");
        jLabel.setFont(Res.fontScreenMono);
        jLabel.setToolTipText(FantasiaI18n.i18n.getLabel("ChannelsBar.streamVoiceCount"));
        pixmapPane.add(jLabel);
        this.lVoices.setFont(Res.fontScreenMono);
        this.lVoices.setPreferredSize(this.lVoices.getPreferredSize());
        this.lVoices.setMaximumSize(this.lVoices.getPreferredSize());
        this.lVoices.setToolTipText(FantasiaI18n.i18n.getLabel("ChannelsBar.streamVoiceCount"));
        pixmapPane.add(this.lVoices);
        this.btnVolume.setIcon(Res.iconVolume14);
        this.btnVolume.setIconTextGap(2);
        this.btnVolume.setHorizontalAlignment(2);
        dimension = this.btnVolume.getPreferredSize();
        dimension.width = 65;
        this.btnVolume.setPreferredSize(dimension);
        this.btnVolume.setMaximumSize(dimension);
        pixmapPane.add(this.btnVolume);
        pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
        pixmapPane.setAlignmentY(0.5f);
        this.add(pixmapPane);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.createVSeparator());
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        fantasiaToggleButtonsPanel.setAlignmentY(0.5f);
        this.add(fantasiaToggleButtonsPanel);
        this.add(Box.createGlue());
        dimension = new Dimension(420, 29);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        int n = FantasiaPrefs.preferences().getIntProperty("maximumMasterVolume");
        this.slVolume.setMaximum(n);
        String string = "maximumMasterVolume";
        FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = FantasiaPrefs.preferences().getIntProperty("maximumMasterVolume");
                ChannelsBar.this.slVolume.setMaximum(n);
            }
        });
        this.slVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ChannelsBar.this.setVolume();
            }
        });
        CC.getSamplerModel().addSamplerListener(new SamplerAdapter(){

            @Override
            public void volumeChanged(SamplerEvent samplerEvent) {
                ChannelsBar.this.updateVolume();
            }

            @Override
            public void totalVoiceCountChanged(SamplerEvent samplerEvent) {
                int n = CC.getSamplerModel().getTotalVoiceCount();
                if (n == 0) {
                    ChannelsBar.this.lVoices.setText("--");
                } else {
                    ChannelsBar.this.lVoices.setText(String.valueOf(n));
                }
            }

            @Override
            public void totalStreamCountChanged(SamplerEvent samplerEvent) {
                int n = CC.getSamplerModel().getTotalStreamCount();
                if (n == 0) {
                    ChannelsBar.this.lStreams.setText("--");
                } else {
                    ChannelsBar.this.lStreams.setText(String.valueOf(n));
                }
            }
        });
        this.updateVolume();
        this.btnVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChannelsBar.this.popupVolume.isVisible()) {
                    ChannelsBar.this.popupVolume.commit();
                    ChannelsBar.this.popupVolume.hide();
                } else {
                    float f = CC.getSamplerModel().getVolume();
                    ChannelsBar.this.popupVolume.setCurrentVolume(f);
                    ChannelsBar.this.popupVolume.show();
                }
            }
        });
        this.popupVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getSamplerModel().setBackendVolume(ChannelsBar.this.popupVolume.getVolumeFactor());
            }
        });
        string = "volMeasurementUnitDecibel";
        FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChannelsBar.this.setVolume();
            }
        });
    }

    private void setVolume() {
        int n = this.slVolume.getValue();
        if (CC.getViewConfig().isMeasurementUnitDecibel()) {
            double d = HF.percentsToDecibels(n);
            this.btnVolume.setText(numberFormat.format(d) + "dB");
        } else {
            this.btnVolume.setText(n + "%");
        }
        if (this.slVolume.getValueIsAdjusting()) {
            return;
        }
        int n2 = (int)(CC.getSamplerModel().getVolume() * 100.0f);
        if (n2 == this.slVolume.getValue()) {
            return;
        }
        float f = this.slVolume.getValue();
        CC.getSamplerModel().setBackendVolume(f /= 100.0f);
    }

    private void updateVolume() {
        this.slVolume.setValue((int)(CC.getSamplerModel().getVolume() * 100.0f));
    }

    protected JPanel createVSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
        pixmapPane.setOpaque(false);
        pixmapPane.setPreferredSize(new Dimension(2, 29));
        pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
        pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
        return pixmapPane;
    }
}

