/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.SecuritySupport;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public class ConfigPropertiesInjectionBean<T>
implements Bean<T> {
    private final ConfigMappings.ConfigClass configClass;
    private final Set<Annotation> qualifiers;

    ConfigPropertiesInjectionBean(ConfigMappings.ConfigClass configClass) {
        this.configClass = configClass;
        this.qualifiers = Collections.singleton(ConfigProperties.Literal.of((String)configClass.getPrefix()));
    }

    public Class<T> getBeanClass() {
        return this.configClass.getType();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public T create(CreationalContext<T> creationalContext) {
        String prefix = this.configClass.getPrefix();
        if (prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix") && (prefix = this.configClass.getType().getAnnotation(ConfigProperties.class).prefix()).equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
            prefix = "";
        }
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig((ClassLoader)SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
        return (T)config.getConfigMapping(this.getBeanClass(), prefix);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.configClass.getType());
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.configClass.getType().getName() + "_" + this.configClass.getPrefix();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }
}

