/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.structure;

import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.structure.AbstractESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "Lorg/jetbrains/kotlin/contracts/model/structure/AbstractESValue;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "type", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "<init>", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lorg/jetbrains/kotlin/contracts/model/structure/ESType;)V", "getConstantReference", "()Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "getType", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "accept", "T", "visitor", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "(Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "toString", "", "isNullConstant", "resolution"})
public final class ESConstant
extends AbstractESValue {
    @NotNull
    private final ConstantReference constantReference;
    @NotNull
    private final ESType type;

    public ESConstant(@NotNull ConstantReference constantReference, @NotNull ESType type) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        Intrinsics.checkNotNullParameter(type, "type");
        super(type);
        this.constantReference = constantReference;
        this.type = type;
    }

    @NotNull
    public final ConstantReference getConstantReference() {
        return this.constantReference;
    }

    @Override
    @NotNull
    public ESType getType() {
        return this.type;
    }

    @Override
    public <T> T accept(@NotNull ESExpressionVisitor<? extends T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitConstant(this);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ESConstant && Intrinsics.areEqual(this.constantReference, ((ESConstant)other).constantReference);
    }

    public int hashCode() {
        return Objects.hashCode(this.constantReference);
    }

    @NotNull
    public String toString() {
        return this.constantReference.getName();
    }

    public final boolean isNullConstant() {
        return Intrinsics.areEqual(this.constantReference, ConstantReference.Companion.getNULL()) || Intrinsics.areEqual(this.constantReference, ConstantReference.Companion.getNOT_NULL());
    }
}

