function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiPage } from './page';
import { EuiPageSideBar } from './page_side_bar';
import { EuiPageBody } from './page_body';
import { EuiPageHeader } from './page_header';
import { EuiPageContent, EuiPageContentBody } from './page_content';
import { EuiBottomBar } from '../bottom_bar';
import { useIsWithinBreakpoints } from '../../services';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
export var TEMPLATES = ['default', 'centeredBody', 'centeredContent', 'empty'];
export var EuiPageTemplate = function EuiPageTemplate(_ref) {
  var _pageBodyProps2;
  var _ref$template = _ref.template,
    template = _ref$template === void 0 ? 'default' : _ref$template,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    fullHeight = _ref.fullHeight,
    children = _ref.children,
    className = _ref.className,
    pageSideBar = _ref.pageSideBar,
    pageSideBarProps = _ref.pageSideBarProps,
    pageHeader = _ref.pageHeader,
    pageBodyProps = _ref.pageBodyProps,
    pageContentProps = _ref.pageContentProps,
    pageContentBodyProps = _ref.pageContentBodyProps,
    bottomBar = _ref.bottomBar,
    bottomBarProps = _ref.bottomBarProps,
    _ref$minHeight = _ref.minHeight,
    minHeight = _ref$minHeight === void 0 ? 460 : _ref$minHeight,
    rest = _objectWithoutProperties(_ref, ["template", "restrictWidth", "grow", "paddingSize", "fullHeight", "children", "className", "pageSideBar", "pageSideBarProps", "pageHeader", "pageBodyProps", "pageContentProps", "pageContentBodyProps", "bottomBar", "bottomBarProps", "minHeight"]);
  /**
   * Full height ~madness~ logic
   */
  var canFullHeight = useIsWithinBreakpoints(['m', 'l', 'xl', 'xxl', 'xxxl']) && (template === 'default' || template === 'empty');
  var fullHeightClass = {
    'eui-fullHeight': fullHeight && canFullHeight
  };
  var yScrollClass = {
    'eui-yScroll': fullHeight && canFullHeight
  };
  if (canFullHeight && fullHeight) {
    var _pageBodyProps, _pageContentProps, _pageContentBodyProps;
    // By using flex group it will also fix the negative margin issues for nested flex groups
    children = /*#__PURE__*/React.createElement(EuiFlexGroup, {
      className: "eui-fullHeight",
      gutterSize: "none",
      direction: "column",
      responsive: false
    }, /*#__PURE__*/React.createElement(EuiFlexItem, {
      className: classNames({
        'eui-yScroll': fullHeight === true,
        'eui-fullHeight': fullHeight === 'noscroll'
      }),
      grow: true
    }, children));
    pageBodyProps = _objectSpread(_objectSpread({}, pageBodyProps), {}, {
      className: classNames(fullHeightClass, (_pageBodyProps = pageBodyProps) === null || _pageBodyProps === void 0 ? void 0 : _pageBodyProps.className)
    });
    pageContentProps = _objectSpread(_objectSpread({}, pageContentProps), {}, {
      className: classNames(yScrollClass, (_pageContentProps = pageContentProps) === null || _pageContentProps === void 0 ? void 0 : _pageContentProps.className)
    });
    pageContentBodyProps = _objectSpread(_objectSpread({}, pageContentBodyProps), {}, {
      className: classNames(fullHeightClass, (_pageContentBodyProps = pageContentBodyProps) === null || _pageContentBodyProps === void 0 ? void 0 : _pageContentBodyProps.className)
    });
  }
  var classes = classNames('euiPageTemplate', fullHeightClass, className);
  var pageStyle = _objectSpread({
    minHeight: minHeight
  }, rest.style);

  /**
   * This seems very repetitious but it's the most readable, scalable, and maintainable
   */

  switch (template) {
    /**
     * CENTERED BODY
     * The panelled content is centered
     */
    case 'centeredBody':
      return pageSideBar ? /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        paddingSize: "none",
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * CENTERED CONTENT
     * The content inside the panel is centered
     */
    case 'centeredContent':
      return pageSideBar ? /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        panelled: true,
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        paddingSize: paddingSize,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, {
        role: null,
        borderRadius: "none",
        hasShadow: false,
        paddingSize: paddingSize,
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * EMPTY
     * No panelling at all
     */
    case 'empty':
      return pageSideBar ? /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        paddingSize: "none"
      }, pageContentBodyProps), children))));

    /**
     * DEFAULT
     * Typical layout with nothing "centered"
     */
    default:
      // Only the default template can display a bottom bar
      var bottomBarNode = bottomBar ? /*#__PURE__*/React.createElement(EuiBottomBar, _extends({
        paddingSize: paddingSize,
        position: canFullHeight && fullHeight ? 'static' : 'sticky'
        // Using uknown here because of the possible conflict with overriding props and position `sticky`
      }, bottomBarProps), /*#__PURE__*/React.createElement(EuiPageContentBody, {
        paddingSize: 'none',
        restrictWidth: restrictWidth
      }, bottomBar)) : undefined;
      return pageSideBar ? /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(EuiPageBody, _extends({
        panelled: true,
        paddingSize: "none"
      }, pageBodyProps), /*#__PURE__*/React.createElement(EuiPageBody, {
        component: "div",
        paddingSize: paddingSize,
        className: (_pageBodyProps2 = pageBodyProps) === null || _pageBodyProps2 === void 0 ? void 0 : _pageBodyProps2.className
      }, pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        bottomBorder: true,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        hasShadow: false,
        hasBorder: false,
        color: 'transparent',
        borderRadius: 'none',
        paddingSize: "none"
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children))), bottomBarNode)) : /*#__PURE__*/React.createElement(EuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(EuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/React.createElement(EuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageHeader)), /*#__PURE__*/React.createElement(EuiPageContent, _extends({
        hasBorder: pageHeader === undefined ? false : undefined,
        hasShadow: false,
        paddingSize: 'none',
        color: 'plain',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(EuiPageContentBody, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageContentBodyProps), children)), bottomBarNode));
  }
};
EuiPageTemplate.propTypes = {
  /**
     * Choose between 3 types of templates.
     * `default`: Typical layout with nothing centered
     * `centeredBody`: The panelled content is centered
     * `centeredContent`: The content inside the panel is centered
     * `empty`: Removes the panneling of the page content
     */
  template: PropTypes.any,
  /**
     * Padding size will not get applied to the over-arching #EuiPage,
     * but will propogate through all the components to keep them in sync
     */
  paddingSize: PropTypes.any,
  /**
     * Optionally include #EuiPageSideBar content.
     * The inclusion of this will affect the whole layout
     */
  pageSideBar: PropTypes.node,
  /**
     * Gets passed along to the #EuiPageSideBar component
     */
  pageSideBarProps: PropTypes.shape({
    /**
       * Adds `position: sticky` and affords for any fixed position headers
       */
    sticky: PropTypes.bool,
    /**
       * Adds padding around the children
       */
    paddingSize: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  /**
     * Optionally include an #EuiPageHeader by passing an object of its props
     */
  pageHeader: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
       * Wrapped in an `H1` so choose appropriately.
       * A simple string is best
       */
    pageTitle: PropTypes.node,
    /**
       * Optional icon to place to the left of the title
       * @deprecated The `iconType` prop is deprecated and will be removed in the future.
       */
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addBookmark", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "bookOpen", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compass", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "crossInCircleEmpty", "crossInCircleFilled", "currency", "cut", "dashboard", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "dockedBottom", "dockedDetached", "dockedLeft", "dockedRight", "dockedTakeover", "dockedTop", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "functionAdd", "gear", "generate", "generateContent", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "history", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "lineChart", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "power", "pulse", "push", "questionInCircle", "quote", "radar", "radius", "recent", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "rocket", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sparkleFilled", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram", "wsAnalytics", "wsEssentials", "wsObservability", "wsSearch", "wsSecurityAnalytics", "wsSelector", "navAdministration", "navAiFlow", "navAlerting", "navAnomalyDetection", "navDashboards", "navData", "navDetectionRules", "navDevtools", "navDiscover", "navExperiments", "navGetStarted", "navInfo", "navInfra", "navIntegrations", "navJudgements", "navManage", "navMaps", "navModels", "navNotebooks", "navNotifications", "navOverview", "navQuerySets", "navReports", "navSecurityCases", "navSecurityFindings", "navServiceMap", "navServices", "navSlos", "navThreatIntel", "navTicketing", "navUi", "navSearchConfigurationsln"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    /**
       * Additional EuiIcon props to apply to the optional icon
       * @deprecated The `iconProps` prop is deprecated and will be removed in the future.
       */
    iconProps: PropTypes.any,
    /**
       * In-app navigation presented as large borderless tabs.
       * Accepts an array of `EuiTab` objects;
       * HELP: This is evaluating to `any[]` in the props table
       */
    tabs: PropTypes.arrayOf(PropTypes.shape({
      /**
         * Visible text of the tab
         */
      label: PropTypes.node.isRequired
    }).isRequired),
    /**
       * Any extras to apply to the outer tabs container.
       * Extends `EuiTabs`
       */
    tabsProps: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      /**
           * ReactNode to render as this component's content
           */
      children: PropTypes.node
    }),
    /**
         * Position is dependent on existing with a `pageTitle` or `tabs`
         * Automatically get wrapped in a single paragraph tag inside an EuiText block
         */
    description: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.node.isRequired]),
    /**
         * Set to false if you don't want the children to stack at small screen sizes.
         * Set to `reverse` to display the right side content first for the sack of hierarchy (like global time)
         */
    responsive: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["reverse"])]),
    /**
         * Vertical alignment of the left and right side content;
         * Default is `middle` for custom content, but `top` for when `pageTitle` or `tabs` are included
         */
    alignItems: PropTypes.any,
    /**
         * Pass custom an array of content to this side usually up to 3 buttons.
         * The first button should be primary, usually with `fill` and will be visually displayed as the last item,
         * but first in the tab order
         */
    rightSideItems: PropTypes.arrayOf(PropTypes.node.isRequired),
    /**
         * Additional EuiFlexGroup props to pass to the container of the `rightSideItems`
         */
    rightSideGroupProps: PropTypes.any,
    /**
         * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
         */
    children: PropTypes.node,
    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
    /**
         * Adjust the padding.
         * When using this setting it's best to be consistent throughout all similar usages
         */
    paddingSize: PropTypes.any,
    /**
         * Adds a bottom border to separate it from the content after
         */
    bottomBorder: PropTypes.bool
  }),
  /**
     * Gets passed along to the #EuiPageBody component
     */
  pageBodyProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
    /**
         * Sets the HTML element for `EuiPageBody`.
         */
    component: PropTypes.any,
    /**
         * Uses an EuiPanel as the main component instead of a plain div
         */
    panelled: PropTypes.bool,
    /**
         * Extends any extra EuiPanel props if `panelled=true`
         */
    panelProps: PropTypes.any,
    /**
         * Adjusts the padding
         */
    paddingSize: PropTypes.any
  }),
  /**
     * Gets passed along to the #EuiPageContent component
     */
  pageContentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */
    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */
    hasShadow: PropTypes.bool,
    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */
    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */
    hasBorder: PropTypes.bool,
    /**
       * Padding for all four sides
       */
    /**
       * Padding for all four sides
       */
    paddingSize: PropTypes.any,
    /**
       * Corner border radius
       */
    /**
       * Corner border radius
       */
    borderRadius: PropTypes.any,
    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */
    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */
    grow: PropTypes.bool,
    panelRef: PropTypes.any,
    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */
    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */
    color: PropTypes.any,
    element: PropTypes.oneOf(["div"]),
    /**
         * **DEPRECATED: use `paddingSize` instead.**
         */
    panelPaddingSize: PropTypes.any,
    verticalPosition: PropTypes.oneOf(["center"]),
    horizontalPosition: PropTypes.oneOf(["center"]),
    /**
         * There should only be one EuiPageContent per page and should contain the main contents.
         * If this is untrue, set role = `null`, or change it to match your needed aria role
         */
    role: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([null])])
  }),
  /**
     * Gets passed along to the #EuiPageContentBody component
     */
  pageContentBodyProps: PropTypes.shape({
    /**
       * Adjust the padding.
       * When using this setting it's best to be consistent throughout all similar usages
       */
    paddingSize: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired])
  }),
  /**
     * Adds contents inside of an EuiBottomBar.
     * Only works when `template = 'default'`
     */
  bottomBar: PropTypes.any,
  /**
     * Gets passed along to the #EuiBottomBar component if `bottomBar` has contents
     */
  bottomBarProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    /**
         * How to position the bottom bar against its parent.
         */
    position: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["static", "sticky"]).isRequired]),
    /**
         * Whether to wrap in an EuiPortal which appends the component to the body element.
         * Only works if `position` is `fixed`.
         */
    usePortal: PropTypes.bool,
    /**
         * Whether the component should apply padding on the document body element to afford for its own displacement height.
         * Only works if `usePortal` is true and `position` is `fixed`.
         */
    affordForDisplacement: PropTypes.bool,
    /**
         * Padding applied to the bar. Default is 'm'.
         */
    paddingSize: PropTypes.oneOf(["none", "s", "m", "l"]),
    /**
         * Optional class applied to the body element on mount.
         */
    bodyClassName: PropTypes.string,
    /**
         * Customize the screen reader heading that helps users find this control. Default is 'Page level controls'.
         */
    landmarkHeading: PropTypes.string,
    /**
         * Starting vertical position when `fixed` position.
         * Offset from the top of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    top: PropTypes.any,
    /**
         * Ending horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    right: PropTypes.any,
    /**
         * Starting vertical position when `fixed` position.
         * Offset from the bottom of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    bottom: PropTypes.any,
    /**
         * Starting horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    left: PropTypes.any
  }),
  /**
     * Stretches or restricts the height to 100% of the parent;
     * `true`: scrolls the EuiPageContentBody;
     * `noscroll`: removes all scroll ability;
     * Only works when `template = 'default | empty'` and breakpoint is `m` and above
     */
  fullHeight: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["noscroll"])]),
  /**
     * Minimum height in which to enforce scrolling
     */
  minHeight: PropTypes.any
};