"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkbenchPlugin = void 0;
var _sqlPlugin = _interopRequireDefault(require("./clusters/sql/sqlPlugin"));
var _routes = require("./routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class WorkbenchPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    this.logger.debug('queryWorkbenchDashboards: Setup');
    const router = core.http.createRouter();
    const dataSourceEnabled = !!dataSource;
    const client = core.opensearch.legacy.createClient('query_workbench', {
      plugins: [_sqlPlugin.default]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_sqlPlugin.default);
    }

    // Register server side APIs
    (0, _routes.defineRoutes)(router, client, core.opensearch, dataSourceEnabled, this.logger);
    return {};
  }
  start() {
    this.logger.debug('queryWorkbenchDashboards: Started');
    return {};
  }
  stop() {}
}
exports.WorkbenchPlugin = WorkbenchPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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