/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.indexmanagement.rollup.model.metric.Cardinality;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupMappingUtils;", "", "<init>", "()V", "hasCardinalityMetrics", "", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "buildCardinalityFieldMappings", "", "buildFieldMapping", "targetField", "precisionThreshold", "", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupMappingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMappingUtils.kt\norg/opensearch/indexmanagement/rollup/util/RollupMappingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1761#2,2:74\n1761#2,3:76\n1763#2:79\n1869#2:80\n1869#2,2:81\n1870#2:83\n*S KotlinDebug\n*F\n+ 1 RollupMappingUtils.kt\norg/opensearch/indexmanagement/rollup/util/RollupMappingUtils\n*L\n23#1:74,2\n24#1:76,3\n23#1:79\n37#1:80\n38#1:81,2\n37#1:83\n*E\n"})
public final class RollupMappingUtils {
    @NotNull
    public static final RollupMappingUtils INSTANCE = new RollupMappingUtils();

    private RollupMappingUtils() {
    }

    public final boolean hasCardinalityMetrics(@NotNull Rollup rollup2) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
            Iterable $this$any$iv = rollup2.getMetrics();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        RollupMetrics rollupMetrics = (RollupMetrics)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = rollupMetrics.getMetrics();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Metric it = (Metric)element$iv2;
                                boolean bl4 = false;
                                if (!(it instanceof Cardinality)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String buildCardinalityFieldMappings(@NotNull Rollup rollup2) {
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        List mappings = new ArrayList();
        Iterable $this$forEach$iv = rollup2.getMetrics();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RollupMetrics rollupMetrics = (RollupMetrics)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = rollupMetrics.getMetrics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Metric metric = (Metric)element$iv2;
                boolean bl2 = false;
                if (!(metric instanceof Cardinality)) continue;
                String targetField = rollupMetrics.getTargetField();
                mappings.add(INSTANCE.buildFieldMapping(targetField, ((Cardinality)metric).getPrecisionThreshold()));
            }
        }
        return "{\"properties\":{" + CollectionsKt.joinToString$default((Iterable)mappings, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}}";
    }

    private final String buildFieldMapping(String targetField, long precisionThreshold) {
        String[] stringArray = new String[]{"."};
        List fieldParts = StringsKt.split$default((CharSequence)targetField, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int precision = Cardinality.Companion.precisionFromThreshold(precisionThreshold);
        String opening = CollectionsKt.joinToString$default((Iterable)fieldParts, (CharSequence)"", null, null, (int)0, null, RollupMappingUtils::buildFieldMapping$lambda$4, (int)30, null);
        String closing = StringsKt.repeat((CharSequence)"}}", (int)fieldParts.size());
        String hllMapping = "\"hll\":{\"type\":\"hll\",\"precision\":" + precision + ",\"doc_values\":true}";
        return opening + hllMapping + closing;
    }

    private static final CharSequence buildFieldMapping$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\":{\"properties\":{";
    }
}

