/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.apache.sis.internal.feature.j2d.DecimatedPathIterator;
import org.apache.sis.internal.feature.j2d.ShapeWrapper;

public final class DecimatedShape
extends ShapeWrapper {
    private static final long serialVersionUID = 3842608333341518892L;
    private final double xRes;
    private final double yRes;

    public DecimatedShape(Shape shape, double[] dArray) {
        super(shape);
        this.xRes = Math.abs(dArray[0]);
        this.yRes = Math.abs(dArray[1]);
    }

    public boolean isValid() {
        return this.xRes > 0.0 && this.yRes > 0.0 && this.xRes < Double.MAX_VALUE && this.yRes < Double.MAX_VALUE;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new DecimatedPathIterator(this.source.getPathIterator(affineTransform), this.xRes, this.yRes);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new DecimatedPathIterator(this.source.getPathIterator(affineTransform, d), this.xRes, this.yRes);
    }
}

