/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ContentInfoInputStreamWrapper
extends InputStream {
    private final InputStream delegate;
    private final ContentInfoUtil contentInfoUtil;
    private final byte[] firstBytes = new byte[10240];
    private int byteCount;
    private static ContentInfoUtil staticContentInfoUtil;

    public ContentInfoInputStreamWrapper(InputStream delegate, ContentInfoUtil contentInfoUtil) {
        this.delegate = delegate;
        this.contentInfoUtil = contentInfoUtil;
    }

    public ContentInfoInputStreamWrapper(InputStream delegate) {
        this(delegate, ContentInfoInputStreamWrapper.getStaticContentInfoUtil());
    }

    public ContentInfo findMatch() {
        byte[] readBytes = this.byteCount < this.firstBytes.length ? Arrays.copyOf(this.firstBytes, this.byteCount) : this.firstBytes;
        return this.contentInfoUtil.findMatch(readBytes);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public int read() throws IOException {
        int b = this.delegate.read();
        if (this.byteCount < this.firstBytes.length) {
            this.firstBytes[this.byteCount++] = (byte)b;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int left = this.firstBytes.length - this.byteCount;
        int numRead = this.delegate.read(b, off, len);
        if (left > numRead) {
            left = numRead;
        }
        for (int i = off; i < off + left; ++i) {
            this.firstBytes[this.byteCount++] = b[i];
        }
        return numRead;
    }

    @Override
    public long skip(long skipNum) throws IOException {
        int left = this.firstBytes.length - this.byteCount;
        if ((long)left > skipNum) {
            left = (int)skipNum;
        }
        int numRead = 0;
        if (left > 0) {
            numRead = this.read(this.firstBytes, this.byteCount, left);
            skipNum -= (long)numRead;
        }
        if (skipNum > 0L) {
            long numSkipped = this.delegate.skip(skipNum);
            return (long)numRead + numSkipped;
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    private static synchronized ContentInfoUtil getStaticContentInfoUtil() {
        if (staticContentInfoUtil == null) {
            staticContentInfoUtil = new ContentInfoUtil();
        }
        return staticContentInfoUtil;
    }
}

