/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.ConfigsetsApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteConfigSet
extends ConfigSetAPIBase
implements ConfigsetsApi.Delete {
    @Inject
    public DeleteConfigSet(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public SolrJerseyResponse deleteConfigSet(String configSetName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (StrUtils.isNullOrEmpty((String)configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No configset name provided to delete");
        }
        HashMap<String, Object> configsetCommandMsg = new HashMap<String, Object>();
        configsetCommandMsg.put("name", configSetName);
        this.runConfigSetCommand(this.solrQueryResponse, ConfigSetParams.ConfigSetAction.DELETE, configsetCommandMsg);
        return response;
    }
}

