/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.util.Version;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.response.transform.ValueAugmenterFactory;

public class ShardAugmenterFactory
extends TransformerFactory {
    protected Optional<Style> configuredDefaultStyle = Optional.empty();

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        if (this.defaultUserArgs != null) {
            this.configuredDefaultStyle = Style.getStyle(this.defaultUserArgs);
        }
    }

    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        SolrCore core = req.getCore();
        if (!core.getCoreContainer().isZooKeeperAware()) {
            return new ValueAugmenterFactory.ValueAugmenter(field, "[not a shard request]");
        }
        CloudDescriptor cd = core.getCoreDescriptor().getCloudDescriptor();
        if (null == cd) {
            return new ValueAugmenterFactory.ValueAugmenter(field, "[unknown]");
        }
        Style style = Style.getStyle(params.get("style", "")).or(() -> this.configuredDefaultStyle).orElse(core.getSolrConfig().luceneMatchVersion.onOrAfter(Version.LUCENE_9_5_0) ? Style.ID : Style.URLS);
        String shardId = cd.getShardId();
        if (style == Style.ID) {
            return new ValueAugmenterFactory.ValueAugmenter(field, shardId);
        }
        Slice slice = req.getCore().getCoreContainer().getZkController().getClusterState().getCollection(cd.getCollectionName()).getSlice(shardId);
        String urls = slice.getReplicas().stream().map(Replica::getCoreUrl).collect(Collectors.joining("|"));
        return new ValueAugmenterFactory.ValueAugmenter(field, urls);
    }

    protected static enum Style {
        URLS,
        ID;


        public static Optional<Style> getStyle(String s) {
            if (null == s || s.trim().isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of(Style.valueOf(s.toUpperCase(Locale.ROOT)));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown [shard] style: " + s);
            }
        }
    }
}

