﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appstream/AppStreamRequest.h>
#include <aws/appstream/AppStream_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppStream {
namespace Model {

/**
 */
class DeleteImagePermissionsRequest : public AppStreamRequest {
 public:
  AWS_APPSTREAM_API DeleteImagePermissionsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteImagePermissions"; }

  AWS_APPSTREAM_API Aws::String SerializePayload() const override;

  AWS_APPSTREAM_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the private image.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DeleteImagePermissionsRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The 12-digit identifier of the AWS account for which to delete image
   * permissions.</p>
   */
  inline const Aws::String& GetSharedAccountId() const { return m_sharedAccountId; }
  inline bool SharedAccountIdHasBeenSet() const { return m_sharedAccountIdHasBeenSet; }
  template <typename SharedAccountIdT = Aws::String>
  void SetSharedAccountId(SharedAccountIdT&& value) {
    m_sharedAccountIdHasBeenSet = true;
    m_sharedAccountId = std::forward<SharedAccountIdT>(value);
  }
  template <typename SharedAccountIdT = Aws::String>
  DeleteImagePermissionsRequest& WithSharedAccountId(SharedAccountIdT&& value) {
    SetSharedAccountId(std::forward<SharedAccountIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_sharedAccountId;
  bool m_sharedAccountIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppStream
}  // namespace Aws
