/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import proguard.gui.FilterBuilder;
import proguard.gui.GUIResources;
import proguard.optimize.Optimizer;
import proguard.util.FixedStringMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringParser;

final class OptimizationsDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final JCheckBox[] optimizationCheckBoxes = new JCheckBox[Optimizer.OPTIMIZATION_NAMES.length];
    private int returnValue;

    public OptimizationsDialog(JFrame owner) {
        super(owner, OptimizationsDialog.msg("selectOptimizations"), true);
        this.setResizable(true);
        GridBagConstraints constraintsLast = new GridBagConstraints();
        constraintsLast.gridwidth = 0;
        constraintsLast.anchor = 17;
        constraintsLast.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraintsLast.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraintsLast.insets;
        GridBagConstraints selectButtonConstraints = new GridBagConstraints();
        selectButtonConstraints.weighty = 1.0;
        selectButtonConstraints.anchor = 16;
        selectButtonConstraints.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.weightx = 1.0;
        okButtonConstraints.weighty = 1.0;
        okButtonConstraints.anchor = 14;
        okButtonConstraints.insets = selectButtonConstraints.insets;
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridwidth = 0;
        cancelButtonConstraints.weighty = 1.0;
        cancelButtonConstraints.anchor = 14;
        cancelButtonConstraints.insets = selectButtonConstraints.insets;
        GridBagLayout layout = new GridBagLayout();
        Border etchedBorder = BorderFactory.createEtchedBorder(0);
        JPanel optimizationsPanel = new JPanel(layout);
        JPanel optimizationSubpanel = null;
        String lastOptimizationPrefix = null;
        for (int index = 0; index < Optimizer.OPTIMIZATION_NAMES.length; ++index) {
            JCheckBox optimizationCheckBox;
            String optimizationName = Optimizer.OPTIMIZATION_NAMES[index];
            String optimizationPrefix = optimizationName.substring(0, optimizationName.indexOf(47));
            if (optimizationSubpanel == null || !optimizationPrefix.equals(lastOptimizationPrefix)) {
                optimizationSubpanel = new JPanel(layout);
                optimizationSubpanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, OptimizationsDialog.msg(optimizationPrefix)));
                optimizationsPanel.add((Component)optimizationSubpanel, panelConstraints);
                lastOptimizationPrefix = optimizationPrefix;
            }
            this.optimizationCheckBoxes[index] = optimizationCheckBox = new JCheckBox(optimizationName);
            optimizationSubpanel.add((Component)OptimizationsDialog.tip(optimizationCheckBox, optimizationName.replace('/', '_') + "Tip"), constraintsLastStretch);
        }
        JButton selectAllButton = new JButton(OptimizationsDialog.msg("selectAll"));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int index = 0; index < OptimizationsDialog.this.optimizationCheckBoxes.length; ++index) {
                    OptimizationsDialog.this.optimizationCheckBoxes[index].setSelected(true);
                }
            }
        });
        JButton selectNoneButton = new JButton(OptimizationsDialog.msg("selectNone"));
        selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int index = 0; index < OptimizationsDialog.this.optimizationCheckBoxes.length; ++index) {
                    OptimizationsDialog.this.optimizationCheckBoxes[index].setSelected(false);
                }
            }
        });
        JButton okButton = new JButton(OptimizationsDialog.msg("ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizationsDialog.this.returnValue = 0;
                OptimizationsDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton(OptimizationsDialog.msg("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizationsDialog.this.hide();
            }
        });
        optimizationsPanel.add((Component)selectAllButton, selectButtonConstraints);
        optimizationsPanel.add((Component)selectNoneButton, selectButtonConstraints);
        optimizationsPanel.add((Component)okButton, okButtonConstraints);
        optimizationsPanel.add((Component)cancelButton, cancelButtonConstraints);
        this.getContentPane().add(new JScrollPane(optimizationsPanel));
    }

    public void setFilter(String optimizations) {
        FixedStringMatcher filter = optimizations != null && optimizations.length() > 0 ? new ListParser((StringParser)new NameParser()).parse(optimizations) : new FixedStringMatcher("");
        for (int index = 0; index < Optimizer.OPTIMIZATION_NAMES.length; ++index) {
            this.optimizationCheckBoxes[index].setSelected(filter.matches(Optimizer.OPTIMIZATION_NAMES[index]));
        }
    }

    public String getFilter() {
        return new FilterBuilder(this.optimizationCheckBoxes, '/').buildFilter();
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(OptimizationsDialog.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

