'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   Copyright (C) the Wine project
''
''   This library is free software; you can redistribute it and/or
''   modify it under the terms of the GNU Lesser General Public
''   License as published by the Free Software Foundation; either
''   version 2.1 of the License, or (at your option) any later version.
''
''   This library is distributed in the hope that it will be useful,
''   but WITHOUT ANY WARRANTY; without even the implied warranty of
''   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
''   Lesser General Public License for more details.
''
''   You should have received a copy of the GNU Lesser General Public
''   License along with this library; if not, write to the Free Software
''   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#inclib "uuid"

#include once "objbase.bi"

extern "Windows"

#define __DINPUT_INCLUDED__
const DIRECTINPUT_VERSION = &h0800
extern CLSID_DirectInput as const GUID
extern CLSID_DirectInputDevice as const GUID
extern CLSID_DirectInput8 as const GUID
extern CLSID_DirectInputDevice8 as const GUID
extern IID_IDirectInputA as const GUID
extern IID_IDirectInputW as const GUID
extern IID_IDirectInput2A as const GUID
extern IID_IDirectInput2W as const GUID
extern IID_IDirectInput7A as const GUID
extern IID_IDirectInput7W as const GUID
extern IID_IDirectInput8A as const GUID
extern IID_IDirectInput8W as const GUID
extern IID_IDirectInputDeviceA as const GUID
extern IID_IDirectInputDeviceW as const GUID
extern IID_IDirectInputDevice2A as const GUID
extern IID_IDirectInputDevice2W as const GUID
extern IID_IDirectInputDevice7A as const GUID
extern IID_IDirectInputDevice7W as const GUID
extern IID_IDirectInputDevice8A as const GUID
extern IID_IDirectInputDevice8W as const GUID
extern IID_IDirectInputEffect as const GUID
extern GUID_XAxis as const GUID
extern GUID_YAxis as const GUID
extern GUID_ZAxis as const GUID
extern GUID_RxAxis as const GUID
extern GUID_RyAxis as const GUID
extern GUID_RzAxis as const GUID
extern GUID_Slider as const GUID
extern GUID_Button as const GUID
extern GUID_Key as const GUID
extern GUID_POV as const GUID
extern GUID_Unknown as const GUID
extern GUID_SysMouse as const GUID
extern GUID_SysKeyboard as const GUID
extern GUID_Joystick as const GUID
extern GUID_SysMouseEm as const GUID
extern GUID_SysMouseEm2 as const GUID
extern GUID_SysKeyboardEm as const GUID
extern GUID_SysKeyboardEm2 as const GUID
extern GUID_ConstantForce as const GUID
extern GUID_RampForce as const GUID
extern GUID_Square as const GUID
extern GUID_Sine as const GUID
extern GUID_Triangle as const GUID
extern GUID_SawtoothUp as const GUID
extern GUID_SawtoothDown as const GUID
extern GUID_Spring as const GUID
extern GUID_Damper as const GUID
extern GUID_Inertia as const GUID
extern GUID_Friction as const GUID
extern GUID_CustomForce as const GUID

type LPDIRECTINPUTA as IDirectInputA ptr
type LPDIRECTINPUTW as IDirectInputW ptr
type LPDIRECTINPUT2A as IDirectInput2A ptr
type LPDIRECTINPUT2W as IDirectInput2W ptr
type LPDIRECTINPUT7A as IDirectInput7A ptr
type LPDIRECTINPUT7W as IDirectInput7W ptr
type LPDIRECTINPUT8A as IDirectInput8A ptr
type LPDIRECTINPUT8W as IDirectInput8W ptr
type LPDIRECTINPUTDEVICEA as IDirectInputDeviceA ptr
type LPDIRECTINPUTDEVICEW as IDirectInputDeviceW ptr
type LPDIRECTINPUTDEVICE2A as IDirectInputDevice2A ptr
type LPDIRECTINPUTDEVICE2W as IDirectInputDevice2W ptr
type LPDIRECTINPUTDEVICE7A as IDirectInputDevice7A ptr
type LPDIRECTINPUTDEVICE7W as IDirectInputDevice7W ptr
type LPDIRECTINPUTDEVICE8A as IDirectInputDevice8A ptr
type LPDIRECTINPUTDEVICE8W as IDirectInputDevice8W ptr
type LPDIRECTINPUTEFFECT as IDirectInputEffect ptr
type LPSYSKEYBOARDA as SysKeyboardA ptr
type LPSYSMOUSEA as SysMouseA ptr

#ifdef UNICODE
	extern IID_IDirectInput alias "IID_IDirectInputW" as const GUID
	type IDirectInput as IDirectInputW
	type LPDIRECTINPUT as LPDIRECTINPUTW
	extern IID_IDirectInput2 alias "IID_IDirectInput2W" as const GUID
	type IDirectInput2 as IDirectInput2W
	type LPDIRECTINPUT2 as LPDIRECTINPUT2W
	extern IID_IDirectInput7 alias "IID_IDirectInput7W" as const GUID
	type IDirectInput7 as IDirectInput7W
	type LPDIRECTINPUT7 as LPDIRECTINPUT7W
	extern IID_IDirectInput8 alias "IID_IDirectInput8W" as const GUID
	type IDirectInput8 as IDirectInput8W
	type LPDIRECTINPUT8 as LPDIRECTINPUT8W
	extern IID_IDirectInputDevice alias "IID_IDirectInputDeviceW" as const GUID
	type IDirectInputDevice as IDirectInputDeviceW
	type LPDIRECTINPUTDEVICE as LPDIRECTINPUTDEVICEW
	extern IID_IDirectInputDevice2 alias "IID_IDirectInputDevice2W" as const GUID
	type IDirectInputDevice2 as IDirectInputDevice2W
	type LPDIRECTINPUTDEVICE2 as LPDIRECTINPUTDEVICE2W
	extern IID_IDirectInputDevice7 alias "IID_IDirectInputDevice7W" as const GUID
	type IDirectInputDevice7 as IDirectInputDevice7W
	type LPDIRECTINPUTDEVICE7 as LPDIRECTINPUTDEVICE7W
	extern IID_IDirectInputDevice8 alias "IID_IDirectInputDevice8W" as const GUID
	type IDirectInputDevice8 as IDirectInputDevice8W
	type LPDIRECTINPUTDEVICE8 as LPDIRECTINPUTDEVICE8W
#else
	extern IID_IDirectInput alias "IID_IDirectInputA" as const GUID
	type IDirectInput as IDirectInputA
	type LPDIRECTINPUT as LPDIRECTINPUTA
	extern IID_IDirectInput2 alias "IID_IDirectInput2A" as const GUID
	type IDirectInput2 as IDirectInput2A
	type LPDIRECTINPUT2 as LPDIRECTINPUT2A
	extern IID_IDirectInput7 alias "IID_IDirectInput7A" as const GUID
	type IDirectInput7 as IDirectInput7A
	type LPDIRECTINPUT7 as LPDIRECTINPUT7A
	extern IID_IDirectInput8 alias "IID_IDirectInput8A" as const GUID
	type IDirectInput8 as IDirectInput8A
	type LPDIRECTINPUT8 as LPDIRECTINPUT8A
	extern IID_IDirectInputDevice alias "IID_IDirectInputDeviceA" as const GUID
	type IDirectInputDevice as IDirectInputDeviceA
	type LPDIRECTINPUTDEVICE as LPDIRECTINPUTDEVICEA
	extern IID_IDirectInputDevice2 alias "IID_IDirectInputDevice2A" as const GUID
	type IDirectInputDevice2 as IDirectInputDevice2A
	type LPDIRECTINPUTDEVICE2 as LPDIRECTINPUTDEVICE2A
	extern IID_IDirectInputDevice7 alias "IID_IDirectInputDevice7A" as const GUID
	type IDirectInputDevice7 as IDirectInputDevice7A
	type LPDIRECTINPUTDEVICE7 as LPDIRECTINPUTDEVICE7A
	extern IID_IDirectInputDevice8 alias "IID_IDirectInputDevice8A" as const GUID
	type IDirectInputDevice8 as IDirectInputDevice8A
	type LPDIRECTINPUTDEVICE8 as LPDIRECTINPUTDEVICE8A
#endif

const DI_OK = S_OK
const DI_NOTATTACHED = S_FALSE
const DI_BUFFEROVERFLOW = S_FALSE
const DI_PROPNOEFFECT = S_FALSE
const DI_NOEFFECT = S_FALSE
const DI_POLLEDDEVICE = cast(HRESULT, &h00000002)
const DI_DOWNLOADSKIPPED = cast(HRESULT, &h00000003)
const DI_EFFECTRESTARTED = cast(HRESULT, &h00000004)
const DI_TRUNCATED = cast(HRESULT, &h00000008)
const DI_SETTINGSNOTSAVED = cast(HRESULT, &h0000000B)
const DI_TRUNCATEDANDRESTARTED = cast(HRESULT, &h0000000C)
const DI_WRITEPROTECT = cast(HRESULT, &h00000013)
#define DIERR_OLDDIRECTINPUTVERSION MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_OLD_WIN_VERSION)
#define DIERR_BETADIRECTINPUTVERSION MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_RMODE_APP)
#define DIERR_BADDRIVERVER MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_BAD_DRIVER_LEVEL)
#define DIERR_DEVICENOTREG REGDB_E_CLASSNOTREG
#define DIERR_NOTFOUND MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_FILE_NOT_FOUND)
#define DIERR_OBJECTNOTFOUND MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_FILE_NOT_FOUND)
#define DIERR_INVALIDPARAM E_INVALIDARG
#define DIERR_NOINTERFACE E_NOINTERFACE
#define DIERR_GENERIC E_FAIL
#define DIERR_OUTOFMEMORY E_OUTOFMEMORY
#define DIERR_UNSUPPORTED E_NOTIMPL
#define DIERR_NOTINITIALIZED MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_NOT_READY)
#define DIERR_ALREADYINITIALIZED MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_ALREADY_INITIALIZED)
#define DIERR_NOAGGREGATION CLASS_E_NOAGGREGATION
#define DIERR_OTHERAPPHASPRIO E_ACCESSDENIED
#define DIERR_INPUTLOST MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_READ_FAULT)
#define DIERR_ACQUIRED MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_BUSY)
#define DIERR_NOTACQUIRED MAKE_HRESULT(SEVERITY_ERROR, FACILITY_WIN32, ERROR_INVALID_ACCESS)
#define DIERR_READONLY E_ACCESSDENIED
#define DIERR_HANDLEEXISTS E_ACCESSDENIED
const DIERR_INSUFFICIENTPRIVS = &h80040200
const DIERR_DEVICEFULL = &h80040201
const DIERR_MOREDATA = &h80040202
const DIERR_NOTDOWNLOADED = &h80040203
const DIERR_HASEFFECTS = &h80040204
const DIERR_NOTEXCLUSIVEACQUIRED = &h80040205
const DIERR_INCOMPLETEEFFECT = &h80040206
const DIERR_NOTBUFFERED = &h80040207
const DIERR_EFFECTPLAYING = &h80040208
const DIERR_UNPLUGGED = &h80040209
const DIERR_REPORTFULL = &h8004020A
const DIERR_MAPFILEFAIL = &h8004020B
const DIENUM_STOP = 0
const DIENUM_CONTINUE = 1
const DIEDFL_ALLDEVICES = &h00000000
const DIEDFL_ATTACHEDONLY = &h00000001
const DIEDFL_FORCEFEEDBACK = &h00000100
const DIEDFL_INCLUDEALIASES = &h00010000
const DIEDFL_INCLUDEPHANTOMS = &h00020000
const DIEDFL_INCLUDEHIDDEN = &h00040000
const DIDEVTYPE_DEVICE = 1
const DIDEVTYPE_MOUSE = 2
const DIDEVTYPE_KEYBOARD = 3
const DIDEVTYPE_JOYSTICK = 4
const DIDEVTYPE_HID = &h00010000
const DI8DEVCLASS_ALL = 0
const DI8DEVCLASS_DEVICE = 1
const DI8DEVCLASS_POINTER = 2
const DI8DEVCLASS_KEYBOARD = 3
const DI8DEVCLASS_GAMECTRL = 4
const DI8DEVTYPE_DEVICE = &h11
const DI8DEVTYPE_MOUSE = &h12
const DI8DEVTYPE_KEYBOARD = &h13
const DI8DEVTYPE_JOYSTICK = &h14
const DI8DEVTYPE_GAMEPAD = &h15
const DI8DEVTYPE_DRIVING = &h16
const DI8DEVTYPE_FLIGHT = &h17
const DI8DEVTYPE_1STPERSON = &h18
const DI8DEVTYPE_DEVICECTRL = &h19
const DI8DEVTYPE_SCREENPOINTER = &h1A
const DI8DEVTYPE_REMOTE = &h1B
const DI8DEVTYPE_SUPPLEMENTAL = &h1C
const DIDEVTYPEMOUSE_UNKNOWN = 1
const DIDEVTYPEMOUSE_TRADITIONAL = 2
const DIDEVTYPEMOUSE_FINGERSTICK = 3
const DIDEVTYPEMOUSE_TOUCHPAD = 4
const DIDEVTYPEMOUSE_TRACKBALL = 5
const DIDEVTYPEKEYBOARD_UNKNOWN = 0
const DIDEVTYPEKEYBOARD_PCXT = 1
const DIDEVTYPEKEYBOARD_OLIVETTI = 2
const DIDEVTYPEKEYBOARD_PCAT = 3
const DIDEVTYPEKEYBOARD_PCENH = 4
const DIDEVTYPEKEYBOARD_NOKIA1050 = 5
const DIDEVTYPEKEYBOARD_NOKIA9140 = 6
const DIDEVTYPEKEYBOARD_NEC98 = 7
const DIDEVTYPEKEYBOARD_NEC98LAPTOP = 8
const DIDEVTYPEKEYBOARD_NEC98106 = 9
const DIDEVTYPEKEYBOARD_JAPAN106 = 10
const DIDEVTYPEKEYBOARD_JAPANAX = 11
const DIDEVTYPEKEYBOARD_J3100 = 12
const DIDEVTYPEJOYSTICK_UNKNOWN = 1
const DIDEVTYPEJOYSTICK_TRADITIONAL = 2
const DIDEVTYPEJOYSTICK_FLIGHTSTICK = 3
const DIDEVTYPEJOYSTICK_GAMEPAD = 4
const DIDEVTYPEJOYSTICK_RUDDER = 5
const DIDEVTYPEJOYSTICK_WHEEL = 6
const DIDEVTYPEJOYSTICK_HEADTRACKER = 7
const DI8DEVTYPEMOUSE_UNKNOWN = 1
const DI8DEVTYPEMOUSE_TRADITIONAL = 2
const DI8DEVTYPEMOUSE_FINGERSTICK = 3
const DI8DEVTYPEMOUSE_TOUCHPAD = 4
const DI8DEVTYPEMOUSE_TRACKBALL = 5
const DI8DEVTYPEMOUSE_ABSOLUTE = 6
const DI8DEVTYPEKEYBOARD_UNKNOWN = 0
const DI8DEVTYPEKEYBOARD_PCXT = 1
const DI8DEVTYPEKEYBOARD_OLIVETTI = 2
const DI8DEVTYPEKEYBOARD_PCAT = 3
const DI8DEVTYPEKEYBOARD_PCENH = 4
const DI8DEVTYPEKEYBOARD_NOKIA1050 = 5
const DI8DEVTYPEKEYBOARD_NOKIA9140 = 6
const DI8DEVTYPEKEYBOARD_NEC98 = 7
const DI8DEVTYPEKEYBOARD_NEC98LAPTOP = 8
const DI8DEVTYPEKEYBOARD_NEC98106 = 9
const DI8DEVTYPEKEYBOARD_JAPAN106 = 10
const DI8DEVTYPEKEYBOARD_JAPANAX = 11
const DI8DEVTYPEKEYBOARD_J3100 = 12
const DI8DEVTYPE_LIMITEDGAMESUBTYPE = 1
const DI8DEVTYPEJOYSTICK_LIMITED = DI8DEVTYPE_LIMITEDGAMESUBTYPE
const DI8DEVTYPEJOYSTICK_STANDARD = 2
const DI8DEVTYPEGAMEPAD_LIMITED = DI8DEVTYPE_LIMITEDGAMESUBTYPE
const DI8DEVTYPEGAMEPAD_STANDARD = 2
const DI8DEVTYPEGAMEPAD_TILT = 3
const DI8DEVTYPEDRIVING_LIMITED = DI8DEVTYPE_LIMITEDGAMESUBTYPE
const DI8DEVTYPEDRIVING_COMBINEDPEDALS = 2
const DI8DEVTYPEDRIVING_DUALPEDALS = 3
const DI8DEVTYPEDRIVING_THREEPEDALS = 4
const DI8DEVTYPEDRIVING_HANDHELD = 5
const DI8DEVTYPEFLIGHT_LIMITED = DI8DEVTYPE_LIMITEDGAMESUBTYPE
const DI8DEVTYPEFLIGHT_STICK = 2
const DI8DEVTYPEFLIGHT_YOKE = 3
const DI8DEVTYPEFLIGHT_RC = 4
const DI8DEVTYPE1STPERSON_LIMITED = DI8DEVTYPE_LIMITEDGAMESUBTYPE
const DI8DEVTYPE1STPERSON_UNKNOWN = 2
const DI8DEVTYPE1STPERSON_SIXDOF = 3
const DI8DEVTYPE1STPERSON_SHOOTER = 4
const DI8DEVTYPESCREENPTR_UNKNOWN = 2
const DI8DEVTYPESCREENPTR_LIGHTGUN = 3
const DI8DEVTYPESCREENPTR_LIGHTPEN = 4
const DI8DEVTYPESCREENPTR_TOUCH = 5
const DI8DEVTYPEREMOTE_UNKNOWN = 2
const DI8DEVTYPEDEVICECTRL_UNKNOWN = 2
const DI8DEVTYPEDEVICECTRL_COMMSSELECTION = 3
const DI8DEVTYPEDEVICECTRL_COMMSSELECTION_HARDWIRED = 4
const DI8DEVTYPESUPPLEMENTAL_UNKNOWN = 2
const DI8DEVTYPESUPPLEMENTAL_2NDHANDCONTROLLER = 3
const DI8DEVTYPESUPPLEMENTAL_HEADTRACKER = 4
const DI8DEVTYPESUPPLEMENTAL_HANDTRACKER = 5
const DI8DEVTYPESUPPLEMENTAL_SHIFTSTICKGATE = 6
const DI8DEVTYPESUPPLEMENTAL_SHIFTER = 7
const DI8DEVTYPESUPPLEMENTAL_THROTTLE = 8
const DI8DEVTYPESUPPLEMENTAL_SPLITTHROTTLE = 9
const DI8DEVTYPESUPPLEMENTAL_COMBINEDPEDALS = 10
const DI8DEVTYPESUPPLEMENTAL_DUALPEDALS = 11
const DI8DEVTYPESUPPLEMENTAL_THREEPEDALS = 12
const DI8DEVTYPESUPPLEMENTAL_RUDDERPEDALS = 13
#define GET_DIDEVICE_TYPE(dwDevType) LOBYTE(dwDevType)
#define GET_DIDEVICE_SUBTYPE(dwDevType) HIBYTE(dwDevType)

type DIDEVICEOBJECTINSTANCE_DX3A
	dwSize as DWORD
	guidType as GUID
	dwOfs as DWORD
	dwType as DWORD
	dwFlags as DWORD
	tszName as zstring * 260
end type

type LPDIDEVICEOBJECTINSTANCE_DX3A as DIDEVICEOBJECTINSTANCE_DX3A ptr
type LPCDIDEVICEOBJECTINSTANCE_DX3A as const DIDEVICEOBJECTINSTANCE_DX3A ptr

type DIDEVICEOBJECTINSTANCE_DX3W
	dwSize as DWORD
	guidType as GUID
	dwOfs as DWORD
	dwType as DWORD
	dwFlags as DWORD
	tszName as wstring * 260
end type

type LPDIDEVICEOBJECTINSTANCE_DX3W as DIDEVICEOBJECTINSTANCE_DX3W ptr
type LPCDIDEVICEOBJECTINSTANCE_DX3W as const DIDEVICEOBJECTINSTANCE_DX3W ptr

#ifdef UNICODE
	type DIDEVICEOBJECTINSTANCE_DX3 as DIDEVICEOBJECTINSTANCE_DX3W
	type LPDIDEVICEOBJECTINSTANCE_DX3 as LPDIDEVICEOBJECTINSTANCE_DX3W
	type LPCDIDEVICEOBJECTINSTANCE_DX3 as LPCDIDEVICEOBJECTINSTANCE_DX3W
#else
	type DIDEVICEOBJECTINSTANCE_DX3 as DIDEVICEOBJECTINSTANCE_DX3A
	type LPDIDEVICEOBJECTINSTANCE_DX3 as LPDIDEVICEOBJECTINSTANCE_DX3A
	type LPCDIDEVICEOBJECTINSTANCE_DX3 as LPCDIDEVICEOBJECTINSTANCE_DX3A
#endif

type DIDEVICEOBJECTINSTANCEA
	dwSize as DWORD
	guidType as GUID
	dwOfs as DWORD
	dwType as DWORD
	dwFlags as DWORD
	tszName as zstring * 260
	dwFFMaxForce as DWORD
	dwFFForceResolution as DWORD
	wCollectionNumber as WORD
	wDesignatorIndex as WORD
	wUsagePage as WORD
	wUsage as WORD
	dwDimension as DWORD
	wExponent as WORD
	wReserved as WORD
end type

type LPDIDEVICEOBJECTINSTANCEA as DIDEVICEOBJECTINSTANCEA ptr
type LPCDIDEVICEOBJECTINSTANCEA as const DIDEVICEOBJECTINSTANCEA ptr

type DIDEVICEOBJECTINSTANCEW
	dwSize as DWORD
	guidType as GUID
	dwOfs as DWORD
	dwType as DWORD
	dwFlags as DWORD
	tszName as wstring * 260
	dwFFMaxForce as DWORD
	dwFFForceResolution as DWORD
	wCollectionNumber as WORD
	wDesignatorIndex as WORD
	wUsagePage as WORD
	wUsage as WORD
	dwDimension as DWORD
	wExponent as WORD
	wReserved as WORD
end type

type LPDIDEVICEOBJECTINSTANCEW as DIDEVICEOBJECTINSTANCEW ptr
type LPCDIDEVICEOBJECTINSTANCEW as const DIDEVICEOBJECTINSTANCEW ptr

#ifdef UNICODE
	type DIDEVICEOBJECTINSTANCE as DIDEVICEOBJECTINSTANCEW
	type LPDIDEVICEOBJECTINSTANCE as LPDIDEVICEOBJECTINSTANCEW
	type LPCDIDEVICEOBJECTINSTANCE as LPCDIDEVICEOBJECTINSTANCEW
#else
	type DIDEVICEOBJECTINSTANCE as DIDEVICEOBJECTINSTANCEA
	type LPDIDEVICEOBJECTINSTANCE as LPDIDEVICEOBJECTINSTANCEA
	type LPCDIDEVICEOBJECTINSTANCE as LPCDIDEVICEOBJECTINSTANCEA
#endif

type DIDEVICEINSTANCE_DX3A
	dwSize as DWORD
	guidInstance as GUID
	guidProduct as GUID
	dwDevType as DWORD
	tszInstanceName as zstring * 260
	tszProductName as zstring * 260
end type

type LPDIDEVICEINSTANCE_DX3A as DIDEVICEINSTANCE_DX3A ptr
type LPCDIDEVICEINSTANCE_DX3A as const DIDEVICEINSTANCE_DX3A ptr

type DIDEVICEINSTANCE_DX3W
	dwSize as DWORD
	guidInstance as GUID
	guidProduct as GUID
	dwDevType as DWORD
	tszInstanceName as wstring * 260
	tszProductName as wstring * 260
end type

type LPDIDEVICEINSTANCE_DX3W as DIDEVICEINSTANCE_DX3W ptr
type LPCDIDEVICEINSTANCE_DX3W as const DIDEVICEINSTANCE_DX3W ptr

#ifdef UNICODE
	type DIDEVICEINSTANCE_DX3 as DIDEVICEINSTANCE_DX3W
	type LPDIDEVICEINSTANCE_DX3 as LPDIDEVICEINSTANCE_DX3W
	type LPCDIDEVICEINSTANCE_DX3 as LPCDIDEVICEINSTANCE_DX3W
#else
	type DIDEVICEINSTANCE_DX3 as DIDEVICEINSTANCE_DX3A
	type LPDIDEVICEINSTANCE_DX3 as LPDIDEVICEINSTANCE_DX3A
	type LPCDIDEVICEINSTANCE_DX3 as LPCDIDEVICEINSTANCE_DX3A
#endif

type DIDEVICEINSTANCEA
	dwSize as DWORD
	guidInstance as GUID
	guidProduct as GUID
	dwDevType as DWORD
	tszInstanceName as zstring * 260
	tszProductName as zstring * 260
	guidFFDriver as GUID
	wUsagePage as WORD
	wUsage as WORD
end type

type LPDIDEVICEINSTANCEA as DIDEVICEINSTANCEA ptr
type LPCDIDEVICEINSTANCEA as const DIDEVICEINSTANCEA ptr

type DIDEVICEINSTANCEW
	dwSize as DWORD
	guidInstance as GUID
	guidProduct as GUID
	dwDevType as DWORD
	tszInstanceName as wstring * 260
	tszProductName as wstring * 260
	guidFFDriver as GUID
	wUsagePage as WORD
	wUsage as WORD
end type

type LPDIDEVICEINSTANCEW as DIDEVICEINSTANCEW ptr
type LPCDIDEVICEINSTANCEW as const DIDEVICEINSTANCEW ptr

#ifdef UNICODE
	type DIDEVICEINSTANCE as DIDEVICEINSTANCEW
	type LPDIDEVICEINSTANCE as LPDIDEVICEINSTANCEW
	type LPCDIDEVICEINSTANCE as LPCDIDEVICEINSTANCEW
#else
	type DIDEVICEINSTANCE as DIDEVICEINSTANCEA
	type LPDIDEVICEINSTANCE as LPDIDEVICEINSTANCEA
	type LPCDIDEVICEINSTANCE as LPCDIDEVICEINSTANCEA
#endif

type LPDIENUMDEVICESCALLBACKA as function(byval as LPCDIDEVICEINSTANCEA, byval as LPVOID) as BOOL
type LPDIENUMDEVICESCALLBACKW as function(byval as LPCDIDEVICEINSTANCEW, byval as LPVOID) as BOOL

#ifdef UNICODE
	type LPDIENUMDEVICESCALLBACK as LPDIENUMDEVICESCALLBACKW
#else
	type LPDIENUMDEVICESCALLBACK as LPDIENUMDEVICESCALLBACKA
#endif

const DIEDBS_MAPPEDPRI1 = &h00000001
const DIEDBS_MAPPEDPRI2 = &h00000002
const DIEDBS_RECENTDEVICE = &h00000010
const DIEDBS_NEWDEVICE = &h00000020
const DIEDBSFL_ATTACHEDONLY = &h00000000
const DIEDBSFL_THISUSER = &h00000010
const DIEDBSFL_FORCEFEEDBACK = DIEDFL_FORCEFEEDBACK
const DIEDBSFL_AVAILABLEDEVICES = &h00001000
const DIEDBSFL_MULTIMICEKEYBOARDS = &h00002000
const DIEDBSFL_NONGAMINGDEVICES = &h00004000
const DIEDBSFL_VALID = &h00007110
type LPDIENUMDEVICESBYSEMANTICSCBA as function(byval as LPCDIDEVICEINSTANCEA, byval as LPDIRECTINPUTDEVICE8A, byval as DWORD, byval as DWORD, byval as LPVOID) as BOOL
type LPDIENUMDEVICESBYSEMANTICSCBW as function(byval as LPCDIDEVICEINSTANCEW, byval as LPDIRECTINPUTDEVICE8W, byval as DWORD, byval as DWORD, byval as LPVOID) as BOOL

#ifdef UNICODE
	type LPDIENUMDEVICESBYSEMANTICSCB as LPDIENUMDEVICESBYSEMANTICSCBW
#else
	type LPDIENUMDEVICESBYSEMANTICSCB as LPDIENUMDEVICESBYSEMANTICSCBA
#endif

type LPDICONFIGUREDEVICESCALLBACK as function(byval as LPUNKNOWN, byval as LPVOID) as BOOL
type LPDIENUMDEVICEOBJECTSCALLBACKA as function(byval as LPCDIDEVICEOBJECTINSTANCEA, byval as LPVOID) as BOOL
type LPDIENUMDEVICEOBJECTSCALLBACKW as function(byval as LPCDIDEVICEOBJECTINSTANCEW, byval as LPVOID) as BOOL

#ifdef UNICODE
	type LPDIENUMDEVICEOBJECTSCALLBACK as LPDIENUMDEVICEOBJECTSCALLBACKW
#else
	type LPDIENUMDEVICEOBJECTSCALLBACK as LPDIENUMDEVICEOBJECTSCALLBACKA
#endif

type LPDIENUMCREATEDEFFECTOBJECTSCALLBACK as function(byval as LPDIRECTINPUTEFFECT, byval as LPVOID) as BOOL
const DIK_ESCAPE = &h01
const DIK_1 = &h02
const DIK_2 = &h03
const DIK_3 = &h04
const DIK_4 = &h05
const DIK_5 = &h06
const DIK_6 = &h07
const DIK_7 = &h08
const DIK_8 = &h09
const DIK_9 = &h0A
const DIK_0 = &h0B
const DIK_MINUS = &h0C
const DIK_EQUALS = &h0D
const DIK_BACK = &h0E
const DIK_TAB = &h0F
const DIK_Q = &h10
const DIK_W = &h11
const DIK_E = &h12
const DIK_R = &h13
const DIK_T = &h14
const DIK_Y = &h15
const DIK_U = &h16
const DIK_I = &h17
const DIK_O = &h18
const DIK_P = &h19
const DIK_LBRACKET = &h1A
const DIK_RBRACKET = &h1B
const DIK_RETURN = &h1C
const DIK_LCONTROL = &h1D
const DIK_A = &h1E
const DIK_S = &h1F
const DIK_D = &h20
const DIK_F = &h21
const DIK_G = &h22
const DIK_H = &h23
const DIK_J = &h24
const DIK_K = &h25
const DIK_L = &h26
const DIK_SEMICOLON = &h27
const DIK_APOSTROPHE = &h28
const DIK_GRAVE = &h29
const DIK_LSHIFT = &h2A
const DIK_BACKSLASH = &h2B
const DIK_Z = &h2C
const DIK_X = &h2D
const DIK_C = &h2E
const DIK_V = &h2F
const DIK_B = &h30
const DIK_N = &h31
const DIK_M = &h32
const DIK_COMMA = &h33
const DIK_PERIOD = &h34
const DIK_SLASH = &h35
const DIK_RSHIFT = &h36
const DIK_MULTIPLY = &h37
const DIK_LMENU = &h38
const DIK_SPACE = &h39
const DIK_CAPITAL = &h3A
const DIK_F1 = &h3B
const DIK_F2 = &h3C
const DIK_F3 = &h3D
const DIK_F4 = &h3E
const DIK_F5 = &h3F
const DIK_F6 = &h40
const DIK_F7 = &h41
const DIK_F8 = &h42
const DIK_F9 = &h43
const DIK_F10 = &h44
const DIK_NUMLOCK = &h45
const DIK_SCROLL = &h46
const DIK_NUMPAD7 = &h47
const DIK_NUMPAD8 = &h48
const DIK_NUMPAD9 = &h49
const DIK_SUBTRACT = &h4A
const DIK_NUMPAD4 = &h4B
const DIK_NUMPAD5 = &h4C
const DIK_NUMPAD6 = &h4D
const DIK_ADD = &h4E
const DIK_NUMPAD1 = &h4F
const DIK_NUMPAD2 = &h50
const DIK_NUMPAD3 = &h51
const DIK_NUMPAD0 = &h52
const DIK_DECIMAL = &h53
const DIK_OEM_102 = &h56
const DIK_F11 = &h57
const DIK_F12 = &h58
const DIK_F13 = &h64
const DIK_F14 = &h65
const DIK_F15 = &h66
const DIK_KANA = &h70
const DIK_ABNT_C1 = &h73
const DIK_CONVERT = &h79
const DIK_NOCONVERT = &h7B
const DIK_YEN = &h7D
const DIK_ABNT_C2 = &h7E
const DIK_NUMPADEQUALS = &h8D
const DIK_CIRCUMFLEX = &h90
const DIK_AT = &h91
const DIK_COLON = &h92
const DIK_UNDERLINE = &h93
const DIK_KANJI = &h94
const DIK_STOP = &h95
const DIK_AX = &h96
const DIK_UNLABELED = &h97
const DIK_NEXTTRACK = &h99
const DIK_NUMPADENTER = &h9C
const DIK_RCONTROL = &h9D
const DIK_MUTE = &hA0
const DIK_CALCULATOR = &hA1
const DIK_PLAYPAUSE = &hA2
const DIK_MEDIASTOP = &hA4
const DIK_VOLUMEDOWN = &hAE
const DIK_VOLUMEUP = &hB0
const DIK_WEBHOME = &hB2
const DIK_NUMPADCOMMA = &hB3
const DIK_DIVIDE = &hB5
const DIK_SYSRQ = &hB7
const DIK_RMENU = &hB8
const DIK_PAUSE = &hC5
const DIK_HOME = &hC7
const DIK_UP = &hC8
const DIK_PRIOR = &hC9
const DIK_LEFT = &hCB
const DIK_RIGHT = &hCD
const DIK_END = &hCF
const DIK_DOWN = &hD0
const DIK_NEXT = &hD1
const DIK_INSERT = &hD2
const DIK_DELETE = &hD3
const DIK_LWIN = &hDB
const DIK_RWIN = &hDC
const DIK_APPS = &hDD
const DIK_POWER = &hDE
const DIK_SLEEP = &hDF
const DIK_WAKE = &hE3
const DIK_WEBSEARCH = &hE5
const DIK_WEBFAVORITES = &hE6
const DIK_WEBREFRESH = &hE7
const DIK_WEBSTOP = &hE8
const DIK_WEBFORWARD = &hE9
const DIK_WEBBACK = &hEA
const DIK_MYCOMPUTER = &hEB
const DIK_MAIL = &hEC
const DIK_MEDIASELECT = &hED
const DIK_BACKSPACE = DIK_BACK
const DIK_NUMPADSTAR = DIK_MULTIPLY
const DIK_LALT = DIK_LMENU
const DIK_CAPSLOCK = DIK_CAPITAL
const DIK_NUMPADMINUS = DIK_SUBTRACT
const DIK_NUMPADPLUS = DIK_ADD
const DIK_NUMPADPERIOD = DIK_DECIMAL
const DIK_NUMPADSLASH = DIK_DIVIDE
const DIK_RALT = DIK_RMENU
const DIK_UPARROW = DIK_UP
const DIK_PGUP = DIK_PRIOR
const DIK_LEFTARROW = DIK_LEFT
const DIK_RIGHTARROW = DIK_RIGHT
const DIK_DOWNARROW = DIK_DOWN
const DIK_PGDN = DIK_NEXT
const DIDFT_ALL = &h00000000
const DIDFT_RELAXIS = &h00000001
const DIDFT_ABSAXIS = &h00000002
const DIDFT_AXIS = &h00000003
const DIDFT_PSHBUTTON = &h00000004
const DIDFT_TGLBUTTON = &h00000008
const DIDFT_BUTTON = &h0000000C
const DIDFT_POV = &h00000010
const DIDFT_COLLECTION = &h00000040
const DIDFT_NODATA = &h00000080
const DIDFT_ANYINSTANCE = &h00FFFF00
const DIDFT_INSTANCEMASK = DIDFT_ANYINSTANCE
#define DIDFT_MAKEINSTANCE(n) (cast(WORD, (n)) shl 8)
#define DIDFT_GETTYPE(n) LOBYTE(n)
#define DIDFT_GETINSTANCE(n) LOWORD((n) shr 8)
const DIDFT_FFACTUATOR = &h01000000
const DIDFT_FFEFFECTTRIGGER = &h02000000
const DIDFT_OUTPUT = &h10000000
const DIDFT_VENDORDEFINED = &h04000000
const DIDFT_ALIAS = &h08000000
const DIDFT_OPTIONAL = &h80000000
#define DIDFT_ENUMCOLLECTION(n) (cast(WORD, (n)) shl 8)
const DIDFT_NOCOLLECTION = &h00FFFF00
const DIDF_ABSAXIS = &h00000001
const DIDF_RELAXIS = &h00000002
const DIGDD_PEEK = &h00000001
#define DISEQUENCE_COMPARE(dwSq1, cmp, dwSq2) (clng((dwSq1) - (dwSq2)) cmp 0)

type DIDEVICEOBJECTDATA_DX3
	dwOfs as DWORD
	dwData as DWORD
	dwTimeStamp as DWORD
	dwSequence as DWORD
end type

type LPDIDEVICEOBJECTDATA_DX3 as DIDEVICEOBJECTDATA_DX3 ptr
type LPCDIDEVICEOBJECTDATA_DX3 as const DIDEVICEOBJECTDATA_DX3 ptr

type DIDEVICEOBJECTDATA
	dwOfs as DWORD
	dwData as DWORD
	dwTimeStamp as DWORD
	dwSequence as DWORD
	uAppData as UINT_PTR
end type

type LPDIDEVICEOBJECTDATA as DIDEVICEOBJECTDATA ptr
type LPCDIDEVICEOBJECTDATA as const DIDEVICEOBJECTDATA ptr

type _DIOBJECTDATAFORMAT
	pguid as const GUID ptr
	dwOfs as DWORD
	dwType as DWORD
	dwFlags as DWORD
end type

type DIOBJECTDATAFORMAT as _DIOBJECTDATAFORMAT
type LPDIOBJECTDATAFORMAT as _DIOBJECTDATAFORMAT ptr
type LPCDIOBJECTDATAFORMAT as const DIOBJECTDATAFORMAT ptr

type _DIDATAFORMAT
	dwSize as DWORD
	dwObjSize as DWORD
	dwFlags as DWORD
	dwDataSize as DWORD
	dwNumObjs as DWORD
	rgodf as LPDIOBJECTDATAFORMAT
end type

type DIDATAFORMAT as _DIDATAFORMAT
type LPDIDATAFORMAT as _DIDATAFORMAT ptr
type LPCDIDATAFORMAT as const DIDATAFORMAT ptr

const DIDOI_FFACTUATOR = &h00000001
const DIDOI_FFEFFECTTRIGGER = &h00000002
const DIDOI_POLLED = &h00008000
const DIDOI_ASPECTPOSITION = &h00000100
const DIDOI_ASPECTVELOCITY = &h00000200
const DIDOI_ASPECTACCEL = &h00000300
const DIDOI_ASPECTFORCE = &h00000400
const DIDOI_ASPECTMASK = &h00000F00
const DIDOI_GUIDISUSAGE = &h00010000

type DIPROPHEADER
	dwSize as DWORD
	dwHeaderSize as DWORD
	dwObj as DWORD
	dwHow as DWORD
end type

type LPDIPROPHEADER as DIPROPHEADER ptr
type LPCDIPROPHEADER as const DIPROPHEADER ptr
const DIPH_DEVICE = 0
const DIPH_BYOFFSET = 1
const DIPH_BYID = 2
const DIPH_BYUSAGE = 3
#define DIMAKEUSAGEDWORD(UsagePage, Usage) cast(DWORD, MAKELONG(Usage, UsagePage))

type DIPROPDWORD
	diph as DIPROPHEADER
	dwData as DWORD
end type

type LPDIPROPDWORD as DIPROPDWORD ptr
type LPCDIPROPDWORD as const DIPROPDWORD ptr

type DIPROPRANGE
	diph as DIPROPHEADER
	lMin as LONG
	lMax as LONG
end type

type LPDIPROPRANGE as DIPROPRANGE ptr
type LPCDIPROPRANGE as const DIPROPRANGE ptr
#define DIPROPRANGE_NOMIN cast(LONG, &h80000000)
#define DIPROPRANGE_NOMAX cast(LONG, &h7FFFFFFF)

type DIPROPCAL
	diph as DIPROPHEADER
	lMin as LONG
	lCenter as LONG
	lMax as LONG
end type

type LPDIPROPCAL as DIPROPCAL ptr
type LPCDIPROPCAL as const DIPROPCAL ptr

type DIPROPCALPOV
	diph as DIPROPHEADER
	lMin(0 to 4) as LONG
	lMax(0 to 4) as LONG
end type

type LPDIPROPCALPOV as DIPROPCALPOV ptr
type LPCDIPROPCALPOV as const DIPROPCALPOV ptr

type DIPROPGUIDANDPATH
	diph as DIPROPHEADER
	guidClass as GUID
	wszPath as wstring * 260
end type

type LPDIPROPGUIDANDPATH as DIPROPGUIDANDPATH ptr
type LPCDIPROPGUIDANDPATH as const DIPROPGUIDANDPATH ptr

type DIPROPSTRING
	diph as DIPROPHEADER
	wsz as wstring * 260
end type

type LPDIPROPSTRING as DIPROPSTRING ptr
type LPCDIPROPSTRING as const DIPROPSTRING ptr

type DIPROPPOINTER
	diph as DIPROPHEADER
	uData as UINT_PTR
end type

type LPDIPROPPOINTER as DIPROPPOINTER ptr
type LPCDIPROPPOINTER as const DIPROPPOINTER ptr
#define MAKEDIPROP(prop) cast(REFGUID, (prop))
#define DIPROP_BUFFERSIZE MAKEDIPROP(1)
#define DIPROP_AXISMODE MAKEDIPROP(2)
const DIPROPAXISMODE_ABS = 0
const DIPROPAXISMODE_REL = 1
#define DIPROP_GRANULARITY MAKEDIPROP(3)
#define DIPROP_RANGE MAKEDIPROP(4)
#define DIPROP_DEADZONE MAKEDIPROP(5)
#define DIPROP_SATURATION MAKEDIPROP(6)
#define DIPROP_FFGAIN MAKEDIPROP(7)
#define DIPROP_FFLOAD MAKEDIPROP(8)
#define DIPROP_AUTOCENTER MAKEDIPROP(9)
const DIPROPAUTOCENTER_OFF = 0
const DIPROPAUTOCENTER_ON = 1
#define DIPROP_CALIBRATIONMODE MAKEDIPROP(10)
const DIPROPCALIBRATIONMODE_COOKED = 0
const DIPROPCALIBRATIONMODE_RAW = 1
#define DIPROP_CALIBRATION MAKEDIPROP(11)
#define DIPROP_GUIDANDPATH MAKEDIPROP(12)
#define DIPROP_INSTANCENAME MAKEDIPROP(13)
#define DIPROP_PRODUCTNAME MAKEDIPROP(14)
#define DIPROP_JOYSTICKID MAKEDIPROP(15)
#define DIPROP_GETPORTDISPLAYNAME MAKEDIPROP(16)
#define DIPROP_PHYSICALRANGE MAKEDIPROP(18)
#define DIPROP_LOGICALRANGE MAKEDIPROP(19)
#define DIPROP_KEYNAME MAKEDIPROP(20)
#define DIPROP_CPOINTS MAKEDIPROP(21)
#define DIPROP_APPDATA MAKEDIPROP(22)
#define DIPROP_SCANCODE MAKEDIPROP(23)
#define DIPROP_VIDPID MAKEDIPROP(24)
#define DIPROP_USERNAME MAKEDIPROP(25)
#define DIPROP_TYPENAME MAKEDIPROP(26)
const MAXCPOINTSNUM = 8

type _CPOINT
	lP as LONG
	dwLog as DWORD
end type

type CPOINT as _CPOINT
type PCPOINT as _CPOINT ptr

type DIPROPCPOINTS
	diph as DIPROPHEADER
	dwCPointsNum as DWORD
	cp(0 to 7) as CPOINT
end type

type LPDIPROPCPOINTS as DIPROPCPOINTS ptr
type LPCDIPROPCPOINTS as const DIPROPCPOINTS ptr

type DIDEVCAPS_DX3
	dwSize as DWORD
	dwFlags as DWORD
	dwDevType as DWORD
	dwAxes as DWORD
	dwButtons as DWORD
	dwPOVs as DWORD
end type

type LPDIDEVCAPS_DX3 as DIDEVCAPS_DX3 ptr

type DIDEVCAPS
	dwSize as DWORD
	dwFlags as DWORD
	dwDevType as DWORD
	dwAxes as DWORD
	dwButtons as DWORD
	dwPOVs as DWORD
	dwFFSamplePeriod as DWORD
	dwFFMinTimeResolution as DWORD
	dwFirmwareRevision as DWORD
	dwHardwareRevision as DWORD
	dwFFDriverVersion as DWORD
end type

type LPDIDEVCAPS as DIDEVCAPS ptr
const DIDC_ATTACHED = &h00000001
const DIDC_POLLEDDEVICE = &h00000002
const DIDC_EMULATED = &h00000004
const DIDC_POLLEDDATAFORMAT = &h00000008
const DIDC_FORCEFEEDBACK = &h00000100
const DIDC_FFATTACK = &h00000200
const DIDC_FFFADE = &h00000400
const DIDC_SATURATION = &h00000800
const DIDC_POSNEGCOEFFICIENTS = &h00001000
const DIDC_POSNEGSATURATION = &h00002000
const DIDC_DEADBAND = &h00004000
const DIDC_STARTDELAY = &h00008000
const DIDC_ALIAS = &h00010000
const DIDC_PHANTOM = &h00020000
const DIDC_HIDDEN = &h00040000
const DISCL_EXCLUSIVE = &h00000001
const DISCL_NONEXCLUSIVE = &h00000002
const DISCL_FOREGROUND = &h00000004
const DISCL_BACKGROUND = &h00000008
const DISCL_NOWINKEY = &h00000010
const DISFFC_RESET = &h00000001
const DISFFC_STOPALL = &h00000002
const DISFFC_PAUSE = &h00000004
const DISFFC_CONTINUE = &h00000008
const DISFFC_SETACTUATORSON = &h00000010
const DISFFC_SETACTUATORSOFF = &h00000020
const DIGFFS_EMPTY = &h00000001
const DIGFFS_STOPPED = &h00000002
const DIGFFS_PAUSED = &h00000004
const DIGFFS_ACTUATORSON = &h00000010
const DIGFFS_ACTUATORSOFF = &h00000020
const DIGFFS_POWERON = &h00000040
const DIGFFS_POWEROFF = &h00000080
const DIGFFS_SAFETYSWITCHON = &h00000100
const DIGFFS_SAFETYSWITCHOFF = &h00000200
const DIGFFS_USERFFSWITCHON = &h00000400
const DIGFFS_USERFFSWITCHOFF = &h00000800
const DIGFFS_DEVICELOST = &h80000000
const DIEFT_ALL = &h00000000
const DIEFT_CONSTANTFORCE = &h00000001
const DIEFT_RAMPFORCE = &h00000002
const DIEFT_PERIODIC = &h00000003
const DIEFT_CONDITION = &h00000004
const DIEFT_CUSTOMFORCE = &h00000005
const DIEFT_HARDWARE = &h000000FF
const DIEFT_FFATTACK = &h00000200
const DIEFT_FFFADE = &h00000400
const DIEFT_SATURATION = &h00000800
const DIEFT_POSNEGCOEFFICIENTS = &h00001000
const DIEFT_POSNEGSATURATION = &h00002000
const DIEFT_DEADBAND = &h00004000
const DIEFT_STARTDELAY = &h00008000
#define DIEFT_GETTYPE(n) LOBYTE(n)
const DIEFF_OBJECTIDS = &h00000001
const DIEFF_OBJECTOFFSETS = &h00000002
const DIEFF_CARTESIAN = &h00000010
const DIEFF_POLAR = &h00000020
const DIEFF_SPHERICAL = &h00000040
const DIEP_DURATION = &h00000001
const DIEP_SAMPLEPERIOD = &h00000002
const DIEP_GAIN = &h00000004
const DIEP_TRIGGERBUTTON = &h00000008
const DIEP_TRIGGERREPEATINTERVAL = &h00000010
const DIEP_AXES = &h00000020
const DIEP_DIRECTION = &h00000040
const DIEP_ENVELOPE = &h00000080
const DIEP_TYPESPECIFICPARAMS = &h00000100
const DIEP_STARTDELAY = &h00000200
const DIEP_ALLPARAMS_DX5 = &h000001FF
const DIEP_ALLPARAMS = &h000003FF
const DIEP_START = &h20000000
const DIEP_NORESTART = &h40000000
const DIEP_NODOWNLOAD = &h80000000
const DIEB_NOTRIGGER = &hFFFFFFFF
const DIES_SOLO = &h00000001
const DIES_NODOWNLOAD = &h80000000
const DIEGES_PLAYING = &h00000001
const DIEGES_EMULATED = &h00000002
const DI_DEGREES = 100
const DI_FFNOMINALMAX = 10000
const DI_SECONDS = 1000000

type DICONSTANTFORCE
	lMagnitude as LONG
end type

type LPDICONSTANTFORCE as DICONSTANTFORCE ptr
type LPCDICONSTANTFORCE as const DICONSTANTFORCE ptr

type DIRAMPFORCE
	lStart as LONG
	lEnd as LONG
end type

type LPDIRAMPFORCE as DIRAMPFORCE ptr
type LPCDIRAMPFORCE as const DIRAMPFORCE ptr

type DIPERIODIC
	dwMagnitude as DWORD
	lOffset as LONG
	dwPhase as DWORD
	dwPeriod as DWORD
end type

type LPDIPERIODIC as DIPERIODIC ptr
type LPCDIPERIODIC as const DIPERIODIC ptr

type DICONDITION
	lOffset as LONG
	lPositiveCoefficient as LONG
	lNegativeCoefficient as LONG
	dwPositiveSaturation as DWORD
	dwNegativeSaturation as DWORD
	lDeadBand as LONG
end type

type LPDICONDITION as DICONDITION ptr
type LPCDICONDITION as const DICONDITION ptr

type DICUSTOMFORCE
	cChannels as DWORD
	dwSamplePeriod as DWORD
	cSamples as DWORD
	rglForceData as LPLONG
end type

type LPDICUSTOMFORCE as DICUSTOMFORCE ptr
type LPCDICUSTOMFORCE as const DICUSTOMFORCE ptr

type DIENVELOPE
	dwSize as DWORD
	dwAttackLevel as DWORD
	dwAttackTime as DWORD
	dwFadeLevel as DWORD
	dwFadeTime as DWORD
end type

type LPDIENVELOPE as DIENVELOPE ptr
type LPCDIENVELOPE as const DIENVELOPE ptr

type DIEFFECT_DX5
	dwSize as DWORD
	dwFlags as DWORD
	dwDuration as DWORD
	dwSamplePeriod as DWORD
	dwGain as DWORD
	dwTriggerButton as DWORD
	dwTriggerRepeatInterval as DWORD
	cAxes as DWORD
	rgdwAxes as LPDWORD
	rglDirection as LPLONG
	lpEnvelope as LPDIENVELOPE
	cbTypeSpecificParams as DWORD
	lpvTypeSpecificParams as LPVOID
end type

type LPDIEFFECT_DX5 as DIEFFECT_DX5 ptr
type LPCDIEFFECT_DX5 as const DIEFFECT_DX5 ptr

type DIEFFECT
	dwSize as DWORD
	dwFlags as DWORD
	dwDuration as DWORD
	dwSamplePeriod as DWORD
	dwGain as DWORD
	dwTriggerButton as DWORD
	dwTriggerRepeatInterval as DWORD
	cAxes as DWORD
	rgdwAxes as LPDWORD
	rglDirection as LPLONG
	lpEnvelope as LPDIENVELOPE
	cbTypeSpecificParams as DWORD
	lpvTypeSpecificParams as LPVOID
	dwStartDelay as DWORD
end type

type LPDIEFFECT as DIEFFECT ptr
type LPCDIEFFECT as const DIEFFECT ptr
type DIEFFECT_DX6 as DIEFFECT
type LPDIEFFECT_DX6 as LPDIEFFECT

type DIEFFECTINFOA
	dwSize as DWORD
	guid as GUID
	dwEffType as DWORD
	dwStaticParams as DWORD
	dwDynamicParams as DWORD
	tszName as zstring * 260
end type

type LPDIEFFECTINFOA as DIEFFECTINFOA ptr
type LPCDIEFFECTINFOA as const DIEFFECTINFOA ptr

type DIEFFECTINFOW
	dwSize as DWORD
	guid as GUID
	dwEffType as DWORD
	dwStaticParams as DWORD
	dwDynamicParams as DWORD
	tszName as wstring * 260
end type

type LPDIEFFECTINFOW as DIEFFECTINFOW ptr
type LPCDIEFFECTINFOW as const DIEFFECTINFOW ptr

#ifdef UNICODE
	type DIEFFECTINFO as DIEFFECTINFOW
	type LPDIEFFECTINFO as LPDIEFFECTINFOW
	type LPCDIEFFECTINFO as LPCDIEFFECTINFOW
#else
	type DIEFFECTINFO as DIEFFECTINFOA
	type LPDIEFFECTINFO as LPDIEFFECTINFOA
	type LPCDIEFFECTINFO as LPCDIEFFECTINFOA
#endif

type LPDIENUMEFFECTSCALLBACKA as function(byval as LPCDIEFFECTINFOA, byval as LPVOID) as BOOL
type LPDIENUMEFFECTSCALLBACKW as function(byval as LPCDIEFFECTINFOW, byval as LPVOID) as BOOL

type DIEFFESCAPE
	dwSize as DWORD
	dwCommand as DWORD
	lpvInBuffer as LPVOID
	cbInBuffer as DWORD
	lpvOutBuffer as LPVOID
	cbOutBuffer as DWORD
end type

type LPDIEFFESCAPE as DIEFFESCAPE ptr

type DIJOYSTATE
	lX as LONG
	lY as LONG
	lZ as LONG
	lRx as LONG
	lRy as LONG
	lRz as LONG
	rglSlider(0 to 1) as LONG
	rgdwPOV(0 to 3) as DWORD
	rgbButtons(0 to 31) as UBYTE
end type

type LPDIJOYSTATE as DIJOYSTATE ptr

type DIJOYSTATE2
	lX as LONG
	lY as LONG
	lZ as LONG
	lRx as LONG
	lRy as LONG
	lRz as LONG
	rglSlider(0 to 1) as LONG
	rgdwPOV(0 to 3) as DWORD
	rgbButtons(0 to 127) as UBYTE
	lVX as LONG
	lVY as LONG
	lVZ as LONG
	lVRx as LONG
	lVRy as LONG
	lVRz as LONG
	rglVSlider(0 to 1) as LONG
	lAX as LONG
	lAY as LONG
	lAZ as LONG
	lARx as LONG
	lARy as LONG
	lARz as LONG
	rglASlider(0 to 1) as LONG
	lFX as LONG
	lFY as LONG
	lFZ as LONG
	lFRx as LONG
	lFRy as LONG
	lFRz as LONG
	rglFSlider(0 to 1) as LONG
end type

type LPDIJOYSTATE2 as DIJOYSTATE2 ptr
#define DIJOFS_X FIELD_OFFSET(DIJOYSTATE, lX)
#define DIJOFS_Y FIELD_OFFSET(DIJOYSTATE, lY)
#define DIJOFS_Z FIELD_OFFSET(DIJOYSTATE, lZ)
#define DIJOFS_RX FIELD_OFFSET(DIJOYSTATE, lRx)
#define DIJOFS_RY FIELD_OFFSET(DIJOYSTATE, lRy)
#define DIJOFS_RZ FIELD_OFFSET(DIJOYSTATE, lRz)
#define DIJOFS_SLIDER(n) (FIELD_OFFSET(DIJOYSTATE, rglSlider) + ((n) * sizeof(LONG)))
#define DIJOFS_POV(n) (FIELD_OFFSET(DIJOYSTATE, rgdwPOV) + ((n) * sizeof(DWORD)))
#define DIJOFS_BUTTON(n) (FIELD_OFFSET(DIJOYSTATE, rgbButtons) + (n))
#define DIJOFS_BUTTON0 DIJOFS_BUTTON(0)
#define DIJOFS_BUTTON1 DIJOFS_BUTTON(1)
#define DIJOFS_BUTTON2 DIJOFS_BUTTON(2)
#define DIJOFS_BUTTON3 DIJOFS_BUTTON(3)
#define DIJOFS_BUTTON4 DIJOFS_BUTTON(4)
#define DIJOFS_BUTTON5 DIJOFS_BUTTON(5)
#define DIJOFS_BUTTON6 DIJOFS_BUTTON(6)
#define DIJOFS_BUTTON7 DIJOFS_BUTTON(7)
#define DIJOFS_BUTTON8 DIJOFS_BUTTON(8)
#define DIJOFS_BUTTON9 DIJOFS_BUTTON(9)
#define DIJOFS_BUTTON10 DIJOFS_BUTTON(10)
#define DIJOFS_BUTTON11 DIJOFS_BUTTON(11)
#define DIJOFS_BUTTON12 DIJOFS_BUTTON(12)
#define DIJOFS_BUTTON13 DIJOFS_BUTTON(13)
#define DIJOFS_BUTTON14 DIJOFS_BUTTON(14)
#define DIJOFS_BUTTON15 DIJOFS_BUTTON(15)
#define DIJOFS_BUTTON16 DIJOFS_BUTTON(16)
#define DIJOFS_BUTTON17 DIJOFS_BUTTON(17)
#define DIJOFS_BUTTON18 DIJOFS_BUTTON(18)
#define DIJOFS_BUTTON19 DIJOFS_BUTTON(19)
#define DIJOFS_BUTTON20 DIJOFS_BUTTON(20)
#define DIJOFS_BUTTON21 DIJOFS_BUTTON(21)
#define DIJOFS_BUTTON22 DIJOFS_BUTTON(22)
#define DIJOFS_BUTTON23 DIJOFS_BUTTON(23)
#define DIJOFS_BUTTON24 DIJOFS_BUTTON(24)
#define DIJOFS_BUTTON25 DIJOFS_BUTTON(25)
#define DIJOFS_BUTTON26 DIJOFS_BUTTON(26)
#define DIJOFS_BUTTON27 DIJOFS_BUTTON(27)
#define DIJOFS_BUTTON28 DIJOFS_BUTTON(28)
#define DIJOFS_BUTTON29 DIJOFS_BUTTON(29)
#define DIJOFS_BUTTON30 DIJOFS_BUTTON(30)
#define DIJOFS_BUTTON31 DIJOFS_BUTTON(31)

type DIFILEEFFECT
	dwSize as DWORD
	GuidEffect as GUID
	lpDiEffect as LPCDIEFFECT
	szFriendlyName as zstring * 260
end type

type LPDIFILEEFFECT as DIFILEEFFECT ptr
type LPCDIFILEEFFECT as const DIFILEEFFECT ptr
type LPDIENUMEFFECTSINFILECALLBACK as function(byval as LPCDIFILEEFFECT, byval as LPVOID) as BOOL

type _DIACTIONA
	uAppData as UINT_PTR
	dwSemantic as DWORD
	dwFlags as DWORD

	union
		lptszActionName as LPCSTR
		uResIdString as UINT
	end union

	guidInstance as GUID
	dwObjID as DWORD
	dwHow as DWORD
end type

type DIACTIONA as _DIACTIONA
type LPDIACTIONA as _DIACTIONA ptr
type LPCDIACTIONA as const DIACTIONA ptr

type _DIACTIONW
	uAppData as UINT_PTR
	dwSemantic as DWORD
	dwFlags as DWORD

	union
		lptszActionName as LPCWSTR
		uResIdString as UINT
	end union

	guidInstance as GUID
	dwObjID as DWORD
	dwHow as DWORD
end type

type DIACTIONW as _DIACTIONW
type LPDIACTIONW as _DIACTIONW ptr
type LPCDIACTIONW as const DIACTIONW ptr

#ifdef UNICODE
	type DIACTION as DIACTIONW
	type LPDIACTION as LPDIACTIONW
	type LPCDIACTION as LPCDIACTIONW
#else
	type DIACTION as DIACTIONA
	type LPDIACTION as LPDIACTIONA
	type LPCDIACTION as LPCDIACTIONA
#endif

const DIA_FORCEFEEDBACK = &h00000001
const DIA_APPMAPPED = &h00000002
const DIA_APPNOMAP = &h00000004
const DIA_NORANGE = &h00000008
const DIA_APPFIXED = &h00000010
const DIAH_UNMAPPED = &h00000000
const DIAH_USERCONFIG = &h00000001
const DIAH_APPREQUESTED = &h00000002
const DIAH_HWAPP = &h00000004
const DIAH_HWDEFAULT = &h00000008
const DIAH_DEFAULT = &h00000020
const DIAH_ERROR = &h80000000

type _DIACTIONFORMATA
	dwSize as DWORD
	dwActionSize as DWORD
	dwDataSize as DWORD
	dwNumActions as DWORD
	rgoAction as LPDIACTIONA
	guidActionMap as GUID
	dwGenre as DWORD
	dwBufferSize as DWORD
	lAxisMin as LONG
	lAxisMax as LONG
	hInstString as HINSTANCE
	ftTimeStamp as FILETIME
	dwCRC as DWORD
	tszActionMap as zstring * 260
end type

type DIACTIONFORMATA as _DIACTIONFORMATA
type LPDIACTIONFORMATA as _DIACTIONFORMATA ptr
type LPCDIACTIONFORMATA as const DIACTIONFORMATA ptr

type _DIACTIONFORMATW
	dwSize as DWORD
	dwActionSize as DWORD
	dwDataSize as DWORD
	dwNumActions as DWORD
	rgoAction as LPDIACTIONW
	guidActionMap as GUID
	dwGenre as DWORD
	dwBufferSize as DWORD
	lAxisMin as LONG
	lAxisMax as LONG
	hInstString as HINSTANCE
	ftTimeStamp as FILETIME
	dwCRC as DWORD
	tszActionMap as wstring * 260
end type

type DIACTIONFORMATW as _DIACTIONFORMATW
type LPDIACTIONFORMATW as _DIACTIONFORMATW ptr
type LPCDIACTIONFORMATW as const DIACTIONFORMATW ptr

#ifdef UNICODE
	type DIACTIONFORMAT as DIACTIONFORMATW
	type LPDIACTIONFORMAT as LPDIACTIONFORMATW
	type LPCDIACTIONFORMAT as LPCDIACTIONFORMATW
#else
	type DIACTIONFORMAT as DIACTIONFORMATA
	type LPDIACTIONFORMAT as LPDIACTIONFORMATA
	type LPCDIACTIONFORMAT as LPCDIACTIONFORMATA
#endif

const DIAFTS_NEWDEVICELOW = &hFFFFFFFF
const DIAFTS_NEWDEVICEHIGH = &hFFFFFFFF
const DIAFTS_UNUSEDDEVICELOW = &h00000000
const DIAFTS_UNUSEDDEVICEHIGH = &h00000000
const DIDBAM_DEFAULT = &h00000000
const DIDBAM_PRESERVE = &h00000001
const DIDBAM_INITIALIZE = &h00000002
const DIDBAM_HWDEFAULTS = &h00000004
const DIDSAM_DEFAULT = &h00000000
const DIDSAM_NOUSER = &h00000001
const DIDSAM_FORCESAVE = &h00000002
const DICD_DEFAULT = &h00000000
const DICD_EDIT = &h00000001

type _DICOLORSET
	dwSize as DWORD
	cTextFore as D3DCOLOR
	cTextHighlight as D3DCOLOR
	cCalloutLine as D3DCOLOR
	cCalloutHighlight as D3DCOLOR
	cBorder as D3DCOLOR
	cControlFill as D3DCOLOR
	cHighlightFill as D3DCOLOR
	cAreaFill as D3DCOLOR
end type

type DICOLORSET as _DICOLORSET
type LPDICOLORSET as _DICOLORSET ptr
type LPCDICOLORSET as const DICOLORSET ptr

type _DICONFIGUREDEVICESPARAMSA
	dwSize as DWORD
	dwcUsers as DWORD
	lptszUserNames as LPSTR
	dwcFormats as DWORD
	lprgFormats as LPDIACTIONFORMATA
	hwnd as HWND
	dics as DICOLORSET
	lpUnkDDSTarget as LPUNKNOWN
end type

type DICONFIGUREDEVICESPARAMSA as _DICONFIGUREDEVICESPARAMSA
type LPDICONFIGUREDEVICESPARAMSA as _DICONFIGUREDEVICESPARAMSA ptr
type LPCDICONFIGUREDEVICESPARAMSA as const DICONFIGUREDEVICESPARAMSA ptr

type _DICONFIGUREDEVICESPARAMSW
	dwSize as DWORD
	dwcUsers as DWORD
	lptszUserNames as LPWSTR
	dwcFormats as DWORD
	lprgFormats as LPDIACTIONFORMATW
	hwnd as HWND
	dics as DICOLORSET
	lpUnkDDSTarget as LPUNKNOWN
end type

type DICONFIGUREDEVICESPARAMSW as _DICONFIGUREDEVICESPARAMSW
type LPDICONFIGUREDEVICESPARAMSW as _DICONFIGUREDEVICESPARAMSW ptr
type LPCDICONFIGUREDEVICESPARAMSW as const DICONFIGUREDEVICESPARAMSW ptr

#ifdef UNICODE
	type DICONFIGUREDEVICESPARAMS as DICONFIGUREDEVICESPARAMSW
	type LPDICONFIGUREDEVICESPARAMS as LPDICONFIGUREDEVICESPARAMSW
	type LPCDICONFIGUREDEVICESPARAMS as LPCDICONFIGUREDEVICESPARAMSW
#else
	type DICONFIGUREDEVICESPARAMS as DICONFIGUREDEVICESPARAMSA
	type LPDICONFIGUREDEVICESPARAMS as LPDICONFIGUREDEVICESPARAMSA
	type LPCDICONFIGUREDEVICESPARAMS as LPCDICONFIGUREDEVICESPARAMSA
#endif

const DIDIFT_CONFIGURATION = &h00000001
const DIDIFT_OVERLAY = &h00000002
const DIDAL_CENTERED = &h00000000
const DIDAL_LEFTALIGNED = &h00000001
const DIDAL_RIGHTALIGNED = &h00000002
const DIDAL_MIDDLE = &h00000000
const DIDAL_TOPALIGNED = &h00000004
const DIDAL_BOTTOMALIGNED = &h00000008

type _DIDEVICEIMAGEINFOA
	tszImagePath as zstring * 260
	dwFlags as DWORD
	dwViewID as DWORD
	rcOverlay as RECT
	dwObjID as DWORD
	dwcValidPts as DWORD
	rgptCalloutLine(0 to 4) as POINT
	rcCalloutRect as RECT
	dwTextAlign as DWORD
end type

type DIDEVICEIMAGEINFOA as _DIDEVICEIMAGEINFOA
type LPDIDEVICEIMAGEINFOA as _DIDEVICEIMAGEINFOA ptr
type LPCDIDEVICEIMAGEINFOA as const DIDEVICEIMAGEINFOA ptr

type _DIDEVICEIMAGEINFOW
	tszImagePath as wstring * 260
	dwFlags as DWORD
	dwViewID as DWORD
	rcOverlay as RECT
	dwObjID as DWORD
	dwcValidPts as DWORD
	rgptCalloutLine(0 to 4) as POINT
	rcCalloutRect as RECT
	dwTextAlign as DWORD
end type

type DIDEVICEIMAGEINFOW as _DIDEVICEIMAGEINFOW
type LPDIDEVICEIMAGEINFOW as _DIDEVICEIMAGEINFOW ptr
type LPCDIDEVICEIMAGEINFOW as const DIDEVICEIMAGEINFOW ptr

#ifdef UNICODE
	type DIDEVICEIMAGEINFO as DIDEVICEIMAGEINFOW
	type LPDIDEVICEIMAGEINFO as LPDIDEVICEIMAGEINFOW
	type LPCDIDEVICEIMAGEINFO as LPCDIDEVICEIMAGEINFOW
#else
	type DIDEVICEIMAGEINFO as DIDEVICEIMAGEINFOA
	type LPDIDEVICEIMAGEINFO as LPDIDEVICEIMAGEINFOA
	type LPCDIDEVICEIMAGEINFO as LPCDIDEVICEIMAGEINFOA
#endif

type _DIDEVICEIMAGEINFOHEADERA
	dwSize as DWORD
	dwSizeImageInfo as DWORD
	dwcViews as DWORD
	dwcButtons as DWORD
	dwcAxes as DWORD
	dwcPOVs as DWORD
	dwBufferSize as DWORD
	dwBufferUsed as DWORD
	lprgImageInfoArray as LPDIDEVICEIMAGEINFOA
end type

type DIDEVICEIMAGEINFOHEADERA as _DIDEVICEIMAGEINFOHEADERA
type LPDIDEVICEIMAGEINFOHEADERA as _DIDEVICEIMAGEINFOHEADERA ptr
type LPCDIDEVICEIMAGEINFOHEADERA as const DIDEVICEIMAGEINFOHEADERA ptr

type _DIDEVICEIMAGEINFOHEADERW
	dwSize as DWORD
	dwSizeImageInfo as DWORD
	dwcViews as DWORD
	dwcButtons as DWORD
	dwcAxes as DWORD
	dwcPOVs as DWORD
	dwBufferSize as DWORD
	dwBufferUsed as DWORD
	lprgImageInfoArray as LPDIDEVICEIMAGEINFOW
end type

type DIDEVICEIMAGEINFOHEADERW as _DIDEVICEIMAGEINFOHEADERW
type LPDIDEVICEIMAGEINFOHEADERW as _DIDEVICEIMAGEINFOHEADERW ptr
type LPCDIDEVICEIMAGEINFOHEADERW as const DIDEVICEIMAGEINFOHEADERW ptr

#ifdef UNICODE
	type DIDEVICEIMAGEINFOHEADER as DIDEVICEIMAGEINFOHEADERW
	type LPDIDEVICEIMAGEINFOHEADER as LPDIDEVICEIMAGEINFOHEADERW
	type LPCDIDEVICEIMAGEINFOHEADER as LPCDIDEVICEIMAGEINFOHEADERW
#else
	type DIDEVICEIMAGEINFOHEADER as DIDEVICEIMAGEINFOHEADERA
	type LPDIDEVICEIMAGEINFOHEADER as LPDIDEVICEIMAGEINFOHEADERA
	type LPCDIDEVICEIMAGEINFOHEADER as LPCDIDEVICEIMAGEINFOHEADERA
#endif

type IDirectInputEffectVtbl as IDirectInputEffectVtbl_

type IDirectInputEffect
	lpVtbl as IDirectInputEffectVtbl ptr
end type

type IDirectInputEffectVtbl_
	QueryInterface as function(byval This as IDirectInputEffect ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputEffect ptr) as ULONG
	Release as function(byval This as IDirectInputEffect ptr) as ULONG
	Initialize as function(byval This as IDirectInputEffect ptr, byval as HINSTANCE, byval as DWORD, byval as const GUID const ptr) as HRESULT
	GetEffectGuid as function(byval This as IDirectInputEffect ptr, byval as LPGUID) as HRESULT
	GetParameters as function(byval This as IDirectInputEffect ptr, byval as LPDIEFFECT, byval as DWORD) as HRESULT
	SetParameters as function(byval This as IDirectInputEffect ptr, byval as LPCDIEFFECT, byval as DWORD) as HRESULT
	Start as function(byval This as IDirectInputEffect ptr, byval as DWORD, byval as DWORD) as HRESULT
	Stop as function(byval This as IDirectInputEffect ptr) as HRESULT
	GetEffectStatus as function(byval This as IDirectInputEffect ptr, byval as LPDWORD) as HRESULT
	Download as function(byval This as IDirectInputEffect ptr) as HRESULT
	Unload as function(byval This as IDirectInputEffect ptr) as HRESULT
	Escape as function(byval This as IDirectInputEffect ptr, byval as LPDIEFFESCAPE) as HRESULT
end type

#define IDirectInputEffect_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInputEffect_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInputEffect_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInputEffect_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
#define IDirectInputEffect_GetEffectGuid(p, a) (p)->lpVtbl->GetEffectGuid(p, a)
#define IDirectInputEffect_GetParameters(p, a, b) (p)->lpVtbl->GetParameters(p, a, b)
#define IDirectInputEffect_SetParameters(p, a, b) (p)->lpVtbl->SetParameters(p, a, b)
#define IDirectInputEffect_Start(p, a, b) (p)->lpVtbl->Start(p, a, b)
#define IDirectInputEffect_Stop(p) (p)->lpVtbl->Stop(p)
#define IDirectInputEffect_GetEffectStatus(p, a) (p)->lpVtbl->GetEffectStatus(p, a)
#define IDirectInputEffect_Download(p) (p)->lpVtbl->Download(p)
#define IDirectInputEffect_Unload(p) (p)->lpVtbl->Unload(p)
#define IDirectInputEffect_Escape(p, a) (p)->lpVtbl->Escape(p, a)
type IDirectInputDeviceAVtbl as IDirectInputDeviceAVtbl_

type IDirectInputDeviceA
	lpVtbl as IDirectInputDeviceAVtbl ptr
end type

type IDirectInputDeviceAVtbl_
	QueryInterface as function(byval This as IDirectInputDeviceA ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDeviceA ptr) as ULONG
	Release as function(byval This as IDirectInputDeviceA ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDeviceA ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDeviceA ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDeviceA ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDeviceA ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDeviceA ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDeviceA ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDeviceA ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDeviceA ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDeviceA ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDeviceA ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDeviceA ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDeviceA ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEA, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDeviceA ptr, byval pdidi as LPDIDEVICEINSTANCEA) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDeviceA ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDeviceA ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
end type

type IDirectInputDeviceWVtbl as IDirectInputDeviceWVtbl_

type IDirectInputDeviceW
	lpVtbl as IDirectInputDeviceWVtbl ptr
end type

type IDirectInputDeviceWVtbl_
	QueryInterface as function(byval This as IDirectInputDeviceW ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDeviceW ptr) as ULONG
	Release as function(byval This as IDirectInputDeviceW ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDeviceW ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDeviceW ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDeviceW ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDeviceW ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDeviceW ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDeviceW ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDeviceW ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDeviceW ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDeviceW ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDeviceW ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDeviceW ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDeviceW ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEW, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDeviceW ptr, byval pdidi as LPDIDEVICEINSTANCEW) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDeviceW ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDeviceW ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
end type

#define IDirectInputDevice_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInputDevice_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInputDevice_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInputDevice_GetCapabilities(p, a) (p)->lpVtbl->GetCapabilities(p, a)
#define IDirectInputDevice_EnumObjects(p, a, b, c) (p)->lpVtbl->EnumObjects(p, a, b, c)
#define IDirectInputDevice_GetProperty(p, a, b) (p)->lpVtbl->GetProperty(p, a, b)
#define IDirectInputDevice_SetProperty(p, a, b) (p)->lpVtbl->SetProperty(p, a, b)
#define IDirectInputDevice_Acquire(p) (p)->lpVtbl->Acquire(p)
#define IDirectInputDevice_Unacquire(p) (p)->lpVtbl->Unacquire(p)
#define IDirectInputDevice_GetDeviceState(p, a, b) (p)->lpVtbl->GetDeviceState(p, a, b)
#define IDirectInputDevice_GetDeviceData(p, a, b, c, d) (p)->lpVtbl->GetDeviceData(p, a, b, c, d)
#define IDirectInputDevice_SetDataFormat(p, a) (p)->lpVtbl->SetDataFormat(p, a)
#define IDirectInputDevice_SetEventNotification(p, a) (p)->lpVtbl->SetEventNotification(p, a)
#define IDirectInputDevice_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectInputDevice_GetObjectInfo(p, a, b, c) (p)->lpVtbl->GetObjectInfo(p, a, b, c)
#define IDirectInputDevice_GetDeviceInfo(p, a) (p)->lpVtbl->GetDeviceInfo(p, a)
#define IDirectInputDevice_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInputDevice_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
type IDirectInputDevice2AVtbl as IDirectInputDevice2AVtbl_

type IDirectInputDevice2A
	lpVtbl as IDirectInputDevice2AVtbl ptr
end type

type IDirectInputDevice2AVtbl_
	QueryInterface as function(byval This as IDirectInputDevice2A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice2A ptr) as ULONG
	Release as function(byval This as IDirectInputDevice2A ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice2A ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice2A ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice2A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice2A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice2A ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice2A ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice2A ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice2A ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice2A ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice2A ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice2A ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice2A ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEA, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice2A ptr, byval pdidi as LPDIDEVICEINSTANCEA) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice2A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice2A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice2A ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice2A ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKA, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice2A ptr, byval pdei as LPDIEFFECTINFOA, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice2A ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice2A ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice2A ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice2A ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice2A ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice2A ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
end type

type IDirectInputDevice2WVtbl as IDirectInputDevice2WVtbl_

type IDirectInputDevice2W
	lpVtbl as IDirectInputDevice2WVtbl ptr
end type

type IDirectInputDevice2WVtbl_
	QueryInterface as function(byval This as IDirectInputDevice2W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice2W ptr) as ULONG
	Release as function(byval This as IDirectInputDevice2W ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice2W ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice2W ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice2W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice2W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice2W ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice2W ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice2W ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice2W ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice2W ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice2W ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice2W ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice2W ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEW, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice2W ptr, byval pdidi as LPDIDEVICEINSTANCEW) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice2W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice2W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice2W ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice2W ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKW, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice2W ptr, byval pdei as LPDIEFFECTINFOW, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice2W ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice2W ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice2W ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice2W ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice2W ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice2W ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
end type

#define IDirectInputDevice2_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInputDevice2_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInputDevice2_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInputDevice2_GetCapabilities(p, a) (p)->lpVtbl->GetCapabilities(p, a)
#define IDirectInputDevice2_EnumObjects(p, a, b, c) (p)->lpVtbl->EnumObjects(p, a, b, c)
#define IDirectInputDevice2_GetProperty(p, a, b) (p)->lpVtbl->GetProperty(p, a, b)
#define IDirectInputDevice2_SetProperty(p, a, b) (p)->lpVtbl->SetProperty(p, a, b)
#define IDirectInputDevice2_Acquire(p) (p)->lpVtbl->Acquire(p)
#define IDirectInputDevice2_Unacquire(p) (p)->lpVtbl->Unacquire(p)
#define IDirectInputDevice2_GetDeviceState(p, a, b) (p)->lpVtbl->GetDeviceState(p, a, b)
#define IDirectInputDevice2_GetDeviceData(p, a, b, c, d) (p)->lpVtbl->GetDeviceData(p, a, b, c, d)
#define IDirectInputDevice2_SetDataFormat(p, a) (p)->lpVtbl->SetDataFormat(p, a)
#define IDirectInputDevice2_SetEventNotification(p, a) (p)->lpVtbl->SetEventNotification(p, a)
#define IDirectInputDevice2_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectInputDevice2_GetObjectInfo(p, a, b, c) (p)->lpVtbl->GetObjectInfo(p, a, b, c)
#define IDirectInputDevice2_GetDeviceInfo(p, a) (p)->lpVtbl->GetDeviceInfo(p, a)
#define IDirectInputDevice2_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInputDevice2_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
#define IDirectInputDevice2_CreateEffect(p, a, b, c, d) (p)->lpVtbl->CreateEffect(p, a, b, c, d)
#define IDirectInputDevice2_EnumEffects(p, a, b, c) (p)->lpVtbl->EnumEffects(p, a, b, c)
#define IDirectInputDevice2_GetEffectInfo(p, a, b) (p)->lpVtbl->GetEffectInfo(p, a, b)
#define IDirectInputDevice2_GetForceFeedbackState(p, a) (p)->lpVtbl->GetForceFeedbackState(p, a)
#define IDirectInputDevice2_SendForceFeedbackCommand(p, a) (p)->lpVtbl->SendForceFeedbackCommand(p, a)
#define IDirectInputDevice2_EnumCreatedEffectObjects(p, a, b, c) (p)->lpVtbl->EnumCreatedEffectObjects(p, a, b, c)
#define IDirectInputDevice2_Escape(p, a) (p)->lpVtbl->Escape(p, a)
#define IDirectInputDevice2_Poll(p) (p)->lpVtbl->Poll(p)
#define IDirectInputDevice2_SendDeviceData(p, a, b, c, d) (p)->lpVtbl->SendDeviceData(p, a, b, c, d)
type IDirectInputDevice7AVtbl as IDirectInputDevice7AVtbl_

type IDirectInputDevice7A
	lpVtbl as IDirectInputDevice7AVtbl ptr
end type

type IDirectInputDevice7AVtbl_
	QueryInterface as function(byval This as IDirectInputDevice7A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice7A ptr) as ULONG
	Release as function(byval This as IDirectInputDevice7A ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice7A ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice7A ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice7A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice7A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice7A ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice7A ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice7A ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice7A ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice7A ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice7A ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice7A ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice7A ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEA, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice7A ptr, byval pdidi as LPDIDEVICEINSTANCEA) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice7A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice7A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice7A ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice7A ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKA, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice7A ptr, byval pdei as LPDIEFFECTINFOA, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice7A ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice7A ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice7A ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice7A ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice7A ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice7A ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
	EnumEffectsInFile as function(byval This as IDirectInputDevice7A ptr, byval lpszFileName as LPCSTR, byval pec as LPDIENUMEFFECTSINFILECALLBACK, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	WriteEffectToFile as function(byval This as IDirectInputDevice7A ptr, byval lpszFileName as LPCSTR, byval dwEntries as DWORD, byval rgDiFileEft as LPDIFILEEFFECT, byval dwFlags as DWORD) as HRESULT
end type

type IDirectInputDevice7WVtbl as IDirectInputDevice7WVtbl_

type IDirectInputDevice7W
	lpVtbl as IDirectInputDevice7WVtbl ptr
end type

type IDirectInputDevice7WVtbl_
	QueryInterface as function(byval This as IDirectInputDevice7W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice7W ptr) as ULONG
	Release as function(byval This as IDirectInputDevice7W ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice7W ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice7W ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice7W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice7W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice7W ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice7W ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice7W ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice7W ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice7W ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice7W ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice7W ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice7W ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEW, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice7W ptr, byval pdidi as LPDIDEVICEINSTANCEW) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice7W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice7W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice7W ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice7W ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKW, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice7W ptr, byval pdei as LPDIEFFECTINFOW, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice7W ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice7W ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice7W ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice7W ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice7W ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice7W ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
	EnumEffectsInFile as function(byval This as IDirectInputDevice7W ptr, byval lpszFileName as LPCWSTR, byval pec as LPDIENUMEFFECTSINFILECALLBACK, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	WriteEffectToFile as function(byval This as IDirectInputDevice7W ptr, byval lpszFileName as LPCWSTR, byval dwEntries as DWORD, byval rgDiFileEft as LPDIFILEEFFECT, byval dwFlags as DWORD) as HRESULT
end type

#define IDirectInputDevice7_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInputDevice7_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInputDevice7_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInputDevice7_GetCapabilities(p, a) (p)->lpVtbl->GetCapabilities(p, a)
#define IDirectInputDevice7_EnumObjects(p, a, b, c) (p)->lpVtbl->EnumObjects(p, a, b, c)
#define IDirectInputDevice7_GetProperty(p, a, b) (p)->lpVtbl->GetProperty(p, a, b)
#define IDirectInputDevice7_SetProperty(p, a, b) (p)->lpVtbl->SetProperty(p, a, b)
#define IDirectInputDevice7_Acquire(p) (p)->lpVtbl->Acquire(p)
#define IDirectInputDevice7_Unacquire(p) (p)->lpVtbl->Unacquire(p)
#define IDirectInputDevice7_GetDeviceState(p, a, b) (p)->lpVtbl->GetDeviceState(p, a, b)
#define IDirectInputDevice7_GetDeviceData(p, a, b, c, d) (p)->lpVtbl->GetDeviceData(p, a, b, c, d)
#define IDirectInputDevice7_SetDataFormat(p, a) (p)->lpVtbl->SetDataFormat(p, a)
#define IDirectInputDevice7_SetEventNotification(p, a) (p)->lpVtbl->SetEventNotification(p, a)
#define IDirectInputDevice7_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectInputDevice7_GetObjectInfo(p, a, b, c) (p)->lpVtbl->GetObjectInfo(p, a, b, c)
#define IDirectInputDevice7_GetDeviceInfo(p, a) (p)->lpVtbl->GetDeviceInfo(p, a)
#define IDirectInputDevice7_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInputDevice7_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
#define IDirectInputDevice7_CreateEffect(p, a, b, c, d) (p)->lpVtbl->CreateEffect(p, a, b, c, d)
#define IDirectInputDevice7_EnumEffects(p, a, b, c) (p)->lpVtbl->EnumEffects(p, a, b, c)
#define IDirectInputDevice7_GetEffectInfo(p, a, b) (p)->lpVtbl->GetEffectInfo(p, a, b)
#define IDirectInputDevice7_GetForceFeedbackState(p, a) (p)->lpVtbl->GetForceFeedbackState(p, a)
#define IDirectInputDevice7_SendForceFeedbackCommand(p, a) (p)->lpVtbl->SendForceFeedbackCommand(p, a)
#define IDirectInputDevice7_EnumCreatedEffectObjects(p, a, b, c) (p)->lpVtbl->EnumCreatedEffectObjects(p, a, b, c)
#define IDirectInputDevice7_Escape(p, a) (p)->lpVtbl->Escape(p, a)
#define IDirectInputDevice7_Poll(p) (p)->lpVtbl->Poll(p)
#define IDirectInputDevice7_SendDeviceData(p, a, b, c, d) (p)->lpVtbl->SendDeviceData(p, a, b, c, d)
#define IDirectInputDevice7_EnumEffectsInFile(p, a, b, c, d) (p)->lpVtbl->EnumEffectsInFile(p, a, b, c, d)
#define IDirectInputDevice7_WriteEffectToFile(p, a, b, c, d) (p)->lpVtbl->WriteEffectToFile(p, a, b, c, d)
type IDirectInputDevice8AVtbl as IDirectInputDevice8AVtbl_

type IDirectInputDevice8A
	lpVtbl as IDirectInputDevice8AVtbl ptr
end type

type IDirectInputDevice8AVtbl_
	QueryInterface as function(byval This as IDirectInputDevice8A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice8A ptr) as ULONG
	Release as function(byval This as IDirectInputDevice8A ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice8A ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice8A ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice8A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice8A ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice8A ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice8A ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice8A ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice8A ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice8A ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice8A ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice8A ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice8A ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEA, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice8A ptr, byval pdidi as LPDIDEVICEINSTANCEA) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice8A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice8A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice8A ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice8A ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKA, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice8A ptr, byval pdei as LPDIEFFECTINFOA, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice8A ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice8A ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice8A ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice8A ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice8A ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice8A ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
	EnumEffectsInFile as function(byval This as IDirectInputDevice8A ptr, byval lpszFileName as LPCSTR, byval pec as LPDIENUMEFFECTSINFILECALLBACK, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	WriteEffectToFile as function(byval This as IDirectInputDevice8A ptr, byval lpszFileName as LPCSTR, byval dwEntries as DWORD, byval rgDiFileEft as LPDIFILEEFFECT, byval dwFlags as DWORD) as HRESULT
	BuildActionMap as function(byval This as IDirectInputDevice8A ptr, byval lpdiaf as LPDIACTIONFORMATA, byval lpszUserName as LPCSTR, byval dwFlags as DWORD) as HRESULT
	SetActionMap as function(byval This as IDirectInputDevice8A ptr, byval lpdiaf as LPDIACTIONFORMATA, byval lpszUserName as LPCSTR, byval dwFlags as DWORD) as HRESULT
	GetImageInfo as function(byval This as IDirectInputDevice8A ptr, byval lpdiDevImageInfoHeader as LPDIDEVICEIMAGEINFOHEADERA) as HRESULT
end type

type IDirectInputDevice8WVtbl as IDirectInputDevice8WVtbl_

type IDirectInputDevice8W
	lpVtbl as IDirectInputDevice8WVtbl ptr
end type

type IDirectInputDevice8WVtbl_
	QueryInterface as function(byval This as IDirectInputDevice8W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputDevice8W ptr) as ULONG
	Release as function(byval This as IDirectInputDevice8W ptr) as ULONG
	GetCapabilities as function(byval This as IDirectInputDevice8W ptr, byval lpDIDevCaps as LPDIDEVCAPS) as HRESULT
	EnumObjects as function(byval This as IDirectInputDevice8W ptr, byval lpCallback as LPDIENUMDEVICEOBJECTSCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetProperty as function(byval This as IDirectInputDevice8W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPDIPROPHEADER) as HRESULT
	SetProperty as function(byval This as IDirectInputDevice8W ptr, byval rguidProp as const GUID const ptr, byval pdiph as LPCDIPROPHEADER) as HRESULT
	Acquire as function(byval This as IDirectInputDevice8W ptr) as HRESULT
	Unacquire as function(byval This as IDirectInputDevice8W ptr) as HRESULT
	GetDeviceState as function(byval This as IDirectInputDevice8W ptr, byval cbData as DWORD, byval lpvData as LPVOID) as HRESULT
	GetDeviceData as function(byval This as IDirectInputDevice8W ptr, byval cbObjectData as DWORD, byval rgdod as LPDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval dwFlags as DWORD) as HRESULT
	SetDataFormat as function(byval This as IDirectInputDevice8W ptr, byval lpdf as LPCDIDATAFORMAT) as HRESULT
	SetEventNotification as function(byval This as IDirectInputDevice8W ptr, byval hEvent as HANDLE) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectInputDevice8W ptr, byval hwnd as HWND, byval dwFlags as DWORD) as HRESULT
	GetObjectInfo as function(byval This as IDirectInputDevice8W ptr, byval pdidoi as LPDIDEVICEOBJECTINSTANCEW, byval dwObj as DWORD, byval dwHow as DWORD) as HRESULT
	GetDeviceInfo as function(byval This as IDirectInputDevice8W ptr, byval pdidi as LPDIDEVICEINSTANCEW) as HRESULT
	RunControlPanel as function(byval This as IDirectInputDevice8W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputDevice8W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD, byval rguid as const GUID const ptr) as HRESULT
	CreateEffect as function(byval This as IDirectInputDevice8W ptr, byval rguid as const GUID const ptr, byval lpeff as LPCDIEFFECT, byval ppdeff as LPDIRECTINPUTEFFECT ptr, byval punkOuter as LPUNKNOWN) as HRESULT
	EnumEffects as function(byval This as IDirectInputDevice8W ptr, byval lpCallback as LPDIENUMEFFECTSCALLBACKW, byval pvRef as LPVOID, byval dwEffType as DWORD) as HRESULT
	GetEffectInfo as function(byval This as IDirectInputDevice8W ptr, byval pdei as LPDIEFFECTINFOW, byval rguid as const GUID const ptr) as HRESULT
	GetForceFeedbackState as function(byval This as IDirectInputDevice8W ptr, byval pdwOut as LPDWORD) as HRESULT
	SendForceFeedbackCommand as function(byval This as IDirectInputDevice8W ptr, byval dwFlags as DWORD) as HRESULT
	EnumCreatedEffectObjects as function(byval This as IDirectInputDevice8W ptr, byval lpCallback as LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, byval pvRef as LPVOID, byval fl as DWORD) as HRESULT
	Escape as function(byval This as IDirectInputDevice8W ptr, byval pesc as LPDIEFFESCAPE) as HRESULT
	Poll as function(byval This as IDirectInputDevice8W ptr) as HRESULT
	SendDeviceData as function(byval This as IDirectInputDevice8W ptr, byval cbObjectData as DWORD, byval rgdod as LPCDIDEVICEOBJECTDATA, byval pdwInOut as LPDWORD, byval fl as DWORD) as HRESULT
	EnumEffectsInFile as function(byval This as IDirectInputDevice8W ptr, byval lpszFileName as LPCWSTR, byval pec as LPDIENUMEFFECTSINFILECALLBACK, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	WriteEffectToFile as function(byval This as IDirectInputDevice8W ptr, byval lpszFileName as LPCWSTR, byval dwEntries as DWORD, byval rgDiFileEft as LPDIFILEEFFECT, byval dwFlags as DWORD) as HRESULT
	BuildActionMap as function(byval This as IDirectInputDevice8W ptr, byval lpdiaf as LPDIACTIONFORMATW, byval lpszUserName as LPCWSTR, byval dwFlags as DWORD) as HRESULT
	SetActionMap as function(byval This as IDirectInputDevice8W ptr, byval lpdiaf as LPDIACTIONFORMATW, byval lpszUserName as LPCWSTR, byval dwFlags as DWORD) as HRESULT
	GetImageInfo as function(byval This as IDirectInputDevice8W ptr, byval lpdiDevImageInfoHeader as LPDIDEVICEIMAGEINFOHEADERW) as HRESULT
end type

#define IDirectInputDevice8_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInputDevice8_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInputDevice8_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInputDevice8_GetCapabilities(p, a) (p)->lpVtbl->GetCapabilities(p, a)
#define IDirectInputDevice8_EnumObjects(p, a, b, c) (p)->lpVtbl->EnumObjects(p, a, b, c)
#define IDirectInputDevice8_GetProperty(p, a, b) (p)->lpVtbl->GetProperty(p, a, b)
#define IDirectInputDevice8_SetProperty(p, a, b) (p)->lpVtbl->SetProperty(p, a, b)
#define IDirectInputDevice8_Acquire(p) (p)->lpVtbl->Acquire(p)
#define IDirectInputDevice8_Unacquire(p) (p)->lpVtbl->Unacquire(p)
#define IDirectInputDevice8_GetDeviceState(p, a, b) (p)->lpVtbl->GetDeviceState(p, a, b)
#define IDirectInputDevice8_GetDeviceData(p, a, b, c, d) (p)->lpVtbl->GetDeviceData(p, a, b, c, d)
#define IDirectInputDevice8_SetDataFormat(p, a) (p)->lpVtbl->SetDataFormat(p, a)
#define IDirectInputDevice8_SetEventNotification(p, a) (p)->lpVtbl->SetEventNotification(p, a)
#define IDirectInputDevice8_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectInputDevice8_GetObjectInfo(p, a, b, c) (p)->lpVtbl->GetObjectInfo(p, a, b, c)
#define IDirectInputDevice8_GetDeviceInfo(p, a) (p)->lpVtbl->GetDeviceInfo(p, a)
#define IDirectInputDevice8_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInputDevice8_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
#define IDirectInputDevice8_CreateEffect(p, a, b, c, d) (p)->lpVtbl->CreateEffect(p, a, b, c, d)
#define IDirectInputDevice8_EnumEffects(p, a, b, c) (p)->lpVtbl->EnumEffects(p, a, b, c)
#define IDirectInputDevice8_GetEffectInfo(p, a, b) (p)->lpVtbl->GetEffectInfo(p, a, b)
#define IDirectInputDevice8_GetForceFeedbackState(p, a) (p)->lpVtbl->GetForceFeedbackState(p, a)
#define IDirectInputDevice8_SendForceFeedbackCommand(p, a) (p)->lpVtbl->SendForceFeedbackCommand(p, a)
#define IDirectInputDevice8_EnumCreatedEffectObjects(p, a, b, c) (p)->lpVtbl->EnumCreatedEffectObjects(p, a, b, c)
#define IDirectInputDevice8_Escape(p, a) (p)->lpVtbl->Escape(p, a)
#define IDirectInputDevice8_Poll(p) (p)->lpVtbl->Poll(p)
#define IDirectInputDevice8_SendDeviceData(p, a, b, c, d) (p)->lpVtbl->SendDeviceData(p, a, b, c, d)
#define IDirectInputDevice8_EnumEffectsInFile(p, a, b, c, d) (p)->lpVtbl->EnumEffectsInFile(p, a, b, c, d)
#define IDirectInputDevice8_WriteEffectToFile(p, a, b, c, d) (p)->lpVtbl->WriteEffectToFile(p, a, b, c, d)
#define IDirectInputDevice8_BuildActionMap(p, a, b, c) (p)->lpVtbl->BuildActionMap(p, a, b, c)
#define IDirectInputDevice8_SetActionMap(p, a, b, c) (p)->lpVtbl->SetActionMap(p, a, b, c)
#define IDirectInputDevice8_GetImageInfo(p, a) (p)->lpVtbl->GetImageInfo(p, a)

type DIMOUSESTATE
	lX as LONG
	lY as LONG
	lZ as LONG
	rgbButtons(0 to 3) as UBYTE
end type

type DIMOUSESTATE2
	lX as LONG
	lY as LONG
	lZ as LONG
	rgbButtons(0 to 7) as UBYTE
end type

#define DIMOFS_X FIELD_OFFSET(DIMOUSESTATE, lX)
#define DIMOFS_Y FIELD_OFFSET(DIMOUSESTATE, lY)
#define DIMOFS_Z FIELD_OFFSET(DIMOUSESTATE, lZ)
#define DIMOFS_BUTTON0 (FIELD_OFFSET(DIMOUSESTATE, rgbButtons) + 0)
#define DIMOFS_BUTTON1 (FIELD_OFFSET(DIMOUSESTATE, rgbButtons) + 1)
#define DIMOFS_BUTTON2 (FIELD_OFFSET(DIMOUSESTATE, rgbButtons) + 2)
#define DIMOFS_BUTTON3 (FIELD_OFFSET(DIMOUSESTATE, rgbButtons) + 3)
#define DIMOFS_BUTTON4 (FIELD_OFFSET(DIMOUSESTATE2, rgbButtons) + 4)
#define DIMOFS_BUTTON5 (FIELD_OFFSET(DIMOUSESTATE2, rgbButtons) + 5)
#define DIMOFS_BUTTON6 (FIELD_OFFSET(DIMOUSESTATE2, rgbButtons) + 6)
#define DIMOFS_BUTTON7 (FIELD_OFFSET(DIMOUSESTATE2, rgbButtons) + 7)

extern c_dfDIMouse as const DIDATAFORMAT
extern c_dfDIMouse2 as const DIDATAFORMAT
extern c_dfDIKeyboard as const DIDATAFORMAT
extern c_dfDIJoystick as const DIDATAFORMAT
extern c_dfDIJoystick2 as const DIDATAFORMAT
type IDirectInputAVtbl as IDirectInputAVtbl_

type IDirectInputA
	lpVtbl as IDirectInputAVtbl ptr
end type

type IDirectInputAVtbl_
	QueryInterface as function(byval This as IDirectInputA ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputA ptr) as ULONG
	Release as function(byval This as IDirectInputA ptr) as ULONG
	CreateDevice as function(byval This as IDirectInputA ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEA ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInputA ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInputA ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInputA ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputA ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
end type

type IDirectInputWVtbl as IDirectInputWVtbl_

type IDirectInputW
	lpVtbl as IDirectInputWVtbl ptr
end type

type IDirectInputWVtbl_
	QueryInterface as function(byval This as IDirectInputW ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInputW ptr) as ULONG
	Release as function(byval This as IDirectInputW ptr) as ULONG
	CreateDevice as function(byval This as IDirectInputW ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEW ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInputW ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInputW ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInputW ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInputW ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
end type

#define IDirectInput_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInput_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInput_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInput_CreateDevice(p, a, b, c) (p)->lpVtbl->CreateDevice(p, a, b, c)
#define IDirectInput_EnumDevices(p, a, b, c, d) (p)->lpVtbl->EnumDevices(p, a, b, c, d)
#define IDirectInput_GetDeviceStatus(p, a) (p)->lpVtbl->GetDeviceStatus(p, a)
#define IDirectInput_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInput_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
type IDirectInput2AVtbl as IDirectInput2AVtbl_

type IDirectInput2A
	lpVtbl as IDirectInput2AVtbl ptr
end type

type IDirectInput2AVtbl_
	QueryInterface as function(byval This as IDirectInput2A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput2A ptr) as ULONG
	Release as function(byval This as IDirectInput2A ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput2A ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEA ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput2A ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput2A ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput2A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput2A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput2A ptr, byval rguid as const GUID const ptr, byval pszName as LPCSTR, byval pguidInstance as LPGUID) as HRESULT
end type

type IDirectInput2WVtbl as IDirectInput2WVtbl_

type IDirectInput2W
	lpVtbl as IDirectInput2WVtbl ptr
end type

type IDirectInput2WVtbl_
	QueryInterface as function(byval This as IDirectInput2W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput2W ptr) as ULONG
	Release as function(byval This as IDirectInput2W ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput2W ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEW ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput2W ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput2W ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput2W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput2W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput2W ptr, byval rguid as const GUID const ptr, byval pszName as LPCWSTR, byval pguidInstance as LPGUID) as HRESULT
end type

#define IDirectInput2_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInput2_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInput2_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInput2_CreateDevice(p, a, b, c) (p)->lpVtbl->CreateDevice(p, a, b, c)
#define IDirectInput2_EnumDevices(p, a, b, c, d) (p)->lpVtbl->EnumDevices(p, a, b, c, d)
#define IDirectInput2_GetDeviceStatus(p, a) (p)->lpVtbl->GetDeviceStatus(p, a)
#define IDirectInput2_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInput2_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectInput2_FindDevice(p, a, b, c) (p)->lpVtbl->FindDevice(p, a, b, c)
type IDirectInput7AVtbl as IDirectInput7AVtbl_

type IDirectInput7A
	lpVtbl as IDirectInput7AVtbl ptr
end type

type IDirectInput7AVtbl_
	QueryInterface as function(byval This as IDirectInput7A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput7A ptr) as ULONG
	Release as function(byval This as IDirectInput7A ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput7A ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEA ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput7A ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput7A ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput7A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput7A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput7A ptr, byval rguid as const GUID const ptr, byval pszName as LPCSTR, byval pguidInstance as LPGUID) as HRESULT
	CreateDeviceEx as function(byval This as IDirectInput7A ptr, byval rguid as const GUID const ptr, byval riid as const IID const ptr, byval pvOut as LPVOID ptr, byval lpUnknownOuter as LPUNKNOWN) as HRESULT
end type

type IDirectInput7WVtbl as IDirectInput7WVtbl_

type IDirectInput7W
	lpVtbl as IDirectInput7WVtbl ptr
end type

type IDirectInput7WVtbl_
	QueryInterface as function(byval This as IDirectInput7W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput7W ptr) as ULONG
	Release as function(byval This as IDirectInput7W ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput7W ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICEW ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput7W ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput7W ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput7W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput7W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput7W ptr, byval rguid as const GUID const ptr, byval pszName as LPCWSTR, byval pguidInstance as LPGUID) as HRESULT
	CreateDeviceEx as function(byval This as IDirectInput7W ptr, byval rguid as const GUID const ptr, byval riid as const IID const ptr, byval pvOut as LPVOID ptr, byval lpUnknownOuter as LPUNKNOWN) as HRESULT
end type

#define IDirectInput7_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInput7_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInput7_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInput7_CreateDevice(p, a, b, c) (p)->lpVtbl->CreateDevice(p, a, b, c)
#define IDirectInput7_EnumDevices(p, a, b, c, d) (p)->lpVtbl->EnumDevices(p, a, b, c, d)
#define IDirectInput7_GetDeviceStatus(p, a) (p)->lpVtbl->GetDeviceStatus(p, a)
#define IDirectInput7_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInput7_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectInput7_FindDevice(p, a, b, c) (p)->lpVtbl->FindDevice(p, a, b, c)
#define IDirectInput7_CreateDeviceEx(p, a, b, c, d) (p)->lpVtbl->CreateDeviceEx(p, a, b, c, d)
type IDirectInput8AVtbl as IDirectInput8AVtbl_

type IDirectInput8A
	lpVtbl as IDirectInput8AVtbl ptr
end type

type IDirectInput8AVtbl_
	QueryInterface as function(byval This as IDirectInput8A ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput8A ptr) as ULONG
	Release as function(byval This as IDirectInput8A ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput8A ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICE8A ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput8A ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput8A ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput8A ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput8A ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput8A ptr, byval rguid as const GUID const ptr, byval pszName as LPCSTR, byval pguidInstance as LPGUID) as HRESULT
	EnumDevicesBySemantics as function(byval This as IDirectInput8A ptr, byval ptszUserName as LPCSTR, byval lpdiActionFormat as LPDIACTIONFORMATA, byval lpCallback as LPDIENUMDEVICESBYSEMANTICSCBA, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	ConfigureDevices as function(byval This as IDirectInput8A ptr, byval lpdiCallback as LPDICONFIGUREDEVICESCALLBACK, byval lpdiCDParams as LPDICONFIGUREDEVICESPARAMSA, byval dwFlags as DWORD, byval pvRefData as LPVOID) as HRESULT
end type

type IDirectInput8WVtbl as IDirectInput8WVtbl_

type IDirectInput8W
	lpVtbl as IDirectInput8WVtbl ptr
end type

type IDirectInput8WVtbl_
	QueryInterface as function(byval This as IDirectInput8W ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectInput8W ptr) as ULONG
	Release as function(byval This as IDirectInput8W ptr) as ULONG
	CreateDevice as function(byval This as IDirectInput8W ptr, byval rguid as const GUID const ptr, byval lplpDirectInputDevice as LPDIRECTINPUTDEVICE8W ptr, byval pUnkOuter as LPUNKNOWN) as HRESULT
	EnumDevices as function(byval This as IDirectInput8W ptr, byval dwDevType as DWORD, byval lpCallback as LPDIENUMDEVICESCALLBACKW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	GetDeviceStatus as function(byval This as IDirectInput8W ptr, byval rguidInstance as const GUID const ptr) as HRESULT
	RunControlPanel as function(byval This as IDirectInput8W ptr, byval hwndOwner as HWND, byval dwFlags as DWORD) as HRESULT
	Initialize as function(byval This as IDirectInput8W ptr, byval hinst as HINSTANCE, byval dwVersion as DWORD) as HRESULT
	FindDevice as function(byval This as IDirectInput8W ptr, byval rguid as const GUID const ptr, byval pszName as LPCWSTR, byval pguidInstance as LPGUID) as HRESULT
	EnumDevicesBySemantics as function(byval This as IDirectInput8W ptr, byval ptszUserName as LPCWSTR, byval lpdiActionFormat as LPDIACTIONFORMATW, byval lpCallback as LPDIENUMDEVICESBYSEMANTICSCBW, byval pvRef as LPVOID, byval dwFlags as DWORD) as HRESULT
	ConfigureDevices as function(byval This as IDirectInput8W ptr, byval lpdiCallback as LPDICONFIGUREDEVICESCALLBACK, byval lpdiCDParams as LPDICONFIGUREDEVICESPARAMSW, byval dwFlags as DWORD, byval pvRefData as LPVOID) as HRESULT
end type

#define IDirectInput8_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectInput8_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectInput8_Release(p) (p)->lpVtbl->Release(p)
#define IDirectInput8_CreateDevice(p, a, b, c) (p)->lpVtbl->CreateDevice(p, a, b, c)
#define IDirectInput8_EnumDevices(p, a, b, c, d) (p)->lpVtbl->EnumDevices(p, a, b, c, d)
#define IDirectInput8_GetDeviceStatus(p, a) (p)->lpVtbl->GetDeviceStatus(p, a)
#define IDirectInput8_RunControlPanel(p, a, b) (p)->lpVtbl->RunControlPanel(p, a, b)
#define IDirectInput8_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectInput8_FindDevice(p, a, b, c) (p)->lpVtbl->FindDevice(p, a, b, c)
#define IDirectInput8_EnumDevicesBySemantics(p, a, b, c, d, e) (p)->lpVtbl->EnumDevicesBySemantics(p, a, b, c, d, e)
#define IDirectInput8_ConfigureDevices(p, a, b, c, d) (p)->lpVtbl->ConfigureDevices(p, a, b, c, d)
declare function DirectInput8Create(byval as HINSTANCE, byval as DWORD, byval as const IID const ptr, byval as LPVOID ptr, byval as LPUNKNOWN) as HRESULT

end extern
