import type * as gax from 'google-gax';
import type { Callback, CallOptions, Descriptors, ClientOptions, PaginationCallback } from 'google-gax';
import { Transform } from 'stream';
import * as protos from '../../protos/protos';
/**
 *  Service for ingesting and querying logs.
 * @class
 * @memberof v2
 */
export declare class LoggingServiceV2Client {
    private _terminated;
    private _opts;
    private _providedCustomServicePath;
    private _gaxModule;
    private _gaxGrpc;
    private _protos;
    private _defaults;
    private _universeDomain;
    private _servicePath;
    auth: gax.GoogleAuth;
    descriptors: Descriptors;
    warn: (code: string, message: string, warnType?: string) => void;
    innerApiCalls: {
        [name: string]: Function;
    };
    pathTemplates: {
        [name: string]: gax.PathTemplate;
    };
    loggingServiceV2Stub?: Promise<{
        [name: string]: Function;
    }>;
    /**
     * Construct an instance of LoggingServiceV2Client.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
     *     For more information, please check the
     *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
     * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
     *     need to avoid loading the default gRPC version and want to use the fallback
     *     HTTP implementation. Load only fallback version and pass it to the constructor:
     *     ```
     *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
     *     const client = new LoggingServiceV2Client({fallback: true}, gax);
     *     ```
     */
    constructor(opts?: ClientOptions, gaxInstance?: typeof gax | typeof gax.fallback);
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize(): Promise<{
        [name: string]: Function;
    }>;
    /**
     * The DNS address for this API service.
     * @deprecated Use the apiEndpoint method of the client instance.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath(): string;
    /**
     * The DNS address for this API service - same as servicePath.
     * @deprecated Use the apiEndpoint method of the client instance.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint(): string;
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    get apiEndpoint(): string;
    get universeDomain(): string;
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port(): number;
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes(): string[];
    getProjectId(): Promise<string>;
    getProjectId(callback: Callback<string, undefined, undefined>): void;
    /**
     * Deletes all the log entries in a log for the _Default Log Bucket. The log
     * reappears if it receives new entries. Log entries written shortly before
     * the delete operation might not be deleted. Entries received after the
     * delete operation with a timestamp before the operation will be deleted.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.logName
     *   Required. The resource name of the log to delete:
     *
     *   * `projects/[PROJECT_ID]/logs/[LOG_ID]`
     *   * `organizations/[ORGANIZATION_ID]/logs/[LOG_ID]`
     *   * `billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]`
     *   * `folders/[FOLDER_ID]/logs/[LOG_ID]`
     *
     *   `[LOG_ID]` must be URL-encoded. For example,
     *   `"projects/my-project-id/logs/syslog"`,
     *   `"organizations/123/logs/cloudaudit.googleapis.com%2Factivity"`.
     *
     *   For more information about log names, see
     *   {@link protos.google.logging.v2.LogEntry|LogEntry}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.delete_log.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_DeleteLog_async
     */
    deleteLog(request?: protos.google.logging.v2.IDeleteLogRequest, options?: CallOptions): Promise<[
        protos.google.protobuf.IEmpty,
        protos.google.logging.v2.IDeleteLogRequest | undefined,
        {} | undefined
    ]>;
    deleteLog(request: protos.google.logging.v2.IDeleteLogRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteLogRequest | null | undefined, {} | null | undefined>): void;
    deleteLog(request: protos.google.logging.v2.IDeleteLogRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteLogRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Writes log entries to Logging. This API method is the
     * only way to send log entries to Logging. This method
     * is used, directly or indirectly, by the Logging agent
     * (fluentd) and all logging libraries configured to use Logging.
     * A single request may contain log entries for a maximum of 1000
     * different resources (projects, organizations, billing accounts or
     * folders)
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} [request.logName]
     *   Optional. A default log resource name that is assigned to all log entries
     *   in `entries` that do not specify a value for `log_name`:
     *
     *   * `projects/[PROJECT_ID]/logs/[LOG_ID]`
     *   * `organizations/[ORGANIZATION_ID]/logs/[LOG_ID]`
     *   * `billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]`
     *   * `folders/[FOLDER_ID]/logs/[LOG_ID]`
     *
     *   `[LOG_ID]` must be URL-encoded. For example:
     *
     *       "projects/my-project-id/logs/syslog"
     *       "organizations/123/logs/cloudaudit.googleapis.com%2Factivity"
     *
     *   The permission `logging.logEntries.create` is needed on each project,
     *   organization, billing account, or folder that is receiving new log
     *   entries, whether the resource is specified in `logName` or in an
     *   individual log entry.
     * @param {google.api.MonitoredResource} [request.resource]
     *   Optional. A default monitored resource object that is assigned to all log
     *   entries in `entries` that do not specify a value for `resource`. Example:
     *
     *       { "type": "gce_instance",
     *         "labels": {
     *           "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
     *
     *   See {@link protos.google.logging.v2.LogEntry|LogEntry}.
     * @param {number[]} [request.labels]
     *   Optional. Default labels that are added to the `labels` field of all log
     *   entries in `entries`. If a log entry already has a label with the same key
     *   as a label in this parameter, then the log entry's label is not changed.
     *   See {@link protos.google.logging.v2.LogEntry|LogEntry}.
     * @param {number[]} request.entries
     *   Required. The log entries to send to Logging. The order of log
     *   entries in this list does not matter. Values supplied in this method's
     *   `log_name`, `resource`, and `labels` fields are copied into those log
     *   entries in this list that do not include values for their corresponding
     *   fields. For more information, see the
     *   {@link protos.google.logging.v2.LogEntry|LogEntry} type.
     *
     *   If the `timestamp` or `insert_id` fields are missing in log entries, then
     *   this method supplies the current time or a unique identifier, respectively.
     *   The supplied values are chosen so that, among the log entries that did not
     *   supply their own values, the entries earlier in the list will sort before
     *   the entries later in the list. See the `entries.list` method.
     *
     *   Log entries with timestamps that are more than the
     *   [logs retention period](https://cloud.google.com/logging/quotas) in
     *   the past or more than 24 hours in the future will not be available when
     *   calling `entries.list`. However, those log entries can still be [exported
     *   with
     *   LogSinks](https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
     *
     *   To improve throughput and to avoid exceeding the
     *   [quota limit](https://cloud.google.com/logging/quotas) for calls to
     *   `entries.write`, you should try to include several log entries in this
     *   list, rather than calling this method for each individual log entry.
     * @param {boolean} [request.partialSuccess]
     *   Optional. Whether a batch's valid entries should be written even if some
     *   other entry failed due to a permanent error such as INVALID_ARGUMENT or
     *   PERMISSION_DENIED. If any entry failed, then the response status is the
     *   response status of one of the failed entries. The response will include
     *   error details in `WriteLogEntriesPartialErrors.log_entry_errors` keyed by
     *   the entries' zero-based index in the `entries`. Failed requests for which
     *   no entries are written will not include per-entry errors.
     * @param {boolean} [request.dryRun]
     *   Optional. If true, the request should expect normal response, but the
     *   entries won't be persisted nor exported. Useful for checking whether the
     *   logging API endpoints are working properly before sending valuable data.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing {@link protos.google.logging.v2.WriteLogEntriesResponse|WriteLogEntriesResponse}.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.write_log_entries.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_WriteLogEntries_async
     */
    writeLogEntries(request?: protos.google.logging.v2.IWriteLogEntriesRequest, options?: CallOptions): Promise<[
        protos.google.logging.v2.IWriteLogEntriesResponse,
        protos.google.logging.v2.IWriteLogEntriesRequest | undefined,
        {} | undefined
    ]>;
    writeLogEntries(request: protos.google.logging.v2.IWriteLogEntriesRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.IWriteLogEntriesResponse, protos.google.logging.v2.IWriteLogEntriesRequest | null | undefined, {} | null | undefined>): void;
    writeLogEntries(request: protos.google.logging.v2.IWriteLogEntriesRequest, callback: Callback<protos.google.logging.v2.IWriteLogEntriesResponse, protos.google.logging.v2.IWriteLogEntriesRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Streaming read of log entries as they are ingested. Until the stream is
     * terminated, it will continue reading logs.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing {@link protos.google.logging.v2.TailLogEntriesRequest|TailLogEntriesRequest} for write() method, and
     *   will emit objects representing {@link protos.google.logging.v2.TailLogEntriesResponse|TailLogEntriesResponse} on 'data' event asynchronously.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#bi-directional-streaming | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.tail_log_entries.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_TailLogEntries_async
     */
    tailLogEntries(options?: CallOptions): gax.CancellableStream;
    /**
     * Lists log entries.  Use this method to retrieve log entries that originated
     * from a project/folder/organization/billing account.  For ways to export log
     * entries, see [Exporting
     * Logs](https://cloud.google.com/logging/docs/export).
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string[]} request.resourceNames
     *   Required. Names of one or more parent resources from which to
     *   retrieve log entries:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   May alternatively be one or more views:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   Projects listed in the `project_ids` field are added to this list.
     *   A maximum of 100 resources may be specified in a single request.
     * @param {string} [request.filter]
     *   Optional. Only log entries that match the filter are returned.  An empty
     *   filter matches all log entries in the resources listed in `resource_names`.
     *   Referencing a parent resource that is not listed in `resource_names` will
     *   cause the filter to return no results. The maximum length of a filter is
     *   20,000 characters.
     * @param {string} [request.orderBy]
     *   Optional. How the results should be sorted.  Presently, the only permitted
     *   values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
     *   option returns entries in order of increasing values of
     *   `LogEntry.timestamp` (oldest first), and the second option returns entries
     *   in order of decreasing timestamps (newest first).  Entries with equal
     *   timestamps are returned in order of their `insert_id` values.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Default is 50. If the value is negative or exceeds 1000, the request is
     *   rejected. The presence of `next_page_token` in the response indicates that
     *   more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `page_token` must be the value of
     *   `next_page_token` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of {@link protos.google.logging.v2.LogEntry|LogEntry}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listLogEntriesAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listLogEntries(request?: protos.google.logging.v2.IListLogEntriesRequest, options?: CallOptions): Promise<[
        protos.google.logging.v2.ILogEntry[],
        protos.google.logging.v2.IListLogEntriesRequest | null,
        protos.google.logging.v2.IListLogEntriesResponse
    ]>;
    listLogEntries(request: protos.google.logging.v2.IListLogEntriesRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListLogEntriesRequest, protos.google.logging.v2.IListLogEntriesResponse | null | undefined, protos.google.logging.v2.ILogEntry>): void;
    listLogEntries(request: protos.google.logging.v2.IListLogEntriesRequest, callback: PaginationCallback<protos.google.logging.v2.IListLogEntriesRequest, protos.google.logging.v2.IListLogEntriesResponse | null | undefined, protos.google.logging.v2.ILogEntry>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string[]} request.resourceNames
     *   Required. Names of one or more parent resources from which to
     *   retrieve log entries:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   May alternatively be one or more views:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   Projects listed in the `project_ids` field are added to this list.
     *   A maximum of 100 resources may be specified in a single request.
     * @param {string} [request.filter]
     *   Optional. Only log entries that match the filter are returned.  An empty
     *   filter matches all log entries in the resources listed in `resource_names`.
     *   Referencing a parent resource that is not listed in `resource_names` will
     *   cause the filter to return no results. The maximum length of a filter is
     *   20,000 characters.
     * @param {string} [request.orderBy]
     *   Optional. How the results should be sorted.  Presently, the only permitted
     *   values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
     *   option returns entries in order of increasing values of
     *   `LogEntry.timestamp` (oldest first), and the second option returns entries
     *   in order of decreasing timestamps (newest first).  Entries with equal
     *   timestamps are returned in order of their `insert_id` values.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Default is 50. If the value is negative or exceeds 1000, the request is
     *   rejected. The presence of `next_page_token` in the response indicates that
     *   more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `page_token` must be the value of
     *   `next_page_token` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing {@link protos.google.logging.v2.LogEntry|LogEntry} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listLogEntriesAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listLogEntriesStream(request?: protos.google.logging.v2.IListLogEntriesRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listLogEntries`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string[]} request.resourceNames
     *   Required. Names of one or more parent resources from which to
     *   retrieve log entries:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   May alternatively be one or more views:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   Projects listed in the `project_ids` field are added to this list.
     *   A maximum of 100 resources may be specified in a single request.
     * @param {string} [request.filter]
     *   Optional. Only log entries that match the filter are returned.  An empty
     *   filter matches all log entries in the resources listed in `resource_names`.
     *   Referencing a parent resource that is not listed in `resource_names` will
     *   cause the filter to return no results. The maximum length of a filter is
     *   20,000 characters.
     * @param {string} [request.orderBy]
     *   Optional. How the results should be sorted.  Presently, the only permitted
     *   values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
     *   option returns entries in order of increasing values of
     *   `LogEntry.timestamp` (oldest first), and the second option returns entries
     *   in order of decreasing timestamps (newest first).  Entries with equal
     *   timestamps are returned in order of their `insert_id` values.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Default is 50. If the value is negative or exceeds 1000, the request is
     *   rejected. The presence of `next_page_token` in the response indicates that
     *   more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `page_token` must be the value of
     *   `next_page_token` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
     *   When you iterate the returned iterable, each element will be an object representing
     *   {@link protos.google.logging.v2.LogEntry|LogEntry}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_log_entries.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListLogEntries_async
     */
    listLogEntriesAsync(request?: protos.google.logging.v2.IListLogEntriesRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogEntry>;
    /**
     * Lists the descriptors for monitored resource types used by Logging.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of {@link protos.google.api.MonitoredResourceDescriptor|MonitoredResourceDescriptor}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listMonitoredResourceDescriptorsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listMonitoredResourceDescriptors(request?: protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, options?: CallOptions): Promise<[
        protos.google.api.IMonitoredResourceDescriptor[],
        protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest | null,
        protos.google.logging.v2.IListMonitoredResourceDescriptorsResponse
    ]>;
    listMonitoredResourceDescriptors(request: protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, protos.google.logging.v2.IListMonitoredResourceDescriptorsResponse | null | undefined, protos.google.api.IMonitoredResourceDescriptor>): void;
    listMonitoredResourceDescriptors(request: protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, callback: PaginationCallback<protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, protos.google.logging.v2.IListMonitoredResourceDescriptorsResponse | null | undefined, protos.google.api.IMonitoredResourceDescriptor>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing {@link protos.google.api.MonitoredResourceDescriptor|MonitoredResourceDescriptor} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listMonitoredResourceDescriptorsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listMonitoredResourceDescriptorsStream(request?: protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listMonitoredResourceDescriptors`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
     *   When you iterate the returned iterable, each element will be an object representing
     *   {@link protos.google.api.MonitoredResourceDescriptor|MonitoredResourceDescriptor}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_monitored_resource_descriptors.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListMonitoredResourceDescriptors_async
     */
    listMonitoredResourceDescriptorsAsync(request?: protos.google.logging.v2.IListMonitoredResourceDescriptorsRequest, options?: CallOptions): AsyncIterable<protos.google.api.IMonitoredResourceDescriptor>;
    /**
     * Lists the logs in projects, organizations, folders, or billing accounts.
     * Only logs that have entries are listed.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name to list logs for:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {string[]} [request.resourceNames]
     *   Optional. List of resource names to list logs for:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   To support legacy queries, it could also be:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   The resource name in the `parent` field is added to this list.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of string.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listLogsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listLogs(request?: protos.google.logging.v2.IListLogsRequest, options?: CallOptions): Promise<[
        string[],
        protos.google.logging.v2.IListLogsRequest | null,
        protos.google.logging.v2.IListLogsResponse
    ]>;
    listLogs(request: protos.google.logging.v2.IListLogsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListLogsRequest, protos.google.logging.v2.IListLogsResponse | null | undefined, string>): void;
    listLogs(request: protos.google.logging.v2.IListLogsRequest, callback: PaginationCallback<protos.google.logging.v2.IListLogsRequest, protos.google.logging.v2.IListLogsResponse | null | undefined, string>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name to list logs for:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {string[]} [request.resourceNames]
     *   Optional. List of resource names to list logs for:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   To support legacy queries, it could also be:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   The resource name in the `parent` field is added to this list.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing string on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listLogsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     */
    listLogsStream(request?: protos.google.logging.v2.IListLogsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listLogs`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name to list logs for:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     * @param {string[]} [request.resourceNames]
     *   Optional. List of resource names to list logs for:
     *
     *    * `projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *    * `folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]`
     *
     *   To support legacy queries, it could also be:
     *
     *   *  `projects/[PROJECT_ID]`
     *   *  `organizations/[ORGANIZATION_ID]`
     *   *  `billingAccounts/[BILLING_ACCOUNT_ID]`
     *   *  `folders/[FOLDER_ID]`
     *
     *   The resource name in the `parent` field is added to this list.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored.  The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method.  `pageToken` must be the value of
     *   `nextPageToken` from the previous response.  The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
     *   When you iterate the returned iterable, each element will be an object representing
     *   string. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/logging_service_v2.list_logs.js</caption>
     * region_tag:logging_v2_generated_LoggingServiceV2_ListLogs_async
     */
    listLogsAsync(request?: protos.google.logging.v2.IListLogsRequest, options?: CallOptions): AsyncIterable<string>;
    /**
     * Return a fully-qualified billingAccountCmekSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountCmekSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountCmekSettings resource.
     *
     * @param {string} billingAccountCmekSettingsName
     *   A fully-qualified path representing billing_account_cmekSettings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountCmekSettingsName(billingAccountCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountExclusion resource name string.
     *
     * @param {string} billing_account
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    billingAccountExclusionPath(billingAccount: string, exclusion: string): string;
    /**
     * Parse the billing_account from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Parse the exclusion from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucket resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketPath(billingAccount: string, location: string, bucket: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucketLink resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @param {string} link
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketLinkPath(billingAccount: string, location: string, bucket: string, link: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucketLink resource.
     *
     * @param {string} billingAccountLocationBucketLinkName
     *   A fully-qualified path representing billing_account_location_bucket_link resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketLinkName(billingAccountLocationBucketLinkName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucketLink resource.
     *
     * @param {string} billingAccountLocationBucketLinkName
     *   A fully-qualified path representing billing_account_location_bucket_link resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketLinkName(billingAccountLocationBucketLinkName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucketLink resource.
     *
     * @param {string} billingAccountLocationBucketLinkName
     *   A fully-qualified path representing billing_account_location_bucket_link resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketLinkName(billingAccountLocationBucketLinkName: string): string | number;
    /**
     * Parse the link from BillingAccountLocationBucketLink resource.
     *
     * @param {string} billingAccountLocationBucketLinkName
     *   A fully-qualified path representing billing_account_location_bucket_link resource.
     * @returns {string} A string representing the link.
     */
    matchLinkFromBillingAccountLocationBucketLinkName(billingAccountLocationBucketLinkName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucketView resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketViewPath(billingAccount: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the view from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLog resource name string.
     *
     * @param {string} billing_account
     * @param {string} log
     * @returns {string} Resource name string.
     */
    billingAccountLogPath(billingAccount: string, log: string): string;
    /**
     * Parse the billing_account from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Parse the log from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountSettings resource.
     *
     * @param {string} billingAccountSettingsName
     *   A fully-qualified path representing billing_account_settings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSettingsName(billingAccountSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSink resource name string.
     *
     * @param {string} billing_account
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    billingAccountSinkPath(billingAccount: string, sink: string): string;
    /**
     * Parse the billing_account from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Parse the sink from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Return a fully-qualified folderCmekSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderCmekSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderCmekSettings resource.
     *
     * @param {string} folderCmekSettingsName
     *   A fully-qualified path representing folder_cmekSettings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderCmekSettingsName(folderCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderExclusion resource name string.
     *
     * @param {string} folder
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    folderExclusionPath(folder: string, exclusion: string): string;
    /**
     * Parse the folder from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Parse the exclusion from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucket resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    folderLocationBucketPath(folder: string, location: string, bucket: string): string;
    /**
     * Parse the folder from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the location from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucketLink resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @param {string} link
     * @returns {string} Resource name string.
     */
    folderLocationBucketLinkPath(folder: string, location: string, bucket: string, link: string): string;
    /**
     * Parse the folder from FolderLocationBucketLink resource.
     *
     * @param {string} folderLocationBucketLinkName
     *   A fully-qualified path representing folder_location_bucket_link resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketLinkName(folderLocationBucketLinkName: string): string | number;
    /**
     * Parse the location from FolderLocationBucketLink resource.
     *
     * @param {string} folderLocationBucketLinkName
     *   A fully-qualified path representing folder_location_bucket_link resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketLinkName(folderLocationBucketLinkName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucketLink resource.
     *
     * @param {string} folderLocationBucketLinkName
     *   A fully-qualified path representing folder_location_bucket_link resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketLinkName(folderLocationBucketLinkName: string): string | number;
    /**
     * Parse the link from FolderLocationBucketLink resource.
     *
     * @param {string} folderLocationBucketLinkName
     *   A fully-qualified path representing folder_location_bucket_link resource.
     * @returns {string} A string representing the link.
     */
    matchLinkFromFolderLocationBucketLinkName(folderLocationBucketLinkName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucketView resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    folderLocationBucketViewPath(folder: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the folder from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the location from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the view from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified folderLog resource name string.
     *
     * @param {string} folder
     * @param {string} log
     * @returns {string} Resource name string.
     */
    folderLogPath(folder: string, log: string): string;
    /**
     * Parse the folder from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLogName(folderLogName: string): string | number;
    /**
     * Parse the log from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromFolderLogName(folderLogName: string): string | number;
    /**
     * Return a fully-qualified folderSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderSettings resource.
     *
     * @param {string} folderSettingsName
     *   A fully-qualified path representing folder_settings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSettingsName(folderSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderSink resource name string.
     *
     * @param {string} folder
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    folderSinkPath(folder: string, sink: string): string;
    /**
     * Parse the folder from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Parse the sink from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Return a fully-qualified logMetric resource name string.
     *
     * @param {string} project
     * @param {string} metric
     * @returns {string} Resource name string.
     */
    logMetricPath(project: string, metric: string): string;
    /**
     * Parse the project from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromLogMetricName(logMetricName: string): string | number;
    /**
     * Parse the metric from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the metric.
     */
    matchMetricFromLogMetricName(logMetricName: string): string | number;
    /**
     * Return a fully-qualified organizationCmekSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationCmekSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationCmekSettings resource.
     *
     * @param {string} organizationCmekSettingsName
     *   A fully-qualified path representing organization_cmekSettings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationCmekSettingsName(organizationCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationExclusion resource name string.
     *
     * @param {string} organization
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    organizationExclusionPath(organization: string, exclusion: string): string;
    /**
     * Parse the organization from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Parse the exclusion from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucket resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    organizationLocationBucketPath(organization: string, location: string, bucket: string): string;
    /**
     * Parse the organization from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucketLink resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @param {string} link
     * @returns {string} Resource name string.
     */
    organizationLocationBucketLinkPath(organization: string, location: string, bucket: string, link: string): string;
    /**
     * Parse the organization from OrganizationLocationBucketLink resource.
     *
     * @param {string} organizationLocationBucketLinkName
     *   A fully-qualified path representing organization_location_bucket_link resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketLinkName(organizationLocationBucketLinkName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucketLink resource.
     *
     * @param {string} organizationLocationBucketLinkName
     *   A fully-qualified path representing organization_location_bucket_link resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketLinkName(organizationLocationBucketLinkName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucketLink resource.
     *
     * @param {string} organizationLocationBucketLinkName
     *   A fully-qualified path representing organization_location_bucket_link resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketLinkName(organizationLocationBucketLinkName: string): string | number;
    /**
     * Parse the link from OrganizationLocationBucketLink resource.
     *
     * @param {string} organizationLocationBucketLinkName
     *   A fully-qualified path representing organization_location_bucket_link resource.
     * @returns {string} A string representing the link.
     */
    matchLinkFromOrganizationLocationBucketLinkName(organizationLocationBucketLinkName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucketView resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    organizationLocationBucketViewPath(organization: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the organization from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the view from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified organizationLog resource name string.
     *
     * @param {string} organization
     * @param {string} log
     * @returns {string} Resource name string.
     */
    organizationLogPath(organization: string, log: string): string;
    /**
     * Parse the organization from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Parse the log from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Return a fully-qualified organizationSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationSettings resource.
     *
     * @param {string} organizationSettingsName
     *   A fully-qualified path representing organization_settings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSettingsName(organizationSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationSink resource name string.
     *
     * @param {string} organization
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    organizationSinkPath(organization: string, sink: string): string;
    /**
     * Parse the organization from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Parse the sink from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Return a fully-qualified project resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectPath(project: string): string;
    /**
     * Parse the project from Project resource.
     *
     * @param {string} projectName
     *   A fully-qualified path representing Project resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectName(projectName: string): string | number;
    /**
     * Return a fully-qualified projectCmekSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectCmekSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectCmekSettings resource.
     *
     * @param {string} projectCmekSettingsName
     *   A fully-qualified path representing project_cmekSettings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectCmekSettingsName(projectCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectExclusion resource name string.
     *
     * @param {string} project
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    projectExclusionPath(project: string, exclusion: string): string;
    /**
     * Parse the project from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Parse the exclusion from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucket resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    projectLocationBucketPath(project: string, location: string, bucket: string): string;
    /**
     * Parse the project from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucketLink resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @param {string} link
     * @returns {string} Resource name string.
     */
    projectLocationBucketLinkPath(project: string, location: string, bucket: string, link: string): string;
    /**
     * Parse the project from ProjectLocationBucketLink resource.
     *
     * @param {string} projectLocationBucketLinkName
     *   A fully-qualified path representing project_location_bucket_link resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketLinkName(projectLocationBucketLinkName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucketLink resource.
     *
     * @param {string} projectLocationBucketLinkName
     *   A fully-qualified path representing project_location_bucket_link resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketLinkName(projectLocationBucketLinkName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucketLink resource.
     *
     * @param {string} projectLocationBucketLinkName
     *   A fully-qualified path representing project_location_bucket_link resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketLinkName(projectLocationBucketLinkName: string): string | number;
    /**
     * Parse the link from ProjectLocationBucketLink resource.
     *
     * @param {string} projectLocationBucketLinkName
     *   A fully-qualified path representing project_location_bucket_link resource.
     * @returns {string} A string representing the link.
     */
    matchLinkFromProjectLocationBucketLinkName(projectLocationBucketLinkName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucketView resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    projectLocationBucketViewPath(project: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the project from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the view from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified projectLog resource name string.
     *
     * @param {string} project
     * @param {string} log
     * @returns {string} Resource name string.
     */
    projectLogPath(project: string, log: string): string;
    /**
     * Parse the project from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLogName(projectLogName: string): string | number;
    /**
     * Parse the log from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromProjectLogName(projectLogName: string): string | number;
    /**
     * Return a fully-qualified projectSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectSettings resource.
     *
     * @param {string} projectSettingsName
     *   A fully-qualified path representing project_settings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSettingsName(projectSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectSink resource name string.
     *
     * @param {string} project
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    projectSinkPath(project: string, sink: string): string;
    /**
     * Parse the project from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Parse the sink from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close(): Promise<void>;
}
