/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.StringField;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.function.Function;

public class StringPropertyMapDB
extends PropertyMapDB<String>
implements StringPropertyMap {
    private Function<Long, String> valueReader = addrKey -> {
        Table table = this.propertyTable;
        DBRecord rec = null;
        try {
            if (table != null) {
                rec = table.getRecord(addrKey.longValue());
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return rec != null ? rec.getString(0) : null;
    };

    public StringPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.checkMapVersion(openMode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, String value) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            long addrKey = this.addrMap.getKey(addr, true);
            String oldValue = null;
            if (this.propertyTable == null) {
                this.createTable((Field)StringField.INSTANCE);
            } else {
                oldValue = (String)this.cache.get(addrKey);
                if (oldValue == null) {
                    oldValue = this.valueReader.apply(addrKey);
                }
            }
            DBRecord rec = this.schema.createRecord(addrKey);
            rec.setString(0, value);
            this.propertyTable.putRecord(rec);
            this.cache.put(addrKey, (Object)value);
            this.changeMgr.setPropertyChanged(this.name, addr, oldValue, value);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getString(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        long addrKey = this.addrMap.getKey(addr, false);
        if (addrKey == -1L) {
            return null;
        }
        return (String)this.cache.computeIfAbsent(addrKey, this.valueReader);
    }

    @Override
    public String get(Address addr) {
        return this.getString(addr);
    }
}

