/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.GraphJobListener;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import util.CollectionUtils;

public class FitGraphToViewJob<V extends VisualVertex, E extends VisualEdge<V>>
implements GraphJob {
    private final Set<VisualizationViewer<V, E>> viewers = new HashSet<VisualizationViewer<V, E>>();
    private boolean isFinished;
    private final boolean onlyResizeWhenTooBig;

    @SafeVarargs
    public FitGraphToViewJob(VisualizationServer<V, E> ... viewers) {
        for (VisualizationServer<V, E> viewer : viewers) {
            if (!(viewer instanceof VisualizationViewer)) {
                throw new IllegalArgumentException("VisualizationServer is not an instance of VisualizationViewer.  We currently need this for bounds information.");
            }
            this.viewers.add((VisualizationViewer)viewer);
        }
        this.onlyResizeWhenTooBig = false;
    }

    public FitGraphToViewJob(VisualizationServer<V, E> viewer, boolean onlyResizeWhenTooBig) {
        if (!(viewer instanceof VisualizationViewer)) {
            throw new IllegalArgumentException("VisualizationServer is not an instance of VisualizationViewer.  We currently need this for bounds information.");
        }
        this.viewers.add((VisualizationViewer)viewer);
        this.onlyResizeWhenTooBig = onlyResizeWhenTooBig;
    }

    @Override
    public boolean canShortcut() {
        return true;
    }

    @Override
    public void execute(GraphJobListener listener) {
        try {
            this.doExecute();
        }
        finally {
            listener.jobFinished(this);
        }
    }

    private void doExecute() {
        if (this.isFinished) {
            return;
        }
        if (this.graphIsEmpty()) {
            return;
        }
        for (VisualizationViewer<V, E> viewer : this.viewers) {
            Rectangle graphBounds;
            boolean resized = this.scaleToFitViewer(viewer, graphBounds = GraphViewerUtils.getTotalGraphSizeInLayoutSpace(viewer));
            if (!resized) continue;
            this.centerGraph(viewer, graphBounds);
        }
        this.isFinished = true;
    }

    private boolean graphIsEmpty() {
        VisualizationViewer viewer = (VisualizationViewer)CollectionUtils.any(this.viewers);
        Graph graph = viewer.getGraphLayout().getGraph();
        return graph.getVertexCount() == 0;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void shortcut() {
        this.isFinished = true;
    }

    @Override
    public void dispose() {
        this.isFinished = true;
    }

    private boolean scaleToFitViewer(VisualizationViewer<V, E> visualizationViewer, Rectangle2D graphBounds) {
        boolean fitsInView;
        Dimension windowSize = visualizationViewer.getSize();
        Rectangle bounds = graphBounds.getBounds();
        Shape viewShape = GraphViewerUtils.translateShapeFromLayoutSpaceToViewSpace(bounds, visualizationViewer);
        Rectangle viewBounds = viewShape.getBounds();
        boolean bl = fitsInView = viewBounds.width < windowSize.width && viewBounds.height < windowSize.height;
        if (this.onlyResizeWhenTooBig && fitsInView) {
            return false;
        }
        Double scaleRatio = GraphViewerUtils.getScaleRatioToFitInDimension(bounds.getSize(), windowSize);
        if (scaleRatio == null) {
            return true;
        }
        if (scaleRatio > 1.0) {
            scaleRatio = 1.0;
        }
        int unscaledPaddingSize = 10;
        GraphViewerUtils.addPaddingToRectangle((int)((double)unscaledPaddingSize / scaleRatio), bounds);
        scaleRatio = GraphViewerUtils.getScaleRatioToFitInDimension(bounds.getSize(), windowSize);
        if (scaleRatio == null) {
            return true;
        }
        RenderContext renderContext = visualizationViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(Layer.VIEW);
        viewTransformer.setScale(scaleRatio.doubleValue(), scaleRatio.doubleValue(), (Point2D)new Point(0, 0));
        return true;
    }

    private void centerGraph(VisualizationViewer<V, E> visualizationViewer, Rectangle graphBounds) {
        RenderContext context = visualizationViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = context.getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(Layer.VIEW);
        viewTransformer.setTranslate(0.0, 0.0);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(Layer.LAYOUT);
        layoutTransformer.setTranslate(0.0, 0.0);
        Point2D viewCenter = visualizationViewer.getCenter();
        viewCenter = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(viewCenter, visualizationViewer);
        Point2D.Double graphCenter = new Point2D.Double(graphBounds.getCenterX(), graphBounds.getCenterY());
        double centerX = graphCenter.getX() - viewCenter.getX();
        double centerY = graphCenter.getY() - viewCenter.getY();
        layoutTransformer.setTranslate(-centerX, -centerY);
    }

    public String toString() {
        return "Fit Graph to View Job";
    }
}

