/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import ghidra.service.graph.GraphType;
import java.util.ArrayList;
import java.util.List;

public class GraphTypeBuilder {
    private List<String> vertexTypes = new ArrayList<String>();
    private List<String> edgeTypes = new ArrayList<String>();
    private final String name;
    private String description;

    public GraphTypeBuilder(String name) {
        this.name = name;
        this.description = name;
    }

    public GraphTypeBuilder description(String text) {
        this.description = text;
        return this;
    }

    public GraphTypeBuilder vertexType(String type) {
        this.vertexTypes.add(type);
        return this;
    }

    public GraphTypeBuilder edgeType(String type) {
        this.edgeTypes.add(type);
        return this;
    }

    public GraphType build() {
        return new GraphType(this.name, this.description, this.vertexTypes, this.edgeTypes);
    }
}

