/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import ghidra.framework.options.SaveState;

public class CallTreeOptions {
    private static final String DEFAULT_RECURSE_DEPTH = "5";
    private static final String RECURSE_DEPTH_KEY = "RECURSE_DEPTH";
    private static final String FILTER_DUPLICATES_KEY = "FILTER_DUPLICATES";
    private static final String FILTER_REFERENCES_KEY = "FILTER_REFERENCES";
    private static final String FILTER_THUNKS_KEY = "FILTER_THUNKS";
    private static final String SHOW_NAMESPACE_KEY = "SHOW_NAMESPACE";
    private boolean filterDuplicates = true;
    private boolean filterReferences = false;
    private boolean filterThunks = false;
    private boolean showNamespace = false;
    private int recurseDepth = Integer.parseInt("5");

    CallTreeOptions() {
    }

    CallTreeOptions(SaveState saveState) {
        this.filterDuplicates = saveState.getBoolean(FILTER_DUPLICATES_KEY, true);
        this.filterReferences = saveState.getBoolean(FILTER_REFERENCES_KEY, true);
        this.filterThunks = saveState.getBoolean(FILTER_THUNKS_KEY, false);
        this.showNamespace = saveState.getBoolean(SHOW_NAMESPACE_KEY, false);
        this.recurseDepth = saveState.getInt(RECURSE_DEPTH_KEY, this.recurseDepth);
    }

    void save(SaveState saveState) {
        saveState.putBoolean(FILTER_DUPLICATES_KEY, this.filterDuplicates);
        saveState.putBoolean(FILTER_REFERENCES_KEY, this.filterReferences);
        saveState.putBoolean(FILTER_THUNKS_KEY, this.filterThunks);
        saveState.putBoolean(SHOW_NAMESPACE_KEY, this.showNamespace);
        saveState.putInt(RECURSE_DEPTH_KEY, this.recurseDepth);
    }

    private CallTreeOptions copy() {
        CallTreeOptions newOptions = new CallTreeOptions();
        newOptions.filterDuplicates = this.filterDuplicates;
        newOptions.filterThunks = this.filterThunks;
        newOptions.showNamespace = this.showNamespace;
        newOptions.recurseDepth = this.recurseDepth;
        return newOptions;
    }

    public int getRecurseDepth() {
        return this.recurseDepth;
    }

    public boolean allowsDuplicates() {
        return !this.filterDuplicates;
    }

    public boolean allowsNonCallReferences() {
        return !this.filterReferences;
    }

    public boolean allowsThunks() {
        return !this.filterThunks;
    }

    public boolean showNamespace() {
        return this.showNamespace;
    }

    public CallTreeOptions withRecurseDepth(int depth) {
        CallTreeOptions copy = this.copy();
        copy.recurseDepth = depth;
        return copy;
    }

    public CallTreeOptions withFilterDuplicates(boolean filter) {
        CallTreeOptions copy = this.copy();
        copy.filterDuplicates = filter;
        return copy;
    }

    public CallTreeOptions withFilterReferences(boolean filter) {
        CallTreeOptions copy = this.copy();
        copy.filterReferences = filter;
        return copy;
    }

    public CallTreeOptions withFilterThunks(boolean filter) {
        CallTreeOptions copy = this.copy();
        copy.filterThunks = filter;
        return copy;
    }

    public CallTreeOptions withShowNamespace(boolean show) {
        CallTreeOptions copy = this.copy();
        copy.showNamespace = show;
        return copy;
    }
}

