/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.util.HelpLocation;

public class PreviewWindowAction
extends ToggleDockingAction {
    private final DataTypesProvider provider;

    public PreviewWindowAction(DataTypeManagerPlugin plugin, DataTypesProvider provider) {
        super("Show Preview Window", plugin.getName());
        this.provider = provider;
        this.setMenuBarData(new MenuData(new String[]{"Preview Window"}, null, "RefreshAfter"));
        this.setDescription("Toggled on shows a window containing a preview of the selected data type.");
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Preview_Window"));
    }

    public void setSelected(boolean newValue) {
        super.setSelected(newValue);
        this.provider.setPreviewWindowVisible(newValue);
    }
}

