/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import ghidra.app.plugin.core.symboltree.EditExternalLocationDialog;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.ImportsCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.LibrarySymbolNode;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;

public class CreateExternalLocationAction
extends SymbolTreeContextAction {
    private static ImageIcon EDIT_ICON = null;
    private final SymbolTreePlugin plugin;

    public CreateExternalLocationAction(SymbolTreePlugin plugin) {
        super("Create External Location", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Create External Location"}, (Icon)EDIT_ICON, "0External"));
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        Object object;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        return selectionPaths.length == 1 && ((object = selectionPaths[0].getLastPathComponent()) instanceof LibrarySymbolNode || object instanceof ImportsCategoryNode);
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return;
        }
        Object object = selectionPaths[0].getLastPathComponent();
        if (!(object instanceof LibrarySymbolNode) && !(object instanceof ImportsCategoryNode)) {
            return;
        }
        String externalName = null;
        if (object instanceof LibrarySymbolNode) {
            LibrarySymbolNode libraryNode = (LibrarySymbolNode)((Object)object);
            externalName = libraryNode.getName();
        }
        EditExternalLocationDialog dialog = new EditExternalLocationDialog(context.getProgram(), externalName);
        dialog.setHelpLocation(new HelpLocation("SymbolTreePlugin", "CreateExternalLocation"));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

