/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.opinion.PeLoader;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public class PEUtil {
    public static boolean canAnalyze(Program program) {
        String format = program.getExecutableFormat();
        if (format.equals("Portable Executable (PE)")) {
            return true;
        }
        if (format.equals("Raw Binary")) {
            MemoryByteProvider mbp = MemoryByteProvider.createDefaultAddressSpaceByteProvider((Program)program, (boolean)false);
            try {
                int peHeaderStartIndex;
                int peMagicNumber;
                BinaryReader reader = new BinaryReader((ByteProvider)mbp, true);
                DOSHeader dosHeader = new DOSHeader(reader);
                if (dosHeader.e_magic() == 23117 && (peMagicNumber = reader.readInt((long)(peHeaderStartIndex = dosHeader.e_lfanew()))) == 17744) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isVisualStudioOrClangPe(Program program) {
        return program.getExecutableFormat().equals("Portable Executable (PE)") && (program.getCompiler().equals(PeLoader.CompilerOpinion.CompilerEnum.VisualStudio.toString()) || program.getCompiler().equals(PeLoader.CompilerOpinion.CompilerEnum.Clang.toString()));
    }
}

