# frozen_string_literal: true

class RemoveIndexVulnerabilityFlagsOnVulnerabilityOccurrenceId < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_flags
  INDEX_NAME = 'index_vulnerability_flags_on_vulnerability_occurrence_id'
  COLUMNS = %i[vulnerability_occurrence_id]

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, COLUMNS, name: INDEX_NAME
  end
end
