/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.internal.CollectionUtils;

public class DefaultAsyncWorkTracker
implements AsyncWorkTracker {
    private final ListMultimap<BuildOperationRef, AsyncWorkCompletion> items = ArrayListMultimap.create();
    private final Set<BuildOperationRef> waiting = new HashSet<BuildOperationRef>();
    private final ReentrantLock lock = new ReentrantLock();
    private final WorkerLeaseService workerLeaseService;

    public DefaultAsyncWorkTracker(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public void registerWork(BuildOperationRef operation, AsyncWorkCompletion workCompletion) {
        this.lock.lock();
        try {
            if (this.waiting.contains(operation)) {
                throw new IllegalStateException("Another thread is currently waiting on the completion of work for the provided operation");
            }
            this.items.put((Object)operation, (Object)workCompletion);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion(BuildOperationRef operation, AsyncWorkTracker.ProjectLockRetention lockRetention) {
        ImmutableList workItems;
        this.lock.lock();
        try {
            workItems = ImmutableList.copyOf((Collection)this.items.get((Object)operation));
            this.startWaiting(operation, (List<AsyncWorkCompletion>)workItems);
        }
        finally {
            this.lock.unlock();
        }
        this.waitForAll(operation, (List<AsyncWorkCompletion>)workItems, lockRetention);
    }

    @Override
    public void waitForCompletion(BuildOperationRef operation, List<AsyncWorkCompletion> workItems, AsyncWorkTracker.ProjectLockRetention lockRetention) {
        this.startWaiting(operation, workItems);
        this.waitForAll(operation, workItems, lockRetention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAll(BuildOperationRef operation, List<AsyncWorkCompletion> workItems, AsyncWorkTracker.ProjectLockRetention lockRetention) {
        try {
            if (!workItems.isEmpty()) {
                this.waitForItemsAndGatherFailures(workItems, lockRetention);
            }
        }
        finally {
            this.stopWaiting(operation);
        }
    }

    private void waitForItemsAndGatherFailures(List<AsyncWorkCompletion> workItems, AsyncWorkTracker.ProjectLockRetention lockRetention) {
        switch (lockRetention) {
            case RETAIN_PROJECT_LOCKS: {
                this.waitForItemsAndGatherFailures(workItems);
                return;
            }
            case RELEASE_PROJECT_LOCKS: {
                this.workerLeaseService.runAsIsolatedTask();
                this.waitForItemsAndGatherFailures(workItems);
                return;
            }
            case RELEASE_AND_REACQUIRE_PROJECT_LOCKS: {
                if (!this.hasWorkInProgress(workItems)) {
                    this.waitForItemsAndGatherFailures(workItems);
                    return;
                }
                this.workerLeaseService.runAsIsolatedTask(() -> this.waitForItemsAndGatherFailures(workItems));
            }
        }
    }

    private boolean hasWorkInProgress(List<AsyncWorkCompletion> workItems) {
        return CollectionUtils.any(workItems, workCompletion -> !workCompletion.isComplete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUncompletedWork(BuildOperationRef operation) {
        this.lock.lock();
        try {
            List workItems = this.items.get((Object)operation);
            for (AsyncWorkCompletion workCompletion : workItems) {
                if (workCompletion.isComplete()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForItemsAndGatherFailures(Iterable<AsyncWorkCompletion> workItems) {
        this.workerLeaseService.withoutLock((ResourceLock)this.workerLeaseService.getCurrentWorkerLease(), () -> {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            for (AsyncWorkCompletion item : workItems) {
                try {
                    item.waitForCompletion();
                }
                catch (Throwable t) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.cancel(workItems);
                    }
                    failures.add(t);
                }
            }
            if (failures.size() > 0) {
                throw new DefaultMultiCauseException("There were failures while executing asynchronous work:", failures);
            }
        });
    }

    private void cancel(Iterable<AsyncWorkCompletion> workItems) {
        for (AsyncWorkCompletion workItem : workItems) {
            workItem.cancel();
        }
    }

    private void startWaiting(BuildOperationRef operation, List<AsyncWorkCompletion> workItems) {
        this.lock.lock();
        try {
            this.items.get((Object)operation).removeAll(workItems);
            this.waiting.add(operation);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopWaiting(BuildOperationRef operation) {
        this.lock.lock();
        try {
            this.waiting.remove(operation);
        }
        finally {
            this.lock.unlock();
        }
    }
}

