/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.exceptions;

import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.logging.text.TreeFormatter;

public class InvalidGpgKeyIdsException
extends GradleException {
    private final List<String> wrongKeys;

    public InvalidGpgKeyIdsException(List<String> wrongKeys) {
        this.wrongKeys = wrongKeys;
    }

    public void formatMessage(TreeFormatter formatter) {
        String documentLink = new DocumentationRegistry().getDocumentationRecommendationFor("on this", "dependency_verification", "sec:understanding-signature-verification");
        formatter.node(String.format("The following trusted GPG IDs are not in a minimum 160-bit fingerprint format (%s):", documentLink));
        formatter.startChildren();
        this.wrongKeys.stream().map(key -> String.format("'%s'", key)).forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
        formatter.endChildren();
    }

    public String getMessage() {
        TreeFormatter treeFormatter = new TreeFormatter();
        this.formatMessage(treeFormatter);
        return treeFormatter.toString();
    }
}

