/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitServerKeyVerifier
implements ServerKeyVerifier,
ServerKeyLookup {
    private static final Logger LOG = LoggerFactory.getLogger(JGitServerKeyVerifier.class);
    @NonNull
    private final ServerKeyDatabase database;

    public JGitServerKeyVerifier(@NonNull ServerKeyDatabase database) {
        this.database = database;
    }

    @Override
    public List<PublicKey> lookup(ClientSession session, SocketAddress remoteAddress) {
        if (!(session instanceof JGitClientSession)) {
            LOG.warn("Internal error: wrong session kind: " + session.getClass().getName());
            return Collections.emptyList();
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return Collections.emptyList();
        }
        SessionConfig config = new SessionConfig((JGitClientSession)session);
        SshdSocketAddress connectAddress = SshdSocketAddress.toSshdSocketAddress((SocketAddress)session.getConnectAddress());
        String connect = KnownHostHashValue.createHostPattern((String)connectAddress.getHostName(), (int)connectAddress.getPort());
        return this.database.lookup(connect, (InetSocketAddress)remoteAddress, config);
    }

    public boolean verifyServerKey(ClientSession session, SocketAddress remoteAddress, PublicKey serverKey) {
        if (!(session instanceof JGitClientSession)) {
            LOG.warn("Internal error: wrong session kind: " + session.getClass().getName());
            return false;
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return false;
        }
        SessionConfig config = new SessionConfig((JGitClientSession)session);
        SshdSocketAddress connectAddress = SshdSocketAddress.toSshdSocketAddress((SocketAddress)session.getConnectAddress());
        String connect = KnownHostHashValue.createHostPattern((String)connectAddress.getHostName(), (int)connectAddress.getPort());
        CredentialsProvider provider = ((JGitClientSession)session).getCredentialsProvider();
        return this.database.accept(connect, (InetSocketAddress)remoteAddress, serverKey, config, provider);
    }

    private static class SessionConfig
    implements ServerKeyDatabase.Configuration {
        private final JGitClientSession session;

        public SessionConfig(JGitClientSession session) {
            this.session = session;
        }

        private List<String> get(String key) {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            if (entry instanceof JGitHostConfigEntry) {
                return ((JGitHostConfigEntry)entry).getMultiValuedOptions().get(key);
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> getUserKnownHostsFiles() {
            return this.get("UserKnownHostsFile");
        }

        @Override
        public List<String> getGlobalKnownHostsFiles() {
            return this.get("GlobalKnownHostsFile");
        }

        @Override
        public ServerKeyDatabase.Configuration.StrictHostKeyChecking getStrictHostKeyChecking() {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            String value = entry.getProperty("StrictHostKeyChecking", "ask");
            switch (value.toLowerCase(Locale.ROOT)) {
                case "on": 
                case "yes": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.REQUIRE_MATCH;
                }
                case "no": 
                case "off": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ACCEPT_ANY;
                }
                case "accept-new": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ACCEPT_NEW;
                }
            }
            return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ASK;
        }

        @Override
        public boolean getHashKnownHosts() {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            return OpenSshConfigFile.flag((String)entry.getProperty("HashKnownHosts"));
        }

        @Override
        public String getUsername() {
            return this.session.getUsername();
        }
    }
}

