/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.Rectangle;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.IHelpBrowser;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;

public class HyperlinkHandler
implements HyperlinkListener {
    private final IHelpBrowser browser;
    private final JosmEditorPane help;

    public HyperlinkHandler(IHelpBrowser browser, JosmEditorPane help) {
        this.browser = Objects.requireNonNull(browser);
        this.help = Objects.requireNonNull(help);
    }

    protected boolean scrollToElementWithId(String id) {
        Document d = this.help.getDocument();
        if (d instanceof HTMLDocument) {
            Element element = ((HTMLDocument)d).getElement(id);
            try {
                Rectangle r;
                if (element != null && (r = this.help.modelToView(element.getStartOffset())) != null) {
                    Rectangle vis = this.help.getVisibleRect();
                    r.height = vis.height;
                    this.help.scrollRectToVisible(r);
                    return true;
                }
            }
            catch (BadLocationException e) {
                Logging.warn(I18n.tr("Bad location in HTML document. Exception was: {0}", e.toString()));
                Logging.error(e);
            }
        }
        return false;
    }

    protected String getUrlFragment(HyperlinkEvent e) {
        AttributeSet set = e.getSourceElement().getAttributes();
        Object value = set.getAttribute(HTML.Tag.A);
        if (!(value instanceof SimpleAttributeSet)) {
            return null;
        }
        SimpleAttributeSet atts = (SimpleAttributeSet)value;
        if ((value = atts.getAttribute(HTML.Attribute.HREF)) == null) {
            return null;
        }
        String s = (String)value;
        Matcher m = Pattern.compile("(?:" + this.browser.getUrl() + ")?#(.+)").matcher(s);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (e.getURL() == null || e.getURL().toExternalForm().startsWith(this.browser.getUrl() + "#")) {
            String fragment = this.getUrlFragment(e);
            if (fragment != null) {
                if (!this.scrollToElementWithId(fragment)) {
                    this.help.scrollToReference(fragment);
                }
            } else {
                HelpAwareOptionPane.showOptionDialog(HelpBrowser.getInstance(), I18n.tr("Failed to open help page. The target URL is empty.", new Object[0]), I18n.tr("Failed to open help page", new Object[0]), 0, null, null, null, null);
            }
        } else if (e.getURL().toExternalForm().endsWith("action=edit")) {
            OpenBrowser.displayUrl(e.getURL().toExternalForm());
        } else {
            String url = e.getURL().toExternalForm();
            this.browser.setUrl(url);
            if (url.startsWith(HelpUtil.getWikiBaseUrl())) {
                this.browser.openUrl(url);
            } else {
                OpenBrowser.displayUrl(url);
            }
        }
    }
}

