/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.jcs3.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.ScanexTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.CachedAttributionBingAerialTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.JosmTemplatedTMSTileSource;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.tools.Logging;

public class TMSLayer
extends AbstractCachedTileSourceLayer<TMSTileSource>
implements NativeScaleLayer {
    private static final String CACHE_REGION_NAME = "TMS";
    private static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", AbstractTileSourceLayer.PROP_MIN_ZOOM_LVL.get());
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", AbstractTileSourceLayer.PROP_MAX_ZOOM_LVL.get());
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);
    public static final int MAX_ZOOM = 24;
    public static final int MIN_ZOOM = 0;
    private static final NativeScaleLayer.ScaleList nativeScaleList = TMSLayer.initNativeScaleList();

    public TMSLayer(ImageryInfo info) {
        super(info);
    }

    @Override
    protected TMSTileSource getTileSource() {
        return TMSLayer.getTileSourceStatic(this.info, () -> {
            Logging.debug("Attribution loaded, running clearErrorTiles");
            this.clearErrorTiles();
        });
    }

    @Override
    public Collection<String> getNativeProjections() {
        return Collections.singletonList("EPSG:3857");
    }

    public static AbstractTMSTileSource getTileSourceStatic(ImageryInfo info) {
        return TMSLayer.getTileSourceStatic(info, null);
    }

    public static TMSTileSource getTileSourceStatic(ImageryInfo info, Runnable attributionLoadedTask) {
        if (info.getImageryType() == ImageryInfo.ImageryType.TMS) {
            JosmTemplatedTMSTileSource.checkUrl(info.getUrl());
            JosmTemplatedTMSTileSource t = new JosmTemplatedTMSTileSource(info);
            info.setAttribution(t);
            return t;
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new CachedAttributionBingAerialTileSource(info, attributionLoadedTask);
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new ScanexTileSource(info);
        }
        return null;
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return TMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    @Override
    public NativeScaleLayer.ScaleList getNativeScales() {
        return nativeScaleList;
    }

    private static NativeScaleLayer.ScaleList initNativeScaleList() {
        Collection scales = IntStream.rangeClosed(2, 30).mapToDouble(zoom -> 4.007501668557849E7 / Math.pow(2.0, zoom) / 256.0).boxed().collect(Collectors.toList());
        return new NativeScaleLayer.ScaleList(scales);
    }
}

