/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.Objects;

public class Pair<T1, T2> {
    private final T1 t1;
    private final T2 t2;
    private final int hashCode;

    public Pair(T1 t1, T2 t2) {
        this.t1 = t1;
        this.t2 = t2;
        this.hashCode = Objects.hash(t1, t2);
    }

    public T1 get1st() {
        return this.t1;
    }

    public T2 get2nd() {
        return this.t2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (null != obj && obj instanceof Pair) {
            assert (obj instanceof Pair) : "wrong type";
            Pair that = (Pair)obj;
            return this.t1.equals(that.t1) && this.t2.equals(that.t2);
        }
        return false;
    }

    public String toString() {
        return "" + '[' + this.get1st() + ", " + this.get2nd() + ']';
    }
}

